/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.utils;

import java.util.Collection;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypePromoter {
    private Class<? extends AnyAtomicType> targetType = null;

    public abstract AnyAtomicType doPromote(AnyAtomicType var1) throws DynamicError;

    public final AnyAtomicType promote(AnyType value) throws DynamicError {
        if (value.getClass() == this.getTargetType()) {
            return (AnyAtomicType)value;
        }
        return this.doPromote(this.atomize(value));
    }

    protected abstract Class<? extends AnyAtomicType> substitute(Class<? extends AnyAtomicType> var1);

    protected abstract boolean checkCombination(Class<? extends AnyAtomicType> var1);

    public void considerType(Class<? extends AnyAtomicType> typeToConsider) throws DynamicError {
        Class<? extends AnyAtomicType> baseType = this.substitute(typeToConsider);
        if (baseType == null) {
            throw DynamicError.argument_type_error(typeToConsider);
        }
        if (this.targetType == null) {
            this.targetType = baseType;
        } else if (!this.checkCombination(baseType)) {
            throw DynamicError.argument_type_error(typeToConsider);
        }
    }

    public void considerTypes(Collection<Class<? extends AnyAtomicType>> typesToConsider) throws DynamicError {
        for (Class<? extends AnyAtomicType> type : typesToConsider) {
            this.considerType(type);
        }
    }

    public void considerSequence(ResultSequence sequenceToConsider) throws DynamicError {
        int i = 0;
        while (i < sequenceToConsider.size()) {
            AnyType item = sequenceToConsider.get(i);
            this.considerValue(item);
            ++i;
        }
    }

    public Class<? extends AnyAtomicType> getTargetType() {
        return this.targetType;
    }

    protected void setTargetType(Class<? extends AnyAtomicType> class1) {
        this.targetType = class1;
    }

    public AnyAtomicType atomize(AnyType at) {
        if (at instanceof NodeType) {
            return (AnyAtomicType)((NodeType)at).typed_value().first();
        }
        return (AnyAtomicType)at;
    }

    public void considerValue(AnyType at) throws DynamicError {
        this.considerType(this.atomize(at).getClass());
    }
}

