/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.wizards.JUnitWizard;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewTestCaseCreationWizard
extends JUnitWizard {
    private NewTestCaseWizardPageOne fPage1;
    private NewTestCaseWizardPageTwo fPage2;

    public NewTestCaseCreationWizard() {
        this.setWindowTitle(WizardMessages.Wizard_title_new_testcase);
        this.initDialogSettings();
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(JUnitPlugin.getImageDescriptor("wizban/newtest_wiz.png"));
    }

    public void addPages() {
        super.addPages();
        this.fPage2 = new NewTestCaseWizardPageTwo();
        this.fPage1 = new NewTestCaseWizardPageOne(this.fPage2);
        this.addPage((IWizardPage)this.fPage1);
        this.fPage1.init(this.getSelection());
        this.addPage((IWizardPage)this.fPage2);
    }

    public boolean performFinish() {
        IJavaProject project = this.fPage1.getJavaProject();
        IRunnableWithProgress runnable = this.fPage1.getRunnable();
        try {
            if (this.fPage1.isJUnit4()) {
                if (project.findType("org.junit.Test") == null) {
                    runnable = this.addJUnitToClasspath(project, runnable, true);
                }
            } else if (project.findType("junit.framework.TestCase") == null) {
                runnable = this.addJUnitToClasspath(project, runnable, false);
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        if (this.finishPage(runnable)) {
            IType newClass = this.fPage1.getCreatedType();
            IResource resource = newClass.getCompilationUnit().getResource();
            if (resource != null) {
                this.selectAndReveal(resource);
                this.openResource(resource);
            }
            return true;
        }
        return false;
    }

    private IRunnableWithProgress addJUnitToClasspath(IJavaProject project, final IRunnableWithProgress runnable, boolean isJUnit4) {
        String typeToLookup = isJUnit4 ? "org.junit.*" : "junit.awtui.*";
        ClasspathFixProcessor.ClasspathFixProposal[] fixProposals = ClasspathFixProcessor.getContributedFixImportProposals((IJavaProject)project, (String)typeToLookup, null);
        ClasspathFixSelectionDialog dialog = new ClasspathFixSelectionDialog(this.getShell(), isJUnit4, project, fixProposals);
        if (dialog.open() != 0) {
            throw new OperationCanceledException();
        }
        final ClasspathFixProcessor.ClasspathFixProposal fix = dialog.getSelectedClasspathFix();
        if (fix != null) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(WizardMessages.NewTestCaseCreationWizard_create_progress, 4);
                    try {
                        try {
                            Change change = fix.createChange((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            new PerformChangeOperation(change).run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            runnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
        }
        return runnable;
    }

    private static class ClasspathFixSelectionDialog
    extends MessageDialog
    implements SelectionListener,
    IDoubleClickListener {
        private final ClasspathFixProcessor.ClasspathFixProposal[] fFixProposals;
        private final IJavaProject fProject;
        private TableViewer fFixSelectionTable;
        private Button fNoActionRadio;
        private Button fOpenBuildPathRadio;
        private Button fPerformFix;
        private ClasspathFixProcessor.ClasspathFixProposal fSelectedFix;
        private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
        private static final Object BUILD_PATH_BLOCK = "block_until_buildpath_applied";

        public ClasspathFixSelectionDialog(Shell parent, boolean isJUnit4, IJavaProject project, ClasspathFixProcessor.ClasspathFixProposal[] fixProposals) {
            super(parent, WizardMessages.Wizard_title_new_testcase, null, ClasspathFixSelectionDialog.getDialogMessage(isJUnit4), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fProject = project;
            this.fFixProposals = fixProposals;
            this.fSelectedFix = null;
        }

        protected boolean isResizable() {
            return true;
        }

        private static String getDialogMessage(boolean isJunit4) {
            return isJunit4 ? WizardMessages.NewTestCaseCreationWizard_fix_selection_junit4_description : WizardMessages.NewTestCaseCreationWizard_fix_selection_junit3_description;
        }

        protected Control createCustomArea(Composite composite) {
            this.fNoActionRadio = new Button(composite, 16);
            this.fNoActionRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fNoActionRadio.setText(WizardMessages.NewTestCaseCreationWizard_fix_selection_not_now);
            this.fNoActionRadio.addSelectionListener((SelectionListener)this);
            this.fOpenBuildPathRadio = new Button(composite, 16);
            this.fOpenBuildPathRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOpenBuildPathRadio.setText(WizardMessages.NewTestCaseCreationWizard_fix_selection_open_build_path_dialog);
            this.fOpenBuildPathRadio.addSelectionListener((SelectionListener)this);
            if (this.fFixProposals.length > 0) {
                this.fPerformFix = new Button(composite, 16);
                this.fPerformFix.setLayoutData((Object)new GridData(16384, 128, false, false));
                this.fPerformFix.setText(WizardMessages.NewTestCaseCreationWizard_fix_selection_invoke_fix);
                this.fPerformFix.addSelectionListener((SelectionListener)this);
                this.fFixSelectionTable = new TableViewer(composite, 2052);
                this.fFixSelectionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.fFixSelectionTable.setLabelProvider((IBaseLabelProvider)new ClasspathFixLabelProvider());
                this.fFixSelectionTable.setComparator(new ViewerComparator());
                this.fFixSelectionTable.addDoubleClickListener((IDoubleClickListener)this);
                this.fFixSelectionTable.setInput((Object)this.fFixProposals);
                this.fFixSelectionTable.setSelection((ISelection)new StructuredSelection((Object)this.fFixProposals[0]));
                GridData gridData = new GridData(4, 4, true, true);
                gridData.heightHint = this.convertHeightInCharsToPixels(4);
                gridData.horizontalIndent = this.convertWidthInCharsToPixels(2);
                this.fFixSelectionTable.getControl().setLayoutData((Object)gridData);
                this.fNoActionRadio.setSelection(false);
                this.fOpenBuildPathRadio.setSelection(false);
                this.fPerformFix.setSelection(true);
            } else {
                this.fNoActionRadio.setSelection(true);
                this.fOpenBuildPathRadio.setSelection(false);
            }
            this.updateEnableStates();
            return composite;
        }

        private void updateEnableStates() {
            if (this.fPerformFix != null) {
                this.fFixSelectionTable.getTable().setEnabled(this.fPerformFix.getSelection());
            }
        }

        protected void buttonPressed(int buttonId) {
            this.fSelectedFix = null;
            if (buttonId == 0 && !this.fNoActionRadio.getSelection()) {
                IStructuredSelection selection;
                Object firstElement;
                if (this.fOpenBuildPathRadio.getSelection()) {
                    String id = BUILD_PATH_PAGE_ID;
                    HashMap<Object, Boolean> input = new HashMap<Object, Boolean>();
                    input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
                    if (PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)id, (String[])new String[]{id}, input).open() != 0) {
                        return;
                    }
                } else if (this.fFixSelectionTable != null && (firstElement = (selection = (IStructuredSelection)this.fFixSelectionTable.getSelection()).getFirstElement()) instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    this.fSelectedFix = (ClasspathFixProcessor.ClasspathFixProposal)firstElement;
                }
            }
            super.buttonPressed(buttonId);
        }

        public ClasspathFixProcessor.ClasspathFixProposal getSelectedClasspathFix() {
            return this.fSelectedFix;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void doubleClick(DoubleClickEvent event) {
            this.okPressed();
        }

        static class ClasspathFixLabelProvider
        extends LabelProvider {
            ClasspathFixLabelProvider() {
            }

            public Image getImage(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getImage();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getDisplayString();
                }
                return null;
            }
        }
    }
}

