/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf.interfaces;

import java.util.List;

import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiAlarmEvent;

public interface IAlarmTransactions {

	public  List<SbiAlarmEvent> alarmTransactionFindActiveAlarmEvents() 
	throws Exception ;
	
	public  void alarmTransactionUpdateSbiAlarmEvent(SbiAlarmEvent ev) 
	throws Exception ;
	
	public boolean alarmTransactionCreateNewSbiAlarmEvent( SbiAlarmEvent ev) throws Exception ;
	
	public boolean alarmTransactionMergeSbiAlarm(SbiAlarm sbiAlarm) throws Exception ;
	
	public  SbiAlarm alarmTransactionloadSbiAlarmByLabel(String alarmLabel) 
	throws Exception ;

	public List<SbiAlarm> loadSbiAlarmListByEventId(Double eventId) 
	throws Exception ;
}
