/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the sbi_alarm_event database table.
 * 
 */
@Entity
@Table(name="SBI_ALARM_EVENT")
public class SbiAlarmEvent implements Serializable {
	private static final long serialVersionUID = 1L;

	@TableGenerator(name="AlarmEventId", table="ID_GEN",
	            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
	            pkColumnValue="ALARM_EVENT_ID", allocationSize=1)
	@Id
	@GeneratedValue(generator="AlarmEventId", strategy=GenerationType.TABLE)   
	@Column(name="ALARM_EVENT_ID")
	private Integer alarmEventId;

	@Column(name="ACTIVE")
	private String active;

    @Temporal( TemporalType.TIMESTAMP)
	@Column(name="EVENT_TS")
	private Date eventTs;

	@Column(name="KPI_DESCRIPTION")
	private String kpiDescription;

	@Column(name="KPI_INSTANCE_ID")
	private int kpiInstanceId;

	@Column(name="KPI_NAME")
	private String kpiName;

	@Column(name="KPI_VALUE")
	private String kpiValue;

	@Column(name="RESOURCE_ID")
	private int resourceId;

	@Column(name="RESOURCES")
	private String resources;

	@Column(name="THRESHOLD_VALUE")
	private String thresholdValue;


	//bi-directional many-to-one association to SbiAlarm
	@ManyToOne( fetch = FetchType.LAZY)
	@JoinColumn(name="ALARM_ID")
	private SbiAlarm sbiAlarm;

    public SbiAlarmEvent() {
    }

	public int getAlarmEventId() {
		return this.alarmEventId;
	}

	public void setAlarmEventId(int alarmEventId) {
		this.alarmEventId = alarmEventId;
	}

	public String getActive() {
		return this.active;
	}

	public void setActive(String active) {
		this.active = active;
	}

	public Date getEventTs() {
		return this.eventTs;
	}

	public void setEventTs(Date eventTs) {
		this.eventTs = eventTs;
	}

	public String getKpiDescription() {
		return this.kpiDescription;
	}

	public void setKpiDescription(String kpiDescription) {
		this.kpiDescription = kpiDescription;
	}

	public int getKpiInstanceId() {
		return this.kpiInstanceId;
	}

	public void setKpiInstanceId(int kpiInstanceId) {
		this.kpiInstanceId = kpiInstanceId;
	}

	public String getKpiName() {
		return this.kpiName;
	}

	public void setKpiName(String kpiName) {
		this.kpiName = kpiName;
	}

	public String getKpiValue() {
		return this.kpiValue;
	}

	public void setKpiValue(String kpiValue) {
		this.kpiValue = kpiValue;
	}

	public int getResourceId() {
		return this.resourceId;
	}

	public void setResourceId(int resourceId) {
		this.resourceId = resourceId;
	}

	public String getResources() {
		return this.resources;
	}

	public void setResources(String resources) {
		this.resources = resources;
	}

	public String getThresholdValue() {
		return this.thresholdValue;
	}

	public void setThresholdValue(String thresholdValue) {
		this.thresholdValue = thresholdValue;
	}

	public SbiAlarm getSbiAlarm() {
		return this.sbiAlarm;
	}

	public void setSbiAlarm(SbiAlarm sbiAlarm) {
		this.sbiAlarm = sbiAlarm;
	}
	
}