/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.jms.marshaler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.ebpm.connectors.jms.marshaler.BaseJmsMarshaler;
import org.eclipse.ebpm.connectors.jms.marshaler.JmsProviderMarshaler;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.soap.api.Interceptor;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.core.MessageImpl;
import org.eclipse.ebpm.soap.core.PhaseInterceptorChain;
import org.eclipse.ebpm.soap.interceptors.mime.AttachmentsInInterceptor;
import org.eclipse.ebpm.soap.interceptors.mime.AttachmentsOutInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.BodyOutInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.StaxInInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.StaxOutInterceptor;
import org.eclipse.ebpm.soap.util.DomUtil;
import org.w3c.dom.Document;

public class DefaultProviderMarshaler
extends BaseJmsMarshaler
implements JmsProviderMarshaler {
    private Map<String, Object> jmsProperties;

    public Map<String, Object> getJmsProperties() {
        return this.jmsProperties;
    }

    public void setJmsProperties(Map<String, Object> jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    @Override
    public javax.jms.Message createMessage(Exchange exchange, org.eclipse.ebpm.messaging.api.Message in, Session session) throws Exception {
        String correlationId;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PhaseInterceptorChain chain = new PhaseInterceptorChain();
        chain.add((Interceptor)new AttachmentsOutInterceptor());
        chain.add((Interceptor)new StaxOutInterceptor());
        chain.add((Interceptor)new BodyOutInterceptor());
        MessageImpl msg = new MessageImpl();
        Document document = DomUtil.parse((Source)new StreamSource(new StringReader(in.getBodyText())));
        msg.setContent(Document.class, (Object)document);
        msg.setContent(OutputStream.class, (Object)baos);
        for (String attId : in.getAttachments().keySet()) {
            msg.getAttachments().put(attId, (DataHandler)in.getAttachment(attId));
        }
        chain.doIntercept((Message)msg);
        TextMessage text = session.createTextMessage(baos.toString());
        if (msg.get((Object)"Content-Type") != null) {
            text.setStringProperty("SOAPJMS_contentType", (String)msg.get((Object)"Content-Type"));
        }
        if (this.jmsProperties != null) {
            for (Map.Entry<String, Object> e : this.jmsProperties.entrySet()) {
                text.setObjectProperty(e.getKey(), e.getValue());
            }
        }
        if ((correlationId = (String)in.getHeader("org.spagic3.components.jms.correlationId")) != null) {
            text.setJMSCorrelationID(correlationId);
        }
        if (this.isCopyProperties()) {
            this.copyPropertiesFromNormalizedMessage(in, (javax.jms.Message)text);
        }
        return text;
    }

    @Override
    public void populateMessage(javax.jms.Message message, Exchange exchange, org.eclipse.ebpm.messaging.api.Message normalizedMessage) throws Exception {
        if (message instanceof TextMessage) {
            PhaseInterceptorChain chain = new PhaseInterceptorChain();
            chain.add((Interceptor)new AttachmentsInInterceptor());
            chain.add((Interceptor)new StaxInInterceptor());
            MessageImpl msg = new MessageImpl();
            msg.setContent(InputStream.class, (Object)new ByteArrayInputStream(((TextMessage)message).getText().getBytes()));
            if (message.propertyExists("SOAPJMS_contentType")) {
                msg.put((Object)"Content-Type", (Object)message.getStringProperty("SOAPJMS_contentType"));
            }
            chain.doIntercept((Message)msg);
            XMLStreamReader xmlReader = (XMLStreamReader)msg.getContent(XMLStreamReader.class);
            StAXSource src = new StAXSource(xmlReader);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer xform = tfactory.newTransformer();
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            xform.transform(src, result);
            normalizedMessage.setBody(writer.toString());
            for (Map.Entry attachment : msg.getAttachments().entrySet()) {
                normalizedMessage.addAttachment((String)attachment.getKey(), attachment.getValue());
            }
            if (this.isCopyProperties()) {
                this.copyPropertiesFromJMSMessage(message, normalizedMessage);
            }
        } else {
            throw new UnsupportedOperationException("JMS message is not a TextMessage");
        }
    }
}

