/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.serviceregistration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ebpm.databasemanager.IDatabaseManager;
import org.eclipse.ebpm.service.model.IServiceModelHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private ServiceTracker dbServiceTracker;
    private ServiceTracker serviceModelTracker;
    protected Logger log = LoggerFactory.getLogger(Activator.class);
    public static final List<String> TRANSIENT_PROPERTIES = Arrays.asList("factory.name", "SPAGIC_TYPE", "event.topics");

    public void start(BundleContext context) throws Exception {
    }

    public void stop(BundleContext context) throws Exception {
    }

    public IDatabaseManager getDbManager() {
        this.log.info("##########" + this.dbServiceTracker);
        this.log.info("##########" + this.dbServiceTracker.getService());
        return (IDatabaseManager)this.dbServiceTracker.getService();
    }

    public IServiceModelHelper getServiceModelHelper() {
        return (IServiceModelHelper)this.serviceModelTracker.getService();
    }

    public class DatabaseServiceTracker
    extends ServiceTracker {
        public DatabaseServiceTracker(BundleContext context) {
            super(context, IDatabaseManager.class.getName(), null);
        }
    }

    public class SpagicServiceCustomizer
    implements ServiceTrackerCustomizer {
        public Object addingService(ServiceReference reference) {
            String serviceId = (String)reference.getProperty("spagic.id");
            String factoryName = (String)reference.getProperty("factory.name");
            HashMap<String, String> properties = new HashMap<String, String>(reference.getPropertyKeys().length);
            String[] stringArray = reference.getPropertyKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String propKey = stringArray[n2];
                Object propValue = reference.getProperty(propKey);
                Activator.this.log.debug(String.valueOf(propKey) + "=" + propValue);
                if (propValue instanceof String && !TRANSIENT_PROPERTIES.contains(propKey)) {
                    properties.put(propKey, (String)propValue);
                }
                ++n2;
            }
            if (factoryName == null) {
                return reference;
            }
            String componentName = Activator.this.getServiceModelHelper().getComponentName(factoryName);
            if (componentName != null && componentName.length() != 0) {
                Activator.this.getDbManager().registerService(serviceId, componentName, properties);
            }
            return reference;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
        }
    }
}

