/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.util.stax;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class StaxSource
extends SAXSource
implements XMLReader {
    private XMLStreamReader streamReader;
    private ContentHandler contentHandler;

    public StaxSource(XMLStreamReader streamReader) {
        this.streamReader = streamReader;
        this.setInputSource(new InputSource());
    }

    @Override
    public XMLReader getXMLReader() {
        return this;
    }

    public XMLStreamReader getStreamReader() {
        return this.streamReader;
    }

    protected void parse() throws SAXException {
        try {
            this.contentHandler.startDocument();
            while (true) {
                switch (this.streamReader.getEventType()) {
                    case 10: 
                    case 12: {
                        break;
                    }
                    case 4: {
                        int length = this.streamReader.getTextLength();
                        int start = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.contentHandler.characters(chars, start, length);
                        break;
                    }
                    case 5: 
                    case 11: {
                        break;
                    }
                    case 8: {
                        this.contentHandler.endDocument();
                        return;
                    }
                    case 2: {
                        String uri = this.streamReader.getNamespaceURI();
                        String localName = this.streamReader.getLocalName();
                        String prefix = this.streamReader.getPrefix();
                        String qname = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
                        this.contentHandler.endElement(uri, localName, qname);
                        int i = 0;
                        while (i < this.streamReader.getNamespaceCount()) {
                            ++i;
                        }
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 13: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    case 1: {
                        int i = 0;
                        while (i < this.streamReader.getNamespaceCount()) {
                            ++i;
                        }
                        String uri = this.streamReader.getNamespaceURI();
                        String localName = this.streamReader.getLocalName();
                        String prefix = this.streamReader.getPrefix();
                        String qname = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
                        this.contentHandler.startElement(uri != null ? uri : "", localName, qname, this.getAttributes());
                    }
                }
                this.streamReader.next();
            }
        }
        catch (XMLStreamException e) {
            if (e.getLocation() != null) {
                throw new SAXParseException(e.getMessage(), null, null, e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e);
            }
            throw new SAXParseException(e.getMessage(), null, null, -1, -1, e);
        }
    }

    protected String getQualifiedName() {
        String prefix = this.streamReader.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            return String.valueOf(prefix) + ":" + this.streamReader.getLocalName();
        }
        return this.streamReader.getLocalName();
    }

    protected Attributes getAttributes() {
        AttributesImpl attrs = new AttributesImpl();
        int i = 0;
        while (i < this.streamReader.getNamespaceCount()) {
            String prefix = this.streamReader.getNamespacePrefix(i);
            String uri = this.streamReader.getNamespaceURI(i);
            if (uri == null) {
                uri = "";
            }
            if (prefix == null || prefix.length() == 0) {
                attrs.addAttribute("", null, "xmlns", "CDATA", uri);
            } else {
                attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, "CDATA", uri);
            }
            ++i;
        }
        i = 0;
        while (i < this.streamReader.getAttributeCount()) {
            String uri = this.streamReader.getAttributeNamespace(i);
            String localName = this.streamReader.getAttributeLocalName(i);
            String prefix = this.streamReader.getAttributePrefix(i);
            String qName = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ':' + localName : localName;
            String type = this.streamReader.getAttributeType(i);
            String value = this.streamReader.getAttributeValue(i);
            if (value == null) {
                value = "";
            }
            attrs.addAttribute(uri, localName, qName, type, value);
            ++i;
        }
        return attrs;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        this.parse();
    }

    @Override
    public void parse(String systemId) throws SAXException {
        this.parse();
    }
}

