/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.http.adapters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.util.StringUtil;

public class SpagicJettyHTTPExchange
extends HttpExchange {
    int responseStatus;
    HttpFields responseFields = new HttpFields();
    String encoding = "utf-8";
    ByteArrayOutputStream responseContent;
    int contentLength;

    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        this.responseStatus = status;
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this.responseFields != null) {
            this.responseFields.add(name, value);
        }
        int header = HttpHeaders.CACHE.getOrdinal(value);
        switch (header) {
            case 11: {
                this.contentLength = BufferUtil.toInt((Buffer)value);
                break;
            }
            case 16: {
                String mime = StringUtil.asciiToLowerCase((String)value.toString());
                int i = mime.indexOf("charset=");
                if (i > 0 && (i = (mime = mime.substring(i + 8)).indexOf(59)) > 0) {
                    mime = mime.substring(0, i);
                }
                if (mime == null || mime.length() <= 0) break;
                this.encoding = mime;
                break;
            }
        }
    }

    protected void onResponseContent(Buffer content) throws IOException {
        if (this.responseContent == null) {
            this.responseContent = new ByteArrayOutputStream(this.contentLength);
        }
        content.writeTo((OutputStream)this.responseContent);
    }

    public byte[] getResponse() throws UnsupportedEncodingException {
        if (this.responseContent != null) {
            return this.responseContent.toByteArray();
        }
        return null;
    }

    public HttpFields getResponseFields() {
        return this.responseFields;
    }

    public ByteArrayOutputStream getResponseContent() {
        return this.responseContent;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public String getResponseEncoding() {
        return this.encoding;
    }
}

