/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.osgi_over_slf4j;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class OSGiOverlSLF4jActivator
implements BundleActivator {
    private static Logger logger = null;
    private ServiceTracker logTracker = null;

    static {
        logger = LoggerFactory.getLogger((String)"OSGi");
    }

    public void start(BundleContext context) throws Exception {
        System.out.println("**********************************************************************");
        System.out.println("***************  OSGi OVER SLF4J ACTIVATED ***************************");
        Context lc = (Context)LoggerFactory.getILoggerFactory();
        StatusPrinter.print((Context)lc);
        System.out.println("**********************************************************************");
        Filter filter = context.createFilter("(objectClass=org.osgi.service.log.LogReaderService)");
        this.logTracker = new LogServiceTracker(context, filter);
        this.logTracker.open(true);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.logTracker != null) {
            this.logTracker.close();
        }
    }

    private class LogServiceTracker
    extends ServiceTracker {
        public LogServiceTracker(BundleContext ctx, Filter filter) {
            super(ctx, filter, null);
        }

        public Object addingService(ServiceReference reference) {
            Object service = this.context.getService(reference);
            ((LogReaderService)service).addLogListener((LogListener)new TOSLF4JLogListener());
            return super.addingService(reference);
        }
    }

    private class TOSLF4JLogListener
    implements LogListener {
        private TOSLF4JLogListener() {
        }

        public void logged(LogEntry entry) {
            this.logLogEntry(logger, entry.getLevel(), MarkerFactory.getMarker((String)entry.getBundle().getSymbolicName()), entry.getMessage(), entry.getException());
        }

        private void logLogEntry(Logger logger, int level, Marker marker, String message, Throwable t) {
            switch (level) {
                case 4: {
                    logger.debug(marker, message, t);
                    break;
                }
                case 1: {
                    logger.error(marker, "[" + marker.getName() + "]" + message, t);
                    break;
                }
                case 2: {
                    logger.warn(marker, message, t);
                    break;
                }
                default: {
                    logger.info(marker, message, t);
                }
            }
        }
    }
}

