/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;

public class MetaTypeProviderTracker
implements MetaTypeInformation {
    public static final String MANAGED_SERVICE = "org.osgi.service.cm.ManagedService";
    public static final String MANAGED_SERVICE_FACTORY = "org.osgi.service.cm.ManagedServiceFactory";
    public static final String FILTER_STRING = "(|(objectClass=org.osgi.service.cm.ManagedService)(objectClass=org.osgi.service.cm.ManagedServiceFactory))";
    Bundle _bundle;
    BundleContext _context;
    ServiceTracker _tracker;

    public MetaTypeProviderTracker(BundleContext context, Bundle bundle) {
        this._context = context;
        this._bundle = bundle;
        try {
            Filter filter = context.createFilter(FILTER_STRING);
            this._tracker = new ServiceTracker(context, filter, null);
            this._tracker.open();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(FILTER_STRING);
        }
    }

    private String[] getPids(boolean factory) {
        if (this._bundle.getState() != 32) {
            return new String[0];
        }
        MetaTypeProviderWrapper[] wrappers = this.getMetaTypeProviders();
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < wrappers.length) {
            if (factory == wrappers[i].factory) {
                results.add(wrappers[i].pid);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getPids() {
        return this.getPids(false);
    }

    public String[] getFactoryPids() {
        return this.getPids(true);
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (this._bundle.getState() != 32) {
            return null;
        }
        MetaTypeProviderWrapper[] wrappers = this.getMetaTypeProviders();
        int i = 0;
        while (i < wrappers.length) {
            if (id.equals(wrappers[i].pid)) {
                return wrappers[i].provider.getObjectClassDefinition(id, locale);
            }
            ++i;
        }
        return null;
    }

    public String[] getLocales() {
        if (this._bundle.getState() != 32) {
            return new String[0];
        }
        MetaTypeProviderWrapper[] wrappers = this.getMetaTypeProviders();
        ArrayList<String> locales = new ArrayList<String>();
        int i = 0;
        while (i < wrappers.length) {
            String[] wrappedLocales = wrappers[i].provider.getLocales();
            if (wrappedLocales != null) {
                int j = 0;
                while (j < wrappedLocales.length) {
                    if (!locales.contains(wrappedLocales[j])) {
                        locales.add(wrappedLocales[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return locales.toArray(new String[locales.size()]);
    }

    private MetaTypeProviderWrapper[] getMetaTypeProviders() {
        ServiceReference[] refs = this._tracker.getServiceReferences();
        if (refs == null) {
            return new MetaTypeProviderWrapper[0];
        }
        ArrayList<MetaTypeProviderWrapper> results = new ArrayList<MetaTypeProviderWrapper>();
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getBundle() == this._bundle) {
                Object service = this._context.getService(refs[i]);
                if (service instanceof MetaTypeProvider) {
                    String pid = (String)refs[i].getProperty("service.pid");
                    boolean factory = service instanceof ManagedServiceFactory;
                    results.add(new MetaTypeProviderWrapper((MetaTypeProvider)service, pid, factory));
                }
                this._context.ungetService(refs[i]);
            }
            ++i;
        }
        return results.toArray(new MetaTypeProviderWrapper[results.size()]);
    }

    public class MetaTypeProviderWrapper {
        MetaTypeProvider provider;
        String pid;
        boolean factory;

        MetaTypeProviderWrapper(MetaTypeProvider provider, String pid, boolean factory) {
            this.provider = provider;
            this.pid = pid;
            this.factory = factory;
        }
    }
}

