/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.xhr.client.XMLHttpRequest;

public final class HttpThrowableReporter {
    public static void installUncaughtExceptionHandler(String url) {
        GWT.setUncaughtExceptionHandler(new MyHandler(url));
    }

    public static boolean report(String url, Throwable t) {
        try {
            XMLHttpRequest xhr = XMLHttpRequest.create();
            xhr.open("POST", url);
            xhr.send(HttpThrowableReporter.buildPayload(t));
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    static String buildPayload(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"strongName\" : ");
        sb.append(JsonUtils.escapeValue(GWT.getPermutationStrongName()));
        sb.append(",\"message\" : ");
        sb.append(JsonUtils.escapeValue(t.getMessage()));
        sb.append(",\"stackTrace\" : [");
        boolean needsComma = false;
        for (StackTraceElement e : t.getStackTrace()) {
            if (needsComma) {
                sb.append(",");
            } else {
                needsComma = true;
            }
            sb.append(JsonUtils.escapeValue(e.getMethodName()));
        }
        sb.append("]}");
        return sb.toString();
    }

    private HttpThrowableReporter() {
    }

    private static class MyHandler
    implements GWT.UncaughtExceptionHandler {
        private final String url;

        public MyHandler(String url) {
            this.url = url;
        }

        public void onUncaughtException(Throwable e) {
            HttpThrowableReporter.report(this.url, e);
        }
    }
}

