import { JSONSchema } from '../jsonSchema07';
import { SchemaRequestService, WorkspaceContextService, PromiseConstructor, Thenable } from '../yamlLanguageService';
import { UnresolvedSchema, ResolvedSchema, JSONSchemaService, SchemaDependencies, ISchemaContributions } from 'vscode-json-languageservice/lib/umd/services/jsonSchemaService';
export declare type CustomSchemaProvider = (uri: string) => Thenable<string>;
export declare class FilePatternAssociation {
    private schemas;
    private patternRegExp;
    constructor(pattern: string);
    addSchema(id: string): void;
    matchesPattern(fileName: string): boolean;
    getSchemas(): string[];
}
export declare class YAMLSchemaService extends JSONSchemaService {
    private customSchemaProvider;
    private filePatternAssociations;
    private contextService;
    constructor(requestService: SchemaRequestService, contextService?: WorkspaceContextService, promiseConstructor?: PromiseConstructor);
    registerCustomSchemaProvider(customSchemaProvider: CustomSchemaProvider): void;
    resolveSchemaContent(schemaToResolve: UnresolvedSchema, schemaURL: string, dependencies: SchemaDependencies): Thenable<ResolvedSchema>;
    getSchemaForResource(resource: string, doc?: any): Thenable<ResolvedSchema>;
    /**
     * Everything below here is needed because we're importing from vscode-json-languageservice umd and we need
     * to provide a wrapper around the javascript methods we are calling since they have no type
     */
    normalizeId(id: string): any;
    getOrAddSchemaHandle(id: string, unresolvedSchemaContent?: JSONSchema): any;
    loadSchema(schemaUri: string): Thenable<any>;
    registerExternalSchema(uri: string, filePatterns?: string[], unresolvedSchema?: JSONSchema): any;
    clearExternalSchemas(): void;
    setSchemaContributions(schemaContributions: ISchemaContributions): void;
    getRegisteredSchemaIds(filter?: (scheme: any) => boolean): string[];
    getResolvedSchema(schemaId: string): Thenable<ResolvedSchema>;
    onResourceChange(uri: string): boolean;
}
