/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.edt.debug.core.breakpoints.EGLBreakpoint;

public class EGLLineBreakpoint
extends EGLBreakpoint
implements ILineBreakpoint {
    public EGLLineBreakpoint() {
    }

    public EGLLineBreakpoint(IResource resource, String typeName, int lineNumber, int charStart, int charEnd, boolean register, boolean runToLine) throws DebugException {
        this(resource, typeName, lineNumber, charStart, charEnd, register, runToLine, new HashMap());
    }

    public EGLLineBreakpoint(final IResource resource, final String typeName, final int lineNumber, final int charStart, final int charEnd, final boolean register, final boolean runToLine, final Map attributes) throws DebugException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                EGLLineBreakpoint.this.setMarker(resource.createMarker("org.eclipse.edt.debug.core.eglLineBreakpointMarker"));
                attributes.put("org.eclipse.debug.core.id", "org.eclipse.edt.debug.ui.presentation.java");
                attributes.put("org.eclipse.edt.debug.core.typeName", typeName);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("lineNumber", lineNumber);
                attributes.put("charStart", charStart);
                attributes.put("charEnd", charEnd);
                attributes.put("org.eclipse.edt.debug.core.runToLine", runToLine);
                attributes.put("org.eclipse.debug.core.persisted", !runToLine);
                EGLLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                if (register) {
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)EGLLineBreakpoint.this);
                } else {
                    EGLLineBreakpoint.this.setRegistered(false);
                }
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public boolean isRunToLine() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.edt.debug.core.runToLine", false);
    }

    public void setRunToLine(boolean isRunToLine) throws CoreException {
        this.ensureMarker().setAttribute("org.eclipse.edt.debug.core.runToLine", isRunToLine);
    }
}

