/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAnnotationValueProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.jface.text.ITextViewer;

public class EGLAnnotationValueAssignmentReferenceCompletion
extends EGLAbstractReferenceCompletion {
    private Node boundNode = null;

    @Override
    protected void precompileContexts() {
        this.addContext("package a; handler a type a {abc =");
        this.addContext("package a; handler a type a {abc = abc, abc =");
        this.addContext("package a; handler a {@abc{abc=");
        this.addContext("package a; handler a {@abc{abc=abc, abc=");
        this.addContext("package a; handler a {@abc{abc=[");
        this.addContext("package a; handler a {@abc{abc=[a,");
        this.addContext("package a; handler a {@abc{");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList proposals = new ArrayList();
        boolean[] cfr_ignored_0 = new boolean[1];
        this.getBoundASTNode(viewer, documentOffset, new String[]{"x", "x}", "x}}", "x]", "x]}", "x}; end"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                return EGLAnnotationValueAssignmentReferenceCompletion.this.getAnnotationField(astNode) != null;
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                EField field = EGLAnnotationValueAssignmentReferenceCompletion.this.getAnnotationField(boundNode);
                proposals.addAll(new EGLAnnotationValueProposalHandler(viewer, documentOffset, prefix, EGLAnnotationValueAssignmentReferenceCompletion.this.editor).getProposals(field, boundNode));
            }
        });
        return proposals;
    }

    public EField getAnnotationField(Node node) {
        EField field = this.getAnnotationFieldFromAssignment(node);
        if (field != null) {
            return field;
        }
        return this.getAnnotationFieldFromAnnotation(node);
    }

    public EField getAnnotationFieldFromAssignment(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof SetValuesExpression && ((SetValuesExpression)node).getExpression() instanceof AnnotationExpression) {
            return null;
        }
        if (node instanceof Assignment) {
            Assignment ass = (Assignment)node;
            if (ass.resolveBinding() != null && ass.getLeftHandSide() instanceof SimpleName) {
                return this.getEField((AnnotationType)ass.resolveBinding().getEClass(), ass.getLeftHandSide().toString());
            }
            return null;
        }
        return this.getAnnotationFieldFromAssignment(node.getParent());
    }

    public EField getAnnotationFieldFromAnnotation(Node node) {
        Annotation ann = this.getAnnotation(node);
        if (ann != null && !(ann.getEClass() instanceof StereotypeType) && ann.getEClass().getEFields().size() == 1) {
            return (EField)ann.getEClass().getEFields().get(0);
        }
        return null;
    }

    public Annotation getAnnotation(Node node) {
        Part part;
        if (node == null) {
            return null;
        }
        if (node instanceof SetValuesExpression) {
            SetValuesExpression sve = (SetValuesExpression)node;
            if (sve.getExpression() instanceof AnnotationExpression) {
                return ((AnnotationExpression)sve.getExpression()).resolveAnnotation();
            }
            return null;
        }
        if (node instanceof SettingsBlock && node.getParent() instanceof Part && (part = (Part)node.getParent()).hasSubType()) {
            return (Annotation)part.getSubType().resolveElement();
        }
        return this.getAnnotation(node.getParent());
    }

    private EField getEField(AnnotationType annType, String name) {
        for (EField f : annType.getEFields()) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }
}

