/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;

public class EglarUtility {
    public static IResource[] getGeneratedJavaClassFolder(IProject project) {
        ArrayList<IPath> outputLocations = new ArrayList<IPath>(EglarUtility.getOutputLocation(project));
        if (outputLocations != null) {
            IResource[] resources = new IResource[outputLocations.size()];
            int i = 0;
            while (i < outputLocations.size()) {
                resources[i] = project.getFolder(((IPath)outputLocations.get(i)).removeFirstSegments(1));
                ++i;
            }
            return resources;
        }
        return null;
    }

    public static Set<IPath> getOutputLocation(IProject project) {
        HashSet<IPath> paths = new HashSet<IPath>();
        try {
            IJavaProject javaProject = null;
            if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)project);
                paths.add(javaProject.getOutputLocation());
            }
            if (javaProject != null) {
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getOutputLocation() != null) {
                        paths.add(entries[i].getOutputLocation());
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return paths;
    }
}

