/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.HashMap;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ImportGroup;
import org.eclipse.swt.graphics.Image;

public class ImportGroupOutlineAdapter
extends AbstractOutlineAdapter {
    public ImportGroupOutlineAdapter(EGLEditor editor) {
        super(editor);
        this.nodeIcon = PluginImages.DESC_OBJS_IMPORTS;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        ImportGroup group = (ImportGroup)parentElement;
        return group.getFile().getImportDeclarations().toArray();
    }

    @Override
    public String getText(Object element) {
        return UINlsStrings.OutlineViewImportGroup;
    }

    @Override
    public Image getImage(Object element) {
        this.fImageFlags = 0;
        Image result = null;
        if (this.anyImportStatementshaveErrorsOrNestedErrors()) {
            this.fImageFlags = 64;
        } else if (this.anyImportStatementshaveWarningsOrNestedWarnings()) {
            this.fImageFlags = 32;
        }
        if (this.nodeIcon != null) {
            result = this.fImageLabelProvider.getImageLabel(this.nodeIcon, this.fImageFlags);
        }
        return result;
    }

    private boolean anyImportStatementshaveErrorsOrNestedErrors() {
        boolean foundImportStatementInError = false;
        HashMap localCopy = this.editor.getNodesWithSavedErrors();
        if (this.editor != null && localCopy != null) {
            Node[] keys = localCopy.keySet().toArray(new Node[localCopy.size()]);
            int i = 0;
            while (i < keys.length) {
                Node thisNode = keys[i];
                if (thisNode instanceof ImportDeclaration) {
                    return true;
                }
                ++i;
            }
        }
        return foundImportStatementInError;
    }

    private boolean anyImportStatementshaveWarningsOrNestedWarnings() {
        boolean foundImportStatementWithWarning = false;
        HashMap localCopy = this.editor.getNodesWithSavedWarnings();
        if (this.editor != null && localCopy != null) {
            Node[] keys = localCopy.keySet().toArray(new Node[localCopy.size()]);
            int i = 0;
            while (i < keys.length) {
                Node thisNode = keys[i];
                if (thisNode instanceof ImportDeclaration) {
                    return true;
                }
                ++i;
            }
        }
        return foundImportStatementWithWarning;
    }
}

