/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.ui.internal.refactoring.participants.ResourceModifications;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public abstract class RefactoringModifications {
    private ResourceModifications fResourceModifications = new ResourceModifications();

    public ResourceModifications getResourceModifications() {
        return this.fResourceModifications;
    }

    public abstract RefactoringParticipant[] loadParticipants(RefactoringStatus var1, RefactoringProcessor var2, String[] var3, SharableParticipants var4);

    public abstract void buildDelta(IResourceChangeDescriptionFactory var1);

    public void buildValidateEdits(ValidateEditChecker checker) {
    }

    protected void createIncludingParents(IContainer container) {
        while (container != null && !container.exists() && !this.getResourceModifications().willExist((IResource)container)) {
            this.getResourceModifications().addCreate((IResource)container);
            container = container.getParent();
        }
    }

    protected IResource[] collectResourcesOfInterest(IPackageFragment source) throws CoreException {
        IEGLElement[] children = source.getChildren();
        int childOfInterest = 6;
        if (source.getKind() == 2) {
            childOfInterest = 7;
        }
        ArrayList<IResource> result = new ArrayList<IResource>(children.length);
        int i = 0;
        while (i < children.length) {
            IEGLElement child = children[i];
            if (child.getElementType() == childOfInterest && child.getResource() != null) {
                result.add(child.getResource());
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected IFile getEGLFile(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        IResource result = project.findMember(".eglpath");
        if (result instanceof IFile) {
            return (IFile)result;
        }
        return null;
    }

    protected IFile getEGLPathFile(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        IResource result = project.findMember(".eglpath");
        if (result instanceof IFile) {
            return (IFile)result;
        }
        return null;
    }
}

