/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MalformedTreeException;

public class GetEventHandlerFunctionsOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;
    private List functionNames = new ArrayList();

    public GetEventHandlerFunctionsOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public String[] getFunctions() {
        block7: {
            try {
                IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
                IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
                sharedWorkingCopy.reconcile(false, null);
                try {
                    try {
                        File fileAST = this.currentDocument.getNewModelEGLFile();
                        String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
                        IPart modelPart = sharedWorkingCopy.getPart(partName);
                        this.functionNames = this.findFunctions(modelPart, fileAST);
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Handler: Error finding functions", (Throwable)e));
                        sharedWorkingCopy.destroy();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    sharedWorkingCopy.destroy();
                    throw throwable;
                }
                sharedWorkingCopy.destroy();
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Handler: Error creating working copy", (Throwable)e));
            }
        }
        return this.functionNames.toArray(new String[this.functionNames.size()]);
    }

    public int getFunctionFirstLineOffset(String functionName) {
        try {
            IFunction function = this.findFunction(functionName);
            int line = this.currentDocument.getLineOfOffset(function.getNameRange().getOffset()) + 1;
            IRegion region = this.currentDocument.getLineInformation(line);
            int offset = region.getOffset() + region.getLength();
            return offset;
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Handler: Error finding functions", (Throwable)e));
            return 0;
        }
    }

    public int[] getFunctionNameRange(String functionName) {
        int[] range = new int[2];
        try {
            IFunction function = this.findFunction(functionName);
            range[0] = function.getNameRange().getOffset();
            range[1] = function.getNameRange().getLength() - 1;
            return range;
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Handler: Error finding functions", (Throwable)e));
            return range;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IFunction findFunction(String functionName) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                this.currentDocument.getNewModelEGLFile();
                String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
                IPart modelPart = sharedWorkingCopy.getPart(partName);
                IFunction[] functions = modelPart.getFunctions();
                int i = 0;
                while (i < functions.length) {
                    IFunction function = functions[i];
                    if (function.getParameterTypes().length == 1 && "Event".equalsIgnoreCase(Signature.toString((String)function.getParameterTypes()[0])) && functionName.equalsIgnoreCase(function.getElementName())) {
                        IFunction iFunction = function;
                        return iFunction;
                    }
                    try {
                        ++i;
                        continue;
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Handler: Error finding functions", (Throwable)e));
                    }
                    break;
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Handler: Error creating working copy", (Throwable)e));
        }
        return null;
    }

    private List findFunctions(IPart modelPart, File fileAST) throws EGLModelException, MalformedTreeException, BadLocationException {
        ArrayList<String> result = new ArrayList<String>();
        IFunction[] functions = modelPart.getFunctions();
        int i = 0;
        while (i < functions.length) {
            IFunction function = functions[i];
            if (function.getParameterTypes().length == 1 && "Event".equalsIgnoreCase(Signature.toString((String)function.getParameterTypes()[0]))) {
                result.add(function.getElementName());
            }
            ++i;
        }
        return result;
    }
}

