/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.preferences;

import org.eclipse.edt.ide.rui.internal.nls.ILocalesListViewer;
import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocalesList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class LocalesContentProvider
implements IStructuredContentProvider,
ILocalesListViewer {
    TableViewer tableViewer;
    LocalesList localesList;

    public LocalesContentProvider(LocalesList localesList, TableViewer tableViewer) {
        this.localesList = localesList;
        this.tableViewer = tableViewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.localesList.getLocales().toArray();
    }

    public void dispose() {
        this.localesList.removeChangeListener(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            ((LocalesList)newInput).addChangeListener(this);
        }
        if (oldInput != null) {
            ((LocalesList)oldInput).removeChangeListener(this);
        }
    }

    @Override
    public void addLocale(Locale locale) {
        this.tableViewer.add((Object)locale);
        StructuredSelection selection = new StructuredSelection((Object)locale);
        this.tableViewer.setSelection((ISelection)selection, true);
    }

    @Override
    public void removeLocale(Locale locale) {
        this.tableViewer.remove((Object)locale);
    }

    @Override
    public void updateLocale(Locale locale) {
        this.tableViewer.update((Object)locale, null);
        this.tableViewer.setSelection(null);
    }

    @Override
    public void clear() {
    }
}

