/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.internal.HelpContextIDs;
import org.eclipse.edt.ide.rui.internal.nls.EditLocaleWizard;
import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocalesList;
import org.eclipse.edt.ide.rui.internal.nls.NewLocaleWizard;
import org.eclipse.edt.ide.rui.internal.nls.RUINlsStrings;
import org.eclipse.edt.ide.rui.internal.preferences.LocaleViewerSorter;
import org.eclipse.edt.ide.rui.internal.preferences.LocalesContentProvider;
import org.eclipse.edt.ide.rui.internal.preferences.LocalesLabelProvider;
import org.eclipse.edt.ide.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class RUIPreferencePage
extends AbstractPreferencePage {
    Table table;
    TableViewer tableViewer;
    Button removeLocale;
    Button editLocale;
    private static final String Description_Column = "description";
    private static final String Locale_Code_Column = "code";
    private static final String Runtime_Message_Locale_Column = "runtimeLocale";
    private static String[] columnNames = new String[]{"description", "code", "runtimeLocale"};
    private List allDescriptions = new ArrayList();
    private List allCodes = new ArrayList();
    private HashMap userLocaleToRuntimeLocale = new HashMap();
    private LocalesList localesList = LocalesList.getLocalesList();

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.createLocaleComposite(composite);
        this.loadPreferences();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HelpContextIDs.RUI_BASE_PREFERENCE_PAGE);
        return composite;
    }

    private void createLocaleComposite(Composite parent) {
        Group localeGroup = RUIPreferencePage.createGroup((Composite)parent, (int)2);
        localeGroup.setText(RUINlsStrings.RUIDeployPreferencePage_Locales_that_the_handler_will_suppo_);
        this.createTable((Composite)localeGroup);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new LocalesContentProvider(this.localesList, this.tableViewer));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LocalesLabelProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RUIPreferencePage.this.editLocale();
            }
        });
        Composite buttonArea = new Composite((Composite)localeGroup, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonArea.setLayout((Layout)layout);
        GridData data = new GridData(2);
        buttonArea.setLayoutData((Object)data);
        Button addLocale = new Button(buttonArea, 8);
        addLocale.setText(RUINlsStrings.RUIDeployPreferencePage_1);
        addLocale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RUIPreferencePage.this.addLocale();
            }
        });
        this.setButtonLayoutData(addLocale);
        this.editLocale = new Button(buttonArea, 8);
        this.editLocale.setText(RUINlsStrings.RUIDeployPreferencePage_edit_button);
        this.editLocale.setEnabled(false);
        this.editLocale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RUIPreferencePage.this.editLocale();
            }
        });
        this.setButtonLayoutData(this.editLocale);
        this.removeLocale = new Button(buttonArea, 8);
        this.removeLocale.setText(RUINlsStrings.RUIDeployPreferencePage_2);
        this.removeLocale.setEnabled(false);
        this.removeLocale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RUIPreferencePage.this.deleteLocale();
            }
        });
        this.setButtonLayoutData(this.removeLocale);
    }

    private void addLocale() {
        Locale locale = new Locale();
        NewLocaleWizard wizard = new NewLocaleWizard(locale, this.allCodes, this.allDescriptions, this.userLocaleToRuntimeLocale);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        int rc = dialog.open();
        if (rc == 0) {
            String code = locale.getCode();
            String runtimeCode = locale.getRuntimeLocaleCode();
            this.localesList.addLocale(locale);
            this.allDescriptions.add(locale.getDescription());
            this.allCodes.add(locale.getCode());
            if (!this.userLocaleToRuntimeLocale.containsKey(code)) {
                ArrayList<String> runtimeLocales = new ArrayList<String>();
                runtimeLocales.add(runtimeCode);
                this.userLocaleToRuntimeLocale.put(code, runtimeLocales);
            } else {
                List runtimeLocales = (List)this.userLocaleToRuntimeLocale.get(code);
                if (!runtimeLocales.contains(runtimeCode)) {
                    runtimeLocales.add(runtimeCode);
                }
            }
        }
        Collections.sort(this.localesList.getLocales(), this.localesList.new LocalesList.SortIt());
        this.tableViewer.refresh(true, true);
    }

    private void deleteLocale() {
        Locale locale = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (this.localesList.getLocales().size() == 1) break;
            Object obj = iterator.next();
            if (!(obj instanceof Locale)) continue;
            locale = (Locale)obj;
            this.localesList.removeLocale(locale);
            this.allDescriptions.remove(locale.getDescription());
            this.allCodes.remove(locale.getCode());
        }
        this.tableViewer.refresh();
        this.updateButtons();
    }

    private void editLocale() {
        Locale oldLocale = (Locale)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        if (oldLocale != null) {
            String oldCode = oldLocale.getCode();
            String oldDescription = oldLocale.getDescription();
            String oldRuntimeLocaleCode = oldLocale.getRuntimeLocaleCode();
            Locale newLocale = new Locale(oldCode, oldDescription, oldRuntimeLocaleCode);
            EditLocaleWizard wizard = new EditLocaleWizard(newLocale, this.allCodes, this.allDescriptions, this.userLocaleToRuntimeLocale);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            int rc = dialog.open();
            if (rc == 0) {
                this.localesList.removeLocale(oldLocale);
                this.localesList.addLocale(newLocale);
                String code = newLocale.getCode();
                String description = newLocale.getDescription();
                String runtimeCode = newLocale.getRuntimeLocaleCode();
                if (!code.equalsIgnoreCase(oldCode)) {
                    this.allCodes.remove(oldCode);
                    this.allCodes.add(code);
                }
                if (!description.equalsIgnoreCase(oldDescription)) {
                    this.allDescriptions.remove(oldDescription);
                    this.allDescriptions.add(description);
                }
                if (!runtimeCode.equalsIgnoreCase(oldRuntimeLocaleCode)) {
                    if (!this.userLocaleToRuntimeLocale.containsKey(code)) {
                        ArrayList<String> runtimeLocales = new ArrayList<String>();
                        runtimeLocales.add(runtimeCode);
                        this.userLocaleToRuntimeLocale.put(code, runtimeLocales);
                    } else {
                        List runtimeLocales = (List)this.userLocaleToRuntimeLocale.get(code);
                        if (!runtimeLocales.contains(runtimeCode)) {
                            runtimeLocales.add(runtimeCode);
                        }
                    }
                }
            }
            Collections.sort(this.localesList.getLocales(), this.localesList.new LocalesList.SortIt());
            this.tableViewer.refresh();
        }
    }

    private void createTable(Composite parent) {
        int style = 68354;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(768);
        gridData.heightHint = 260;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && RUIPreferencePage.this.table.getSelection().length > 0) {
                    RUIPreferencePage.this.deleteLocale();
                }
            }
        });
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(RUINlsStrings.RUIDeployPreferencePage_4);
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RUIPreferencePage.this.tableViewer.setSorter((ViewerSorter)new LocaleViewerSorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setText(RUINlsStrings.RUIDeployPreferencePage_5);
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RUIPreferencePage.this.tableViewer.setSorter((ViewerSorter)new LocaleViewerSorter(0));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText(RUINlsStrings.RUIDeployPreferencePage_6);
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RUIPreferencePage.this.tableViewer.setSorter((ViewerSorter)new LocaleViewerSorter(2));
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RUIPreferencePage.this.updateButtons();
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columnNames);
    }

    protected void initializeValues() {
        super.initializeValues();
        this.buildLocaleConvienenceData();
        this.tableViewer.setInput((Object)this.localesList);
    }

    private void buildLocaleConvienenceData() {
        this.allDescriptions.clear();
        this.allCodes.clear();
        this.userLocaleToRuntimeLocale.clear();
        for (Locale locale : this.localesList.getLocales()) {
            List<String> runtimeLocales;
            String code = locale.getCode();
            String runtimeCode = locale.getRuntimeLocaleCode();
            this.allDescriptions.add(locale.getDescription());
            this.allCodes.add(code);
            if (!this.userLocaleToRuntimeLocale.containsKey(code)) {
                runtimeLocales = new ArrayList<String>();
                runtimeLocales.add(runtimeCode);
                this.userLocaleToRuntimeLocale.put(code, runtimeLocales);
                continue;
            }
            runtimeLocales = (List)this.userLocaleToRuntimeLocale.get(code);
            if (runtimeLocales.contains(runtimeCode)) continue;
            runtimeLocales.add(runtimeCode);
        }
    }

    protected void enableValues() {
        super.enableValues();
    }

    protected void storeValues() {
        this.getEGLBasePreferenceStore().setValue("org.eclipse.edt.ide.rui.eglRUIDefaultLocales", this.localesList.toString());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private IPreferenceStore getEGLBasePreferenceStore() {
        return EGLBasePlugin.getPlugin().getPreferenceStore();
    }

    public boolean performOk() {
        return super.performOk();
    }

    public List getColumnNames() {
        return Arrays.asList(columnNames);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.table.setRedraw(false);
        this.localesList.defaultTheLocalesList();
        this.buildLocaleConvienenceData();
        this.tableViewer.refresh();
        this.table.setRedraw(true);
    }

    public LocalesList getLocalesList() {
        return this.localesList;
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        int selectionCount = selection.size();
        this.editLocale.setEnabled(selectionCount == 1);
        this.removeLocale.setEnabled(selectionCount > 0 && this.localesList.getLocales().size() > 1);
    }
}

