/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.server;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.deployment.javascript.CompileErrorHTMLGenerator;
import org.eclipse.edt.gen.deployment.javascript.GenerationErrorHTMLGenerator;
import org.eclipse.edt.ide.rui.internal.deployment.javascript.EGL2HTML4VE;
import org.eclipse.edt.ide.rui.internal.lookup.PreviewIREnvironmentManager;
import org.eclipse.edt.ide.rui.internal.nls.EWTPreviewMessages;
import org.eclipse.edt.ide.rui.server.AbstractContentProvider;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.utils.DebugIFileLocator;
import org.eclipse.edt.ide.rui.utils.FileLocator;
import org.eclipse.edt.ide.rui.utils.IFileLocator;
import org.eclipse.edt.ide.rui.utils.PreviewFileLocator;
import org.eclipse.edt.ide.rui.utils.WorkingCopyGenerationResult;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.xml.sax.SAXException;

public abstract class WorkingCopyContentProvider
extends AbstractContentProvider {
    protected EvEditorProvider editorProvider = null;

    public WorkingCopyContentProvider(EvEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    @Override
    protected FileLocator getFileLocator(IProject project) throws CoreException {
        return new PreviewFileLocator(project, this.editorProvider.getGenerationDirectory());
    }

    @Override
    protected IFileLocator getIFileLocator(IProject project) throws CoreException {
        return new DebugIFileLocator(project);
    }

    @Override
    protected byte[] generateHTMLFile(FileLocator locator, String resourceName, String projectName) throws SAXException, IOException {
        CompileErrorHTMLGenerator generator = null;
        WorkingCopyGenerationResult result = this.editorProvider.getLastGenerationResult();
        if (result != null && result.hasError()) {
            String message;
            EGL2HTML4VE cmd = new EGL2HTML4VE();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IEnvironment environment = this.getEnvironmentForGeneration(project);
            Environment.pushEnv((IEnvironment)environment);
            Part part = null;
            EObject eObject = null;
            try {
                eObject = environment.find(PreviewIREnvironmentManager.makeEGLKey(resourceName.replace("/", ".")));
            }
            catch (MofObjectNotFoundException mofObjectNotFoundException) {
                message = MessageFormat.format(EWTPreviewMessages.COMPILEFAILEDPAGE_HEADERMSG, resourceName.replace("/", "."));
                generator = new CompileErrorHTMLGenerator((AbstractGeneratorCommand)cmd, (IGenerationMessageRequestor)result.getResult(), message);
            }
            catch (DeserializationException deserializationException) {
                message = MessageFormat.format(EWTPreviewMessages.COMPILEFAILEDPAGE_HEADERMSG, resourceName.replace("/", "."));
                generator = new CompileErrorHTMLGenerator((AbstractGeneratorCommand)cmd, (IGenerationMessageRequestor)result.getResult(), message);
            }
            if (eObject != null && eObject instanceof Part) {
                part = (Part)eObject;
            }
            if (!result.hasGenerationError()) {
                message = MessageFormat.format(EWTPreviewMessages.COMPILEFAILEDPAGE_HEADERMSG, resourceName.replace("/", "."));
                CompileErrorHTMLGenerator compileErrorHTMLGenerator = new CompileErrorHTMLGenerator((AbstractGeneratorCommand)cmd, (IGenerationMessageRequestor)result.getResult(), message);
                return compileErrorHTMLGenerator.generate().getBytes();
            }
            message = MessageFormat.format(EWTPreviewMessages.GENFAILEDPAGE_HEADERMSG, part.getFullyQualifiedName(), Integer.toString(result.getResult().getNumGenErrors()), Integer.toString(result.getResult().getNumGenWarnings()));
            generator = new GenerationErrorHTMLGenerator((AbstractGeneratorCommand)cmd, result.getResult(), message);
            String strResult = cmd.generate(part, (Generator)generator, environment);
            return strResult.getBytes();
        }
        return super.generateHTMLFile(locator, resourceName, projectName);
    }

    @Override
    protected IEnvironment getEnvironmentForGeneration(IProject project) {
        return PreviewIREnvironmentManager.getPreviewIREnvironment(project, this.editorProvider.getGenerationDirectory().toFile());
    }
}

