/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.widgetLibProvider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.widgetLibProvider.IWidgetLibProvider;
import org.eclipse.edt.ide.widgetLibProvider.WidgetLibProvider;

public class WidgetLibProviderManager {
    public static final String EXTENSIONPOINT_WIDGET_LIBRARY_PROVIDER = "org.eclipse.edt.ide.rui.widgetLibraryProvider";
    public static final String PROVIDER = "provider";
    public static final String PROVIDER_CONTAINER = "providerContainer";
    private static WidgetLibProviderManager manager = new WidgetLibProviderManager();
    private static IConfigurationElement[] rootElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.edt.ide.rui.widgetLibraryProvider");

    public static WidgetLibProviderManager getInstance() {
        return manager;
    }

    private WidgetLibProviderManager() {
    }

    public IWidgetLibProvider[] getProviders(String widgetLibraryContainerID) {
        ArrayList<WidgetLibProvider> ret = new ArrayList<WidgetLibProvider>();
        IConfigurationElement[] providerRefs = this.getProviderRefs(widgetLibraryContainerID);
        int i = 0;
        while (i < providerRefs.length) {
            WidgetLibProvider iwp = this.getIWidgetLibProvider(providerRefs[i].getAttribute("id"));
            if (iwp != null) {
                String sIsMandatory;
                String sSelected = providerRefs[i].getAttribute("selected");
                if (sSelected != null) {
                    boolean selected = Boolean.parseBoolean(sSelected);
                    iwp.setIsSelect(selected);
                }
                if ((sIsMandatory = providerRefs[i].getAttribute("isMandatory")) != null) {
                    boolean isMandatory = Boolean.parseBoolean(sIsMandatory);
                    iwp.setIsMandatory(isMandatory);
                }
                ret.add(iwp);
            }
            ++i;
        }
        return ret.toArray(new IWidgetLibProvider[ret.size()]);
    }

    public List<String> getProviders(String widgetLibraryContainerID, boolean isSelected) {
        ArrayList<String> ret = new ArrayList<String>();
        IConfigurationElement[] providerRefs = this.getProviderRefs(widgetLibraryContainerID);
        int i = 0;
        while (i < providerRefs.length) {
            boolean selected;
            String sSelected = providerRefs[i].getAttribute("selected");
            if (sSelected == null || isSelected == (selected = Boolean.parseBoolean(sSelected))) {
                ret.add(providerRefs[i].getAttribute("id"));
            }
            ++i;
        }
        return ret;
    }

    public IConfigurationElement[] getProviderRefs(String widgetLibraryContainerID) {
        int i = 0;
        while (i < rootElements.length) {
            try {
                if (rootElements[i].getName().equals(PROVIDER_CONTAINER) && rootElements[i].getAttribute("id").equals(widgetLibraryContainerID)) {
                    IConfigurationElement[] providerRefs = rootElements[i].getChildren();
                    return providerRefs;
                }
            }
            catch (Exception ex) {
                EGLLogger.log((Object)this, (Throwable)ex);
            }
            ++i;
        }
        EGLLogger.log((Object)this, (String)("Can not find the widget provider container by id: " + widgetLibraryContainerID));
        return null;
    }

    public WidgetLibProvider getIWidgetLibProvider(String providerID) {
        int i = 0;
        while (i < rootElements.length) {
            try {
                if (rootElements[i].getName().equals(PROVIDER) && rootElements[i].getAttribute("id").equals(providerID)) {
                    WidgetLibProvider provider = new WidgetLibProvider();
                    provider.init(rootElements[i]);
                    return provider;
                }
            }
            catch (Exception ex) {
                EGLLogger.log((Object)this, (Throwable)ex);
            }
            ++i;
        }
        EGLLogger.log((Object)this, (String)("Can not find the widget provider by id: " + providerID));
        return null;
    }
}

