/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugContextResolver;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugMessages;
import org.eclipse.edt.ide.debug.javascript.internal.server.DebugContext;
import org.eclipse.edt.ide.debug.javascript.internal.utils.RUIDebugUtil;
import org.eclipse.edt.ide.rui.actions.ActionLaunchDefaultBrowser;
import org.eclipse.edt.ide.rui.actions.ActionLaunchExternalBrowser;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RUILaunchDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (mode.equalsIgnoreCase("debug")) {
            this.launchInDebugMode(configuration, launch, monitor);
        } else if (mode.equalsIgnoreCase("run")) {
            this.launchInRunMode(configuration, launch, monitor);
        }
    }

    private void launchInDebugMode(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        DebugContext context = RUIDebugUtil.createContext(configuration, launch);
        RUIDebugContextResolver.getInstance().addContext(context);
        try {
            if (!configuration.hasAttribute("org.eclipse.edt.debug.javascript.attr_url")) {
                new ActionLaunchExternalBrowser(context.getUrl(), true).run();
            }
            launch.addDebugTarget((IDebugTarget)context.getDebugTarget());
        }
        catch (RuntimeException re) {
            RUIDebugContextResolver.getInstance().removeContext(context);
            this.displayError(NLS.bind((String)RUIDebugMessages.rui_launch_error_title, (Object)configuration.getName()), re.getMessage());
            monitor.setCanceled(true);
        }
    }

    private void launchInRunMode(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        String file = configuration.getAttribute("org.eclipse.edt.debug.javascript.attr_handler_file", "");
        String project = configuration.getAttribute("org.eclipse.edt.debug.javascript.attr_project_name", "");
        new ActionLaunchDefaultBrowser(RUIDebugUtil.getDebugURL(file, project)).run();
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    private void displayError(final String title, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg);
            }
        });
    }
}

