/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.properties;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.edt.ide.rui.document.utils.IVEConstants;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditor;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Tooltips;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.IEvPropertySheetPageAdapter;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorAbstract;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorBoolean;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorChoice;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorColor;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorInteger;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorPosition;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorString;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorStringArray;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertySheetPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyTabComposite;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.TableCellEditorComboBox;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.TableCellEditorComboBoxListener;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetEventDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetLayoutDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;

public class PropertyPage
extends ScrolledComposite
implements MouseListener,
SelectionListener,
TableCellEditorComboBoxListener {
    protected TableCellEditorComboBox _comboCellEditor = null;
    protected Composite _composite = null;
    protected Hashtable _hashTabs = new Hashtable();
    protected PropertySheetPage _propertySheet = null;
    protected String[] _straFunctionNames = null;
    protected CTabFolder _tabFolder = null;
    protected Table _table = null;
    protected TableEditor _tableEditor = null;
    protected TableEditor _tableAddButtonEditor = null;
    protected ToolBar _toolbar = null;
    protected Vector _vectorPropertyEditors = new Vector();
    protected Vector _vectorLayoutPropertyEditors = new Vector();
    protected WidgetPart _widgetPart = null;
    protected PropertyTabComposite _layoutComposite = null;
    protected boolean _propertyChangedFromPropertiesView = false;
    private static final int EVENT_TABLE_ADD_COLUMN_WIDTH = 20;
    private static final int EVENT_TABLE_EDITABLE_COLUMN = 2;

    public PropertyPage(Composite compositeParent, PropertySheetPage propertySheet, WidgetPart widgetPart, String[] straFunctionNames, EvEditor editor) {
        super(compositeParent, 768);
        this._propertySheet = propertySheet;
        this._straFunctionNames = straFunctionNames;
        this._widgetPart = widgetPart;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.setLayoutData(gridData);
        this._composite = new Composite((Composite)this, 0);
        this.setContent((Control)this._composite);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this._composite.setLayout((Layout)gridLayout);
        this.createControls(widgetPart, editor);
        Point ptSize = this._composite.computeSize(-1, -1);
        ptSize.x = Math.max(ptSize.x, 500);
        this._composite.setSize(ptSize);
    }

    protected void activateCellEditor(TableItem tableItem) {
        String[] straNames = this._propertySheet.getEventHandlingFunctionNames();
        String[] straNamesExtended = new String[straNames.length + 1];
        straNamesExtended[0] = "";
        System.arraycopy(straNames, 0, straNamesExtended, 1, straNames.length);
        this._comboCellEditor.activate(this._table, this._tableEditor, 1, tableItem, straNamesExtended);
    }

    @Override
    public void cellComboBoxChanged(TableItem tableItem, int column, int iRow, String strOriginalValue, String strNewValue) {
        switch (iRow) {
            case 0: {
                this._propertySheet.setEventValue(tableItem, null, false);
                break;
            }
            default: {
                this._propertySheet.setEventValue(tableItem, strNewValue, false);
            }
        }
    }

    protected CTabItem createCategoryTab(String strLabel, int index) {
        strLabel = this.translateCategoryName(strLabel);
        CTabItem tabItem = new CTabItem(this._tabFolder, 0, index);
        tabItem.setText(strLabel);
        PropertyTabComposite compositeCategory = new PropertyTabComposite((Composite)this._tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        compositeCategory.setLayout((Layout)gridLayout);
        tabItem.setControl((Control)compositeCategory);
        return tabItem;
    }

    protected void createControls(WidgetPart widgetPart, EvEditor editor) {
        String strTypeID = widgetPart.getTypeID();
        WidgetDescriptorRegistry registry = WidgetDescriptorRegistry.getInstance(editor.getProject());
        WidgetDescriptor descriptor = registry.getDescriptor(strTypeID);
        if (descriptor == null) {
            return;
        }
        this._tabFolder = new CTabFolder(this._composite, 0);
        this._tabFolder.setLayoutData((Object)new GridData(1808));
        this.createControlsForProperties(descriptor, widgetPart, registry);
        CTabItem itemEvents = new CTabItem(this._tabFolder, 0);
        itemEvents.setText(Messages.NL_Events);
        this._hashTabs.put(Messages.NL_Events, itemEvents);
        Composite compositeEvents = new Composite((Composite)this._tabFolder, 0);
        compositeEvents.setBackground(this.getDisplay().getSystemColor(25));
        itemEvents.setControl((Control)compositeEvents);
        GridLayout gridLayout = new GridLayout();
        compositeEvents.setLayout((Layout)gridLayout);
        this.createControlsForEvents(compositeEvents, descriptor, widgetPart);
        this.createControlsForLayout(widgetPart, registry);
        ScrollBar scrollBar = this.getVerticalBar();
        scrollBar.setIncrement(16);
        scrollBar.setPageIncrement(200);
        scrollBar = this.getHorizontalBar();
        scrollBar.setIncrement(16);
        scrollBar.setPageIncrement(200);
        this._tabFolder.setSelection(0);
        this._tabFolder.addSelectionListener((SelectionListener)this);
    }

    protected void createControlsForEvents(Composite compositeParent, WidgetDescriptor descriptor, WidgetPart widgetPart) {
        this._comboCellEditor = new TableCellEditorComboBox();
        this._comboCellEditor.addTableCellEditorComboListener(this);
        this._table = new Table(compositeParent, 66304);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.minimumWidth = 250;
        this._table.setLayoutData((Object)gridData);
        String[] straColumnTitles = new String[]{Messages.NL_Event, Messages.NL_Function, "  "};
        int[] iaColumnWidths = new int[3];
        GC gc = new GC((Drawable)this._table);
        Font f = this._table.getFont();
        gc.setFont(f);
        int i = 0;
        while (i < straColumnTitles.length) {
            iaColumnWidths[i] = gc.textExtent((String)straColumnTitles[i]).x;
            ++i;
        }
        gc.dispose();
        int[] iaColumnWeights = new int[]{50, 42, 8};
        TableLayout layoutTable = new TableLayout();
        int i2 = 0;
        while (i2 < straColumnTitles.length) {
            TableColumn tableColumn = new TableColumn(this._table, 0);
            tableColumn.setText(straColumnTitles[i2]);
            ColumnWeightData cLayout = new ColumnWeightData(iaColumnWeights[i2], iaColumnWidths[i2], true);
            layoutTable.addColumnData((ColumnLayoutData)cLayout);
            ++i2;
        }
        this._table.setLinesVisible(true);
        this._table.setHeaderVisible(true);
        this._table.setLayout((Layout)layoutTable);
        this._table.addMouseListener((MouseListener)this);
        this._table.addSelectionListener((SelectionListener)this);
        this._tableEditor = new TableEditor(this._table);
        this._tableAddButtonEditor = new TableEditor(this._table);
        this._tableAddButtonEditor.horizontalAlignment = 0x1000000;
        this._tableAddButtonEditor.verticalAlignment = 0x1000000;
        this._tableAddButtonEditor.minimumWidth = 20;
        WidgetEventDescriptor[] events = descriptor.getEventDescriptors(PropertySheetPage.filter_Type);
        int i3 = 0;
        while (i3 < events.length) {
            ArrayList listValues;
            String[] straData = new String[2];
            straData[0] = events[i3].getID();
            WidgetPropertyValue propertyValue = this._propertySheet.getEditorAdapter().getEventValue(widgetPart, events[i3].getID());
            String strValue = null;
            if (propertyValue != null && (listValues = propertyValue.getValues()) != null && listValues.size() > 0) {
                strValue = (String)listValues.get(0);
            }
            straData[1] = strValue != null ? strValue : "";
            TableItem item = new TableItem(this._table, 0);
            item.setText(straData);
            item.setData("descriptor", (Object)events[i3]);
            item.setData("propertyvalue", (Object)propertyValue);
            ++i3;
        }
    }

    protected void createControlsForProperties(WidgetDescriptor descriptor, WidgetPart widgetPart, WidgetDescriptorRegistry registry) {
        if (descriptor == null) {
            return;
        }
        this._vectorPropertyEditors.clear();
        WidgetPropertyDescriptor[] properties = descriptor.getPropertyDescriptors(PropertySheetPage.filter_Type);
        if (properties.length == 0) {
            return;
        }
        int i = 0;
        while (i < properties.length) {
            CTabItem tabItem;
            String strCategory = properties[i].getCategory();
            if (strCategory == null || strCategory.length() == 0) {
                strCategory = "General";
            }
            if (!this._hashTabs.containsKey(strCategory)) {
                String strCategoryLabel = strCategory;
                tabItem = this.createCategoryTab(strCategoryLabel, this._tabFolder.getItemCount());
                this._hashTabs.put(strCategory, tabItem);
            } else {
                tabItem = (CTabItem)this._hashTabs.get(strCategory);
            }
            PropertyTabComposite compositeParent = (PropertyTabComposite)tabItem.getControl();
            properties[i].getType();
            this.createPropertyEditor(compositeParent, properties[i], this._vectorPropertyEditors);
            ++i;
        }
    }

    private void createPropertyEditor(PropertyTabComposite compositeParent, WidgetPropertyDescriptor property, Vector propertyEditors) {
        PropertyEditorAbstract editor = null;
        String strType = property.getType();
        if (strType.equals(IVEConstants.BOOLEAN_TYPE)) {
            editor = this.createEditorBoolean(compositeParent.getBooleanElementsComposite(), property);
        } else if (strType.equals(IVEConstants.CHOICE_TYPE)) {
            editor = this.createEditorChoice(compositeParent.getNonBooleanElementComposite(), property);
        } else if (strType.equals(IVEConstants.COLOR_TYPE)) {
            editor = this.createEditorColor(compositeParent.getNonBooleanElementComposite(), property);
        } else if (strType.equals(IVEConstants.INTEGER_TYPE)) {
            editor = this.createEditorInteger(compositeParent.getNonBooleanElementComposite(), property);
        } else if (strType.equals(IVEConstants.STRING_TYPE)) {
            editor = this.createEditorString(compositeParent.getNonBooleanElementComposite(), property);
        } else if (strType.equals(IVEConstants.STRING_ARRAY_TYPE)) {
            editor = this.createEditorStringArray(compositeParent.getNonBooleanElementComposite(), property);
        }
        if (editor == null) {
            return;
        }
        if (propertyEditors != null) {
            propertyEditors.add(editor);
        }
        editor.initialize();
    }

    protected void createControlsForLayout(WidgetPart widgetPart, WidgetDescriptorRegistry registry) {
        CTabItem layoutTab;
        boolean widgetHasLayout = true;
        WidgetDescriptor parentDescriptor = null;
        WidgetPropertyDescriptor[] properties = null;
        if (widgetPart.getParent() == null || (parentDescriptor = registry.getDescriptor(widgetPart.getParent().getPackageName(), widgetPart.getParent().getTypeName())) == null || parentDescriptor._layoutDescriptor == null) {
            widgetHasLayout = false;
        } else {
            WidgetLayoutDescriptor descriptor = parentDescriptor._layoutDescriptor;
            properties = descriptor.getPropertyDescriptors();
            if (properties.length == 0) {
                widgetHasLayout = false;
            }
        }
        if (!widgetHasLayout) {
            if (this._layoutComposite != null && !this._layoutComposite.isDisposed()) {
                layoutTab = (CTabItem)this._hashTabs.remove("Layout");
                layoutTab.setControl(null);
                layoutTab.dispose();
                this._layoutComposite.dispose();
                this._layoutComposite = null;
                this._vectorLayoutPropertyEditors.clear();
            }
        } else {
            layoutTab = (CTabItem)this._hashTabs.get("Layout");
            if (layoutTab == null) {
                int layoutTabIndex = this._tabFolder.getItemCount();
                CTabItem eventsTab = (CTabItem)this._hashTabs.get(Messages.NL_Events);
                if (eventsTab != null) {
                    layoutTabIndex = this._tabFolder.indexOf(eventsTab);
                }
                layoutTab = this.createCategoryTab("Layout", layoutTabIndex);
                this._hashTabs.put("Layout", layoutTab);
                this._layoutComposite = (PropertyTabComposite)layoutTab.getControl();
                int i = 0;
                while (i < properties.length) {
                    properties[i].getType();
                    this.createPropertyEditor(this._layoutComposite, properties[i], this._vectorLayoutPropertyEditors);
                    ++i;
                }
            }
        }
    }

    public void recreateControlsForLayout(WidgetPart widgetPart, WidgetDescriptorRegistry registry) {
        this.createControlsForLayout(widgetPart, registry);
        this._composite.pack();
    }

    protected PropertyEditorAbstract createEditorBoolean(Composite compositeParent, WidgetPropertyDescriptor descriptor) {
        PropertyEditorBoolean editor = new PropertyEditorBoolean(this, descriptor, descriptor.getLabel());
        editor.createControl(compositeParent);
        return editor;
    }

    protected PropertyEditorAbstract createEditorChoice(Composite compositeParent, WidgetPropertyDescriptor descriptor) {
        Label label = new Label(compositeParent, 0);
        label.setBackground(compositeParent.getBackground());
        PropertyEditorChoice editor = new PropertyEditorChoice(this, descriptor);
        editor.createControl(compositeParent);
        label.setText(String.valueOf(descriptor.getLabel()) + ":");
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        return editor;
    }

    protected PropertyEditorAbstract createEditorColor(Composite compositeParent, WidgetPropertyDescriptor descriptor) {
        Label label = new Label(compositeParent, 0);
        label.setBackground(compositeParent.getBackground());
        PropertyEditorColor editor = new PropertyEditorColor(this, descriptor);
        editor.createControl(compositeParent);
        label.setText(String.valueOf(descriptor.getLabel()) + ":");
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        return editor;
    }

    protected PropertyEditorAbstract createEditorInteger(Composite compositeParent, WidgetPropertyDescriptor descriptor) {
        Label label = new Label(compositeParent, 0);
        label.setBackground(compositeParent.getBackground());
        PropertyEditorInteger editor = new PropertyEditorInteger(this, descriptor);
        editor.createControl(compositeParent);
        String strLabel = descriptor.getLabel();
        if (strLabel != null) {
            label.setText(String.valueOf(strLabel) + ":");
        }
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        return editor;
    }

    protected PropertyEditorAbstract createEditorPosition(Composite compositeParent, WidgetPropertyDescriptor descriptor) {
        PropertyEditorPosition editor = new PropertyEditorPosition(this, descriptor);
        editor.createControl(compositeParent);
        return editor;
    }

    protected PropertyEditorAbstract createEditorString(Composite compositeParent, WidgetPropertyDescriptor descriptor) {
        Label label = new Label(compositeParent, 0);
        label.setBackground(compositeParent.getBackground());
        PropertyEditorString editor = new PropertyEditorString(this, descriptor);
        editor.createControl(compositeParent);
        String strLabel = descriptor.getLabel();
        if (strLabel != null) {
            label.setText(String.valueOf(descriptor.getLabel()) + ":");
        }
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        return editor;
    }

    protected PropertyEditorAbstract createEditorStringArray(Composite compositeParent, WidgetPropertyDescriptor descriptor) {
        Label label = new Label(compositeParent, 0);
        label.setBackground(compositeParent.getBackground());
        PropertyEditorStringArray editor = new PropertyEditorStringArray(this, descriptor);
        editor.createControl(compositeParent);
        String strLabel = descriptor.getLabel();
        if (strLabel != null) {
            label.setText(String.valueOf(descriptor.getLabel()) + ":");
        }
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        return editor;
    }

    public WidgetPropertyValue getPropertyValue(String strPropertyID, String strPropertyType) {
        return this._propertySheet.getEditorAdapter().getPropertyValue(this._widgetPart, strPropertyID, strPropertyType);
    }

    public WidgetPropertyValue getLayoutPropertyValue(String strPropertyID, String strPropertyType) {
        return this._propertySheet.getEditorAdapter().getLayoutPropertyValue(this._widgetPart, strPropertyID, strPropertyType);
    }

    public String getTabFolderPageName() {
        return this._tabFolder != null && !this._tabFolder.isDisposed() ? this._tabFolder.getSelection().getText() : "";
    }

    public void mouseDoubleClick(MouseEvent event) {
        TableItem[] items = this._table.getSelection();
        TableItem tableItemSelected = items[0];
        if (tableItemSelected == null || tableItemSelected.isDisposed()) {
            return;
        }
        int iColumn = -1;
        int i = 0;
        while (i < 2) {
            if (tableItemSelected.getBounds(i).contains(event.x, event.y)) {
                iColumn = i;
                break;
            }
            ++i;
        }
        if (iColumn == 0) {
            String functionName = tableItemSelected.getText(1);
            if (functionName == null || functionName.length() == 0) {
                this._propertySheet.createNewEventHandlingFunction(tableItemSelected);
            } else {
                IEvPropertySheetPageAdapter adapter = this._propertySheet.getEditorAdapter();
                int[] range = adapter.getEditorProvider().getFunctionNameRange(functionName);
                adapter.selectAndRevealRange(range[0], range[1]);
            }
        }
    }

    public void mouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        TableItem[] items = this._table.getSelection();
        if (items.length != 1) {
            return;
        }
        TableItem tableItemSelected = items[0];
        if (tableItemSelected == null || tableItemSelected.isDisposed()) {
            return;
        }
        int iColumn = -1;
        int i = 0;
        while (i < 2) {
            if (tableItemSelected.getBounds(i).contains(event.x, event.y)) {
                iColumn = i;
                break;
            }
            ++i;
        }
        if (iColumn == 1) {
            this.activateCellEditor(tableItemSelected);
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void propertyValueChanged(PropertyEditorAbstract propertyEditor, WidgetPropertyDescriptor descriptor, WidgetPropertyValue propertyValueOld, WidgetPropertyValue propertyValueNew) {
        if (this._propertySheet == null) {
            return;
        }
        this._propertyChangedFromPropertiesView = true;
        this._propertySheet.propertyValueChanged(descriptor, propertyValueOld, propertyValueNew);
        propertyEditor.initialize();
    }

    public void reloadValues(WidgetPart widgetPart, String[] straFunctionNames) {
        PropertyEditorAbstract editor;
        this._widgetPart = widgetPart;
        int i = 0;
        while (i < this._vectorPropertyEditors.size()) {
            editor = (PropertyEditorAbstract)this._vectorPropertyEditors.get(i);
            editor.initialize();
            ++i;
        }
        i = 0;
        while (i < this._vectorLayoutPropertyEditors.size()) {
            editor = (PropertyEditorAbstract)this._vectorLayoutPropertyEditors.get(i);
            editor.initialize();
            ++i;
        }
        if (this._table == null) {
            return;
        }
        TableItem[] items = this._table.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            ArrayList listValues;
            WidgetEventDescriptor descriptor = (WidgetEventDescriptor)items[i2].getData("descriptor");
            WidgetPropertyValue propertyValue = this._propertySheet.getEditorAdapter().getEventValue(widgetPart, descriptor.getID());
            String strValue = null;
            if (propertyValue != null && (listValues = propertyValue.getValues()) != null && listValues.size() > 0) {
                strValue = (String)listValues.get(0);
            }
            items[i2].setText(1, strValue != null ? strValue : "");
            items[i2].setData("propertyvalue", (Object)propertyValue);
            ++i2;
        }
    }

    public void setTabFolderPageName(String name) {
        if (this._tabFolder != null && !this._tabFolder.isDisposed()) {
            int i = 0;
            i = 0;
            while (i < this._tabFolder.getItemCount()) {
                if (name.equals(this._tabFolder.getItem(i).getText())) {
                    this._tabFolder.setSelection(i);
                    break;
                }
                ++i;
            }
            if (i > 0 && i == this._tabFolder.getItemCount()) {
                this._tabFolder.setSelection(0);
            }
        }
    }

    protected String translateCategoryName(String strCategoryName) {
        if (strCategoryName == null) {
            return null;
        }
        if (strCategoryName.equals("Accessibility")) {
            return Messages.NL_Accessibility;
        }
        if (strCategoryName.equals("Appearance")) {
            return Messages.NL_Appearance;
        }
        if (strCategoryName.equals("Bidi")) {
            return Messages.NL_Bidi;
        }
        if (strCategoryName.equals("Border")) {
            return Messages.NL_Border;
        }
        if (strCategoryName.equals("Position")) {
            return Messages.NL_Position;
        }
        if (strCategoryName.equals("Spacing")) {
            return Messages.NL_Spacing;
        }
        if (strCategoryName.equals("Layout")) {
            return Messages.NL_Layout;
        }
        if (strCategoryName.equals("General")) {
            return Messages.NL_General;
        }
        return strCategoryName;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        int iItem;
        if (event.getSource() == this._table && (iItem = this._table.getSelectionIndex()) >= 0) {
            this.activateCellEditor(this._table.getItem(iItem));
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget instanceof Combo) {
            String strValueNew;
            Combo combo = (Combo)event.getSource();
            String strValueOriginal = (String)combo.getData("originalValue");
            if (!strValueOriginal.equals(strValueNew = combo.getText())) {
                WidgetEventDescriptor descriptor = (WidgetEventDescriptor)combo.getData("descriptor");
                this._propertySheet.eventValueChanged(descriptor, strValueOriginal, strValueNew, false);
            }
        } else if (event.widget == this._tabFolder) {
            this._propertySheet.tabFolderPageNameChanged();
        } else if (event.widget instanceof Button) {
            TableItem tableItem = null;
            TableItem[] tableItems = this._table.getSelection();
            if (tableItems.length != 0) {
                tableItem = tableItems[0];
            }
            this._propertySheet.createNewEventHandlingFunction(tableItem);
        } else if (event.widget instanceof Table) {
            TableItem item;
            Control oldEditor = this._tableAddButtonEditor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
            if ((item = (TableItem)event.item) == null) {
                return;
            }
            Button button = new Button((Composite)this._table, 8);
            button.setAlignment(0x1000000);
            button.setImage(Activator.getImage("elcl16/plus_obj.gif"));
            button.setToolTipText(Tooltips.NL_Create_a_new_event_handling_function);
            button.addSelectionListener((SelectionListener)this);
            this._tableAddButtonEditor.setEditor((Control)button, item, 2);
        }
    }

    public class SectionExpansionState {
        public boolean bExpanded = false;
        public String strSectionName = null;
    }
}

