/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyGraphValue;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.mof.utils.NameUtile;

class QualifiedName
implements IDependencyGraphValue {
    private String qualifiedName;

    public QualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public QualifiedName() {
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String toString() {
        return this.qualifiedName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QualifiedName) {
            return NameUtile.equals((String)this.qualifiedName, (String)((QualifiedName)obj).qualifiedName);
        }
        return false;
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    @Override
    public int getNormalizedHashCode() {
        return this.qualifiedName.toUpperCase().toLowerCase().hashCode();
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        String[] segments = Util.qualifiedNameToStringArray(this.qualifiedName);
        outputStream.writeInt(segments.length);
        int i = 0;
        while (i < segments.length) {
            outputStream.writeUTF(segments[i]);
            ++i;
        }
    }

    @Override
    public void deserialize(DataInputStream inputStream) throws IOException {
        int segments = inputStream.readInt();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < segments) {
            if (i > 0) {
                buf.append('.');
            }
            buf.append(inputStream.readUTF());
            ++i;
        }
        this.qualifiedName = NameUtile.getAsName((String)buf.toString());
    }

    @Override
    public int getKind() {
        return 2;
    }
}

