/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import java.io.Serializable;
import org.eclipse.edt.compiler.internal.interfaces.IEGLLocation;

public class Location
implements IEGLLocation,
Serializable {
    private int line;
    private int column;
    private int offset;
    private int length;
    private int endLine;

    public Location() {
    }

    public Location(int line, int column, int offset) {
        this(line, column, offset, 0);
    }

    public Location(int line, int column, int offset, int length) {
        this.line = line;
        this.column = column;
        this.offset = offset;
        this.length = length;
    }

    public int compareTo(Location location) {
        if (this.line == location.line) {
            if (this.column == location.column) {
                return 0;
            }
            if (this.column < location.column) {
                return -1;
            }
            return 1;
        }
        if (this.line < location.line) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Location location) {
        return this.compareTo(location) == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Location) {
            return this.equals((Location)object);
        }
        return false;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        return "Line: " + this.line + " Column: " + this.column + " Offset:  " + this.offset;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getLength() {
        return this.length;
    }

    public void setEndLine(int i) {
        this.endLine = i;
    }

    public void setLength(int i) {
        this.length = i;
    }
}

