/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import com.ibm.icu.util.StringTokenizer;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.ide.core.internal.model.AbstractSourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.ISourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.ImportDeclaration;
import org.eclipse.edt.ide.core.internal.model.PackageDeclaration;
import org.eclipse.edt.ide.core.internal.model.SourceField;
import org.eclipse.edt.ide.core.internal.model.SourceFieldElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceFunction;
import org.eclipse.edt.ide.core.internal.model.SourceFunctionElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceProperty;
import org.eclipse.edt.ide.core.internal.model.SourcePropertyBlock;
import org.eclipse.edt.ide.core.internal.model.SourcePropertyBlockElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourcePropertyElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceRefElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceUseDeclaration;
import org.eclipse.edt.ide.core.internal.model.SourceUseElementInfo;
import org.eclipse.edt.ide.core.internal.model.util.HashtableOfObject;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IImportContainer;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IProblem;
import org.eclipse.edt.ide.core.model.IPropertyContainer;
import org.eclipse.edt.ide.core.model.Signature;

public class EGLFileStructureRequestor
extends AbstractSourceElementRequestor
implements ISourceElementRequestor {
    protected IEGLFile fUnit;
    protected EGLFileElementInfo fUnitInfo;
    protected EGLElementInfo fImportContainerInfo = null;
    protected Map fNewElements;
    protected Stack fInfoStack;
    protected Stack fHandleStack;
    protected char[] fSourceFileName = null;
    protected char[] fPackageName = null;
    protected int fRefCount = 0;
    protected static int fgReferenceAllocation = 50;
    protected boolean hasSyntaxErrors = false;
    private int occurrenceCounter = 1;
    protected static String[] fgEmptyStringArray = new String[0];
    protected static byte[] fgEmptyByte = new byte[0];
    protected static char[][] fgEmptyCharChar = new char[0][];
    protected static char[] fgEmptyChar = new char[0];
    protected HashtableOfObject fieldRefCache;
    protected HashtableOfObject messageRefCache;
    protected HashtableOfObject typeRefCache;
    protected HashtableOfObject unknownRefCache;

    protected EGLFileStructureRequestor(IEGLFile unit, EGLFileElementInfo unitInfo, Map newElements) throws EGLModelException {
        this.fUnit = unit;
        this.fUnitInfo = unitInfo;
        this.fNewElements = newElements;
        this.fSourceFileName = unit.getElementName().toCharArray();
    }

    @Override
    public void acceptField(int declarationStart, int declarationEnd, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        SourcePartElementInfo parentInfo = (SourcePartElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        SourceField handle = null;
        if (parentHandle.getElementType() == 8) {
            handle = new SourceField((IPart)((Object)parentHandle), new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setCharName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setFlags(modifiers);
        info.setTypeName(type);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    @Override
    public void acceptProperty(int declarationStart, int declarationEnd, char[] text) {
        SourcePropertyBlockElementInfo parentInfo = (SourcePropertyBlockElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        SourceProperty handle = null;
        StringTokenizer tokenizer = new StringTokenizer(new String(text), "=\t\f\n\r");
        String key = tokenizer.nextToken().trim();
        String value = null;
        int valueType = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("=")) continue;
            value = token.trim();
        }
        valueType = value == null || value.equals("yes") || value.equals("no") ? 0 : 2;
        if (parentHandle.getElementType() == 16) {
            handle = new SourceProperty((IPropertyContainer)((Object)parentHandle), new String(key));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourcePropertyElementInfo info = new SourcePropertyElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setCharName(key.toCharArray());
        if (value != null) {
            info.setValue(value.toCharArray());
            info.setValueType(valueType);
        }
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    @Override
    public void acceptPropertyLiteralName(int declarationStart, int declarationEnd, char[] name) {
    }

    @Override
    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
        EGLElementInfo parentInfo = (EGLElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        IEGLFile parentCU = (IEGLFile)((Object)parentHandle);
        IImportContainer importContainer = parentCU.getImportContainer();
        if (this.fImportContainerInfo == null) {
            this.fImportContainerInfo = new EGLElementInfo();
            this.fImportContainerInfo.setIsStructureKnown(true);
            parentInfo.addChild(importContainer);
            this.fNewElements.put(importContainer, this.fImportContainerInfo);
        }
        String importName = onDemand ? String.valueOf(new String(name)) + ".*" : new String(name);
        ImportDeclaration handle = new ImportDeclaration(importContainer, importName);
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        this.fImportContainerInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    @Override
    public void acceptLineSeparatorPositions(int[] positions) {
    }

    @Override
    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        EGLElementInfo parentInfo = (EGLElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        PackageDeclaration handle = null;
        this.fPackageName = name;
        if (parentHandle.getElementType() == 6) {
            handle = new PackageDeclaration((IEGLFile)((Object)parentHandle), new String(name));
        }
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    public void acceptProblem(IProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return fgEmptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return fgEmptyStringArray;
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = Signature.createTypeSignature(typeNames[i], false);
            ++i;
        }
        return typeSigs;
    }

    @Override
    public void acceptUse(int declarationStart, int declarationEnd, char[] name) {
        SourcePartElementInfo parentInfo = (SourcePartElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        SourceUseDeclaration handle = null;
        if (parentHandle.getElementType() == 8) {
            handle = new SourceUseDeclaration((IPart)((Object)parentHandle), new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceUseElementInfo info = new SourceUseElementInfo();
        info.setTypeName(name);
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    @Override
    public void enterEGLFile() {
        this.fInfoStack = new Stack();
        this.fHandleStack = new Stack();
        this.fInfoStack.push(this.fUnitInfo);
        this.fHandleStack.push(this.fUnit);
    }

    @Override
    public void enterField(int declarationStart, int modifiers, char[] type, char[] typeDeclaredPackage, char[] name, int nameSourceStart, int nameSourceEnd, boolean hasOccurs, int declEnd) {
        Object parentObj = this.fInfoStack.peek();
        if (!(parentObj instanceof SourcePartElementInfo)) {
            this.exitField(declEnd);
        }
        SourcePartElementInfo parentInfo = (SourcePartElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        SourceField handle = null;
        if (parentHandle.getElementType() == 8 || parentHandle.getElementType() == 10) {
            handle = new SourceField((IPart)((Object)parentHandle), new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setCharName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setTypeName(type);
        info.setHasOccurs(hasOccurs);
        info.setTypeDeclaredPackage(typeDeclaredPackage);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    @Override
    public void enterPropertyBlock(int declarationStart, char[] name) {
        SourceRefElementInfo parentInfo = (SourceRefElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        SourcePropertyBlock handle = new SourcePropertyBlock((IMember)((Object)parentHandle), new String(name));
        this.resolveDuplicates(handle);
        SourcePropertyBlockElementInfo info = new SourcePropertyBlockElementInfo();
        info.setCharName(name);
        info.setSourceRangeStart(declarationStart);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    @Override
    public void enterFunction(int declarationStart, int modifiers, char[] returnType, char[] returnTypePackage, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] parameterUseTypes, boolean[] areNullable, char[][] parameterPackages) {
        SourcePartElementInfo parentInfo = (SourcePartElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        SourceFunction handle = null;
        if (parameterTypes == null) {
            parameterTypes = fgEmptyCharChar;
        }
        if (parameterNames == null) {
            parameterNames = fgEmptyCharChar;
        }
        String[] parameterTypeSigs = EGLFileStructureRequestor.convertTypeNamesToSigs(parameterTypes);
        if (parentHandle.getElementType() == 8) {
            handle = new SourceFunction((IPart)((Object)parentHandle), new String(name), parameterTypeSigs);
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFunctionElementInfo info = new SourceFunctionElementInfo();
        info.setSourceRangeStart(declarationStart);
        int flags = modifiers;
        info.setPartType(2);
        info.setCharName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setFlags(flags);
        info.setArgumentNames(parameterNames);
        info.setArgumentTypeNames(parameterTypes);
        info.setReturnType(returnType);
        info.setReturnTypePkg(returnTypePackage);
        info.setUseTypes(parameterUseTypes);
        info.setNullable(areNullable);
        info.setArgumentPackages(parameterPackages);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    @Override
    public void enterPart(int partType, char[] subType, int contentCode, int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] interfaces, char[][] parameterNames, char[][] parameterTypes, char[][] usagePartTypes, char[][] usagePartPackages, String eglFileName) {
        char[] qualifiedName = null;
        EGLElementInfo parentInfo = (EGLElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        IPart handle = null;
        String nameString = new String(name);
        if (parentHandle.getElementType() == 6) {
            handle = ((IEGLFile)((Object)parentHandle)).getPart(nameString);
            qualifiedName = this.fPackageName == null ? nameString.toCharArray() : (String.valueOf(new String(this.fPackageName)) + "." + nameString).toCharArray();
        } else if (parentHandle.getElementType() == 8) {
            handle = ((IPart)((Object)parentHandle)).getPart(nameString);
            qualifiedName = (String.valueOf(new String(((SourcePartElementInfo)parentInfo).getQualifiedName())) + "." + nameString).toCharArray();
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourcePartElementInfo info = new SourcePartElementInfo();
        info.setHandle(handle);
        info.setPartType(partType);
        info.setSubTypeName(subType);
        info.setContentHashCode(contentCode);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setCharName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setInterfaceNames(interfaces);
        info.setSourceFileName(this.fSourceFileName);
        info.setPackageName(this.fPackageName);
        info.setQualifiedName(qualifiedName);
        info.setParameterNames(parameterNames);
        info.setParameterTypeNames(parameterTypes);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    @Override
    public void exitPart(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    @Override
    public void exitEGLFile(int declarationEnd) {
        this.fUnitInfo.setSourceLength(declarationEnd + 1);
        this.fUnitInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    @Override
    public void exitField(int declarationSourceEnd) {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.fInfoStack.pop();
        info.setSourceRangeEnd(declarationSourceEnd);
        this.fHandleStack.pop();
    }

    protected void exitMember(int declarationEnd) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.fInfoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.fHandleStack.pop();
    }

    @Override
    public void exitFunction(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    @Override
    public void exitPropertyBlock(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void resolveDuplicates(IEGLElement handle) {
        while (this.fNewElements.containsKey(handle)) {
            EGLElement h = (EGLElement)handle;
            h.setOccurrenceCount(this.occurrenceCounter++);
        }
    }

    @Override
    public void exitUse(int declarationEnd) {
        this.exitMember(declarationEnd);
    }
}

