/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.HashMap;
import java.util.Map;

public class StrongLRUCache {
    private OrderedStrongReference first;
    private OrderedStrongReference last;
    private Map strongReferences;
    private int maxSize;

    public StrongLRUCache(int maxSize) {
        this.maxSize = maxSize;
        this.strongReferences = new HashMap();
        this.first = new OrderedStrongReference();
        this.first.next = this.last = new OrderedStrongReference();
        this.last.previous = this.first;
    }

    public void put(Object key, Object value) {
        this.strongReferences.put(key, new OrderedStrongReference(key, value, this.first, this.first.next));
        if (this.strongReferences.size() > this.maxSize) {
            this.strongReferences.remove(this.last.previous.remove().key);
        }
    }

    public Object get(Object key) {
        OrderedStrongReference ref = (OrderedStrongReference)this.strongReferences.get(key);
        if (ref == null) {
            return null;
        }
        ref.remove();
        ref.next = this.first.next;
        ref.previous = this.first;
        this.first.next.previous = ref;
        this.first.next = ref;
        return ref.value;
    }

    private static class OrderedStrongReference {
        Object key;
        Object value;
        OrderedStrongReference previous;
        OrderedStrongReference next;

        OrderedStrongReference() {
        }

        OrderedStrongReference(Object key, Object value, OrderedStrongReference previous, OrderedStrongReference next) {
            this.key = key;
            this.value = value;
            this.previous = previous;
            this.next = next;
            this.previous.next = this;
            this.next.previous = this;
        }

        OrderedStrongReference remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
            return this;
        }
    }
}

