/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.util.HashtableOfObject;
import org.eclipse.edt.ide.core.internal.model.util.ObjectVector;
import org.eclipse.edt.ide.core.internal.search.matching.PotentialMatch;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class PotentialMatchSet {
    private HashtableOfObject rootsToPotentialMatches = new HashtableOfObject(5);
    private int elementCount = 0;

    public void add(PotentialMatch potentialMatch) {
        PackageFragmentRoot root = potentialMatch.openable.getPackageFragmentRoot();
        char[] path = root.getPath().toString().toCharArray();
        ObjectVector potentialMatches = (ObjectVector)this.rootsToPotentialMatches.get(path);
        if (potentialMatches == null) {
            potentialMatches = new ObjectVector();
            this.rootsToPotentialMatches.put(path, potentialMatches);
            potentialMatches.add(potentialMatch);
            ++this.elementCount;
        } else if (!potentialMatches.contains(potentialMatch)) {
            potentialMatches.add(potentialMatch);
            ++this.elementCount;
        }
    }

    public PotentialMatch[] getPotentialMatches(IPackageFragmentRoot[] roots) {
        Object[] result = new PotentialMatch[this.elementCount];
        int index = 0;
        int i = 0;
        int length = roots.length;
        while (i < length) {
            IPackageFragmentRoot root = roots[i];
            char[] path = root.getPath().toString().toCharArray();
            ObjectVector potentialMatches = (ObjectVector)this.rootsToPotentialMatches.get(path);
            if (potentialMatches != null) {
                potentialMatches.copyInto(result, index);
                index += potentialMatches.size();
            }
            ++i;
        }
        if (index < this.elementCount) {
            Object[] objectArray = result;
            result = new PotentialMatch[index];
            System.arraycopy(objectArray, 0, result, 0, index);
        }
        return result;
    }
}

