/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.internal.testserver;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.edt.ide.internal.testserver.UpdateErrorDialog;
import org.eclipse.edt.ide.testserver.TestServerConfiguration;
import org.eclipse.edt.ide.testserver.TestServerMessages;
import org.eclipse.edt.ide.testserver.TestServerPlugin;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class HotCodeReplaceListener
implements IJavaHotCodeReplaceListener {
    private final TestServerConfiguration config;

    public HotCodeReplaceListener(TestServerConfiguration config) {
        this.config = config;
    }

    public void hotCodeReplaceFailed(IJavaDebugTarget target, DebugException exception) {
        if (exception == null) {
            this.displayDialog(TestServerMessages.HCRFailedTitle, (IStatus)new Status(2, "org.eclipse.edt.ide.testserver", String.valueOf(NLS.bind((String)TestServerMessages.HCRUnsupportedMsg, (Object)this.config.getProject().getName())) + "\n\n" + TestServerMessages.ErrorDialogTerminateMsg), TestServerPlugin.getDefault().getPreferenceStore(), "org.eclipse.edt.ide.testserver.HCRUnsupported");
        } else {
            this.displayDialog(TestServerMessages.HCRFailedTitle, (IStatus)new Status(2, "org.eclipse.edt.ide.testserver", String.valueOf(NLS.bind((String)TestServerMessages.HCRFailedMsg, (Object)this.config.getProject().getName())) + "\n\n" + TestServerMessages.ErrorDialogTerminateMsg, (Throwable)exception), TestServerPlugin.getDefault().getPreferenceStore(), "org.eclipse.edt.ide.testserver.HCRFailed");
        }
    }

    public void obsoleteMethods(IJavaDebugTarget target) {
        this.displayDialog(TestServerMessages.ObsoleteMethodsTitle, (IStatus)new Status(2, "org.eclipse.edt.ide.testserver", String.valueOf(NLS.bind((String)TestServerMessages.ObsoleteMethodsMsg, (Object)this.config.getProject().getName())) + "\n\n" + TestServerMessages.ErrorDialogTerminateMsg), TestServerPlugin.getDefault().getPreferenceStore(), "org.eclipse.edt.ide.testserver.ObsoleteMethods");
    }

    protected void displayDialog(final String title, final IStatus status, final IPreferenceStore store, final String prefKey) {
        switch (store.getInt(prefKey)) {
            case 2: {
                break;
            }
            case 1: {
                try {
                    this.config.terminate();
                }
                catch (DebugException e) {
                    Display display = TestServerPlugin.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)TestServerPlugin.getShell(), (String)TestServerMessages.TerminateFailedTitle, (String)NLS.bind((String)TestServerMessages.TerminateFailedMsg, (Object)HotCodeReplaceListener.this.config.getProject().getName()), (IStatus)e.getStatus());
                        }
                    });
                }
                break;
            }
            default: {
                final Display display = TestServerPlugin.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        UpdateErrorDialog dialog = new UpdateErrorDialog(TestServerPlugin.getShell(), title, null, status, store, prefKey, HotCodeReplaceListener.this.config);
                        dialog.setBlockOnOpen(false);
                        dialog.open();
                    }
                });
            }
        }
    }

    public void hotCodeReplaceSucceeded(IJavaDebugTarget target) {
    }
}

