/*******************************************************************************
 * Copyright © 2011, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.compiler.core;

/** 
 * @author jshavor
 *
 * Common EGL constants
 */
public interface IEGLConstants {

	//separate the generated constants into an interface by itself
	//and put the rest in another file. 

	public static final String EGL = "egl";  //$NON-NLS-1$

	public static final String PACKAGE_SEPARATOR = "."; //$NON-NLS-1$
	public static final String EGL_CORE_PACKAGE = "egl.core"; //$NON-NLS-1$
	
	public static final String EGL_TEMP_COND_FIELD_PREFIX = "eze_Cond_Temp_"; //$NON-NLS-1$	
	

	public static final String JAVA_ALIAS_ANNOTATION  	= "EGL Java Gen alias";
	public static final String JAVA_FILLER_NAME		  	= "ezeFiller";
	public static final String EGL_USEDFORMS_ANNOTATION = "EGL Used Forms";
	
	public static final String EGL_VALIDVALUESFIELDS  	= "EGL validValues fields";
	public static final String EGL_FORCEDREDEFINES  	= "EGL forced redefines";

	public static final String EGL_MESSAGETABLE  		="EGL Message Table";
	public static final String EGL_HELPFORM  			="EGL Help Form";
	
	public static final String EGL_IMPORTS  			="EGL Imports";
	
	public static final String EGL_FunctionType  		="EGL Func Type";

	public static final String EGL_LOCATION 			= "EGL_Location";
	public static final String EGL_PARTLENGTH  			="len";
	public static final String EGL_PARTOFFSET  			="off";
	public static final String EGL_PARTLINE 			= "line";
	public static final String EGL_PARTABSOLUTEPATH 	= "abs";
	public static final String EGL_STATEMENTLOCATION	= "EGL_Stmt_Loc";
//	public static final String EGL_PARTLENGTH  			="EGL Part Length";
//	public static final String EGL_PARTOFFSET  			="EGL Part Offset";
//	public static final String EGL_PARTABSOLUTEPATH 	= "EGL ABS Path";
	
	public static final String EGL_TEMPCRITERIONINDEX	= "EGL Temp Criterion Index";
	
	public static final String EGL_HAS_ERROR = "EGL has error"; //$NON-NLS-1$
	
	public static final String EGL_Program_Name = "EGL PGM name";

	public static final String EGL_Lobotomize = "EGL Lobotomize";

  

	//EGL keywords
	//Generated :  Tue Jun 13 11:02:51 EDT 2006
	//These keywords should be generated by org.eclipse.edt.compiler.core.dev.tools.EGLKeywordTool
	public static final String KEYWORD_ABSOLUTE = "absolute";  //$NON-NLS-1$
	public static final String KEYWORD_ADD = "add";  //$NON-NLS-1$
	public static final String KEYWORD_ALL = "all";  //$NON-NLS-1$
	public static final String KEYWORD_ANY = "any";  //$NON-NLS-1$
	public static final String KEYWORD_AND = "and";  //$NON-NLS-1$
	public static final String KEYWORD_AS = "as";  //$NON-NLS-1$
	public static final String KEYWORD_ASJAVA = "asjava";  //$NON-NLS-1$
	public static final String KEYWORD_BIGINT = "bigInt";  //$NON-NLS-1$
	public static final String KEYWORD_BIN = "bin";  //$NON-NLS-1$
	public static final String KEYWORD_BIND = "bind";  //$NON-NLS-1$
	public static final String KEYWORD_BLOB = "blob";  //$NON-NLS-1$
	public static final String KEYWORD_BOOLEAN = "boolean";  //$NON-NLS-1$
	public static final String KEYWORD_BY = "by";  //$NON-NLS-1$
	public static final String KEYWORD_BYNAME = "byName";  //$NON-NLS-1$
	public static final String KEYWORD_BYPOSITION = "byPosition";  //$NON-NLS-1$
	public static final String KEYWORD_BYTES = "bytes";  //$NON-NLS-1$
	public static final String KEYWORD_CALL = "call";  //$NON-NLS-1$
	public static final String KEYWORD_CASE = "case";  //$NON-NLS-1$
	public static final String KEYWORD_CHAR = "char";  //$NON-NLS-1$
	public static final String KEYWORD_CLASS = "class";  //$NON-NLS-1$
	public static final String KEYWORD_CLOB = "clob";  //$NON-NLS-1$
	public static final String KEYWORD_CLOSE = "close";  //$NON-NLS-1$
	public static final String KEYWORD_CONST = "const";  //$NON-NLS-1$
	public static final String KEYWORD_CONTINUE = "continue";  //$NON-NLS-1$
	public static final String KEYWORD_CONSTRUCTOR = "constructor";  //$NON-NLS-1$
	public static final String KEYWORD_CONVERSE = "converse";  //$NON-NLS-1$
	public static final String KEYWORD_CURRENT = "current";  //$NON-NLS-1$
	public static final String KEYWORD_DATAITEM = "dataItem";  //$NON-NLS-1$
	public static final String KEYWORD_DATATABLE = "dataTable";  //$NON-NLS-1$
	public static final String KEYWORD_DATE = "date";  //$NON-NLS-1$
	public static final String KEYWORD_DBCHAR = "dbChar";  //$NON-NLS-1$
	public static final String KEYWORD_DECIMAL = "decimal";  //$NON-NLS-1$
	public static final String KEYWORD_DECREMENT = "decrement";  //$NON-NLS-1$
	public static final String KEYWORD_DELEGATE = "delegate";  //$NON-NLS-1$
	public static final String KEYWORD_DELETE = "delete";  //$NON-NLS-1$
	public static final String KEYWORD_DISPLAY = "display";  //$NON-NLS-1$
	public static final String KEYWORD_ELSE = "else";  //$NON-NLS-1$
	public static final String KEYWORD_EMBED = "embed";  //$NON-NLS-1$
	public static final String KEYWORD_END = "end";  //$NON-NLS-1$
	public static final String KEYWORD_ENUMERATION = "enumeration";  //$NON-NLS-1$
	public static final String KEYWORD_ESCAPE = "escape";  //$NON-NLS-1$
	public static final String KEYWORD_EXECUTE = "execute";  //$NON-NLS-1$
	public static final String KEYWORD_EXIT = "exit";  //$NON-NLS-1$
	public static final String KEYWORD_EXTENDS = "extends";  //$NON-NLS-1$
	public static final String KEYWORD_EXTERNALTYPE = "externalType";  //$NON-NLS-1$
	public static final String KEYWORD_FALSE = "false";  //$NON-NLS-1$
	public static final String KEYWORD_FIELD = "field";  //$NON-NLS-1$
	public static final String KEYWORD_FIRST = "first";  //$NON-NLS-1$
	public static final String KEYWORD_FLOAT = "float";  //$NON-NLS-1$
	public static final String KEYWORD_FOR = "for";  //$NON-NLS-1$
	public static final String KEYWORD_FOREACH = "forEach";  //$NON-NLS-1$
	public static final String KEYWORD_FORM = "form";  //$NON-NLS-1$
	public static final String KEYWORD_FORMGROUP = "formGroup";  //$NON-NLS-1$
	public static final String KEYWORD_FORUPDATE = "forUpdate";  //$NON-NLS-1$
	public static final String KEYWORD_FORWARD = "forward";  //$NON-NLS-1$
	public static final String KEYWORD_FREESQL = "freeSql";  //$NON-NLS-1$
	public static final String KEYWORD_FROM = "from";  //$NON-NLS-1$
	public static final String KEYWORD_FUNCTION = "function";  //$NON-NLS-1$
	public static final String KEYWORD_GET = "get";  //$NON-NLS-1$
	public static final String KEYWORD_GOTO = "goto";  //$NON-NLS-1$
	public static final String KEYWORD_GROUP = "group";  //$NON-NLS-1$
	public static final String KEYWORD_HANDLER = "handler";  //$NON-NLS-1$
	public static final String KEYWORD_HEX = "hex";  //$NON-NLS-1$
	public static final String KEYWORD_HOLD = "hold";  //$NON-NLS-1$
	public static final String KEYWORD_IF = "if";  //$NON-NLS-1$
	public static final String KEYWORD_IMPLEMENTS = "implements";  //$NON-NLS-1$
	public static final String KEYWORD_IMPORT = "import";  //$NON-NLS-1$
	public static final String KEYWORD_IN = "in";  //$NON-NLS-1$
	public static final String KEYWORD_INOUT = "inOut";  //$NON-NLS-1$
	public static final String KEYWORD_INPARENT = "inparent";  //$NON-NLS-1$
	public static final String KEYWORD_INSERT = "insert";  //$NON-NLS-1$
	public static final String KEYWORD_INT = "int";  //$NON-NLS-1$
	public static final String KEYWORD_INTERFACE = "interface";  //$NON-NLS-1$
	public static final String KEYWORD_INTERVAL = "interval";  //$NON-NLS-1$
	public static final String KEYWORD_INTO = "into";  //$NON-NLS-1$
	public static final String KEYWORD_IS = "is";  //$NON-NLS-1$
	public static final String KEYWORD_ISA = "isa";  //$NON-NLS-1$
	public static final String KEYWORD_LABEL = "label";  //$NON-NLS-1$
	public static final String KEYWORD_LANGUAGEBUNDLE = "languageBundle";  //$NON-NLS-1$
	public static final String KEYWORD_LAST = "last";  //$NON-NLS-1$
	public static final String KEYWORD_LIBRARY = "library";  //$NON-NLS-1$
	public static final String KEYWORD_LIKE = "like";  //$NON-NLS-1$
	public static final String KEYWORD_MATCHES = "matches";  //$NON-NLS-1$
	public static final String KEYWORD_MBCHAR = "mbChar";  //$NON-NLS-1$
	public static final String KEYWORD_MONEY = "money";  //$NON-NLS-1$
	public static final String KEYWORD_MOVE = "move";  //$NON-NLS-1$
	public static final String KEYWORD_NEW = "new";  //$NON-NLS-1$
	public static final String KEYWORD_NEXT = "next";  //$NON-NLS-1$
	public static final String KEYWORD_NULL = "null";  //$NON-NLS-1$
	public static final String KEYWORD_NO = "no";  //$NON-NLS-1$
	public static final String KEYWORD_NOCURSOR = "noCursor";  //$NON-NLS-1$
	public static final String KEYWORD_NOT = "not";  //$NON-NLS-1$
	public static final String KEYWORD_NUM = "num";  //$NON-NLS-1$
	public static final String KEYWORD_NUMBER = "number";  //$NON-NLS-1$
	public static final String KEYWORD_NUMC = "numc";  //$NON-NLS-1$
	public static final String KEYWORD_OF = "of";  //$NON-NLS-1$
	public static final String KEYWORD_ONEVENT = "onEvent";  //$NON-NLS-1$
	public static final String KEYWORD_ONEXCEPTION = "onException";  //$NON-NLS-1$
	public static final String KEYWORD_OPEN = "open";  //$NON-NLS-1$
	public static final String KEYWORD_OPENUI = "openUI";  //$NON-NLS-1$
	public static final String KEYWORD_OR = "or";  //$NON-NLS-1$
	public static final String KEYWORD_OTHERWISE = "otherwise";  //$NON-NLS-1$
	public static final String KEYWORD_OUT = "out";  //$NON-NLS-1$
	public static final String KEYWORD_PACF = "pacf";  //$NON-NLS-1$
	public static final String KEYWORD_PACKAGE = "package";  //$NON-NLS-1$
	public static final String KEYWORD_PASSING = "passing";  //$NON-NLS-1$
	public static final String KEYWORD_PREPARE = "prepare";  //$NON-NLS-1$
	public static final String KEYWORD_PREVIOUS = "previous";  //$NON-NLS-1$
	public static final String KEYWORD_PRINT = "print";  //$NON-NLS-1$
	public static final String KEYWORD_PRIVATE = "private";  //$NON-NLS-1$
	public static final String KEYWORD_PROGRAM = "program";  //$NON-NLS-1$
	public static final String KEYWORD_RECORD = "record";  //$NON-NLS-1$
	public static final String KEYWORD_REF = "ref";  //$NON-NLS-1$
	public static final String KEYWORD_RELATIVE = "relative";  //$NON-NLS-1$
	public static final String KEYWORD_REPLACE = "replace";  //$NON-NLS-1$
	public static final String KEYWORD_RETURN = "return";  //$NON-NLS-1$
	public static final String KEYWORD_RETURNING = "returning";  //$NON-NLS-1$
	public static final String KEYWORD_RETURNS = "returns";  //$NON-NLS-1$
	public static final String KEYWORD_RUNUNIT = "rununit";  //$NON-NLS-1$
	public static final String KEYWORD_SCROLL = "scroll";  //$NON-NLS-1$
	public static final String KEYWORD_SELF = "self";  //$NON-NLS-1$
	public static final String KEYWORD_SERVICE = "service";  //$NON-NLS-1$
	public static final String KEYWORD_SET = "set";  //$NON-NLS-1$
	public static final String KEYWORD_SHOW = "show";  //$NON-NLS-1$
	public static final String KEYWORD_SINGLEROW = "singleRow";  //$NON-NLS-1$
	public static final String KEYWORD_SMALLFLOAT = "smallFloat";  //$NON-NLS-1$
	public static final String KEYWORD_SMALLINT = "smallInt";  //$NON-NLS-1$
	public static final String KEYWORD_SQLNULLABLE = "sqlnullable";  //$NON-NLS-1$
	public static final String KEYWORD_STACK = "stack";  //$NON-NLS-1$
	public static final String KEYWORD_STATIC = "static";  //$NON-NLS-1$
	public static final String KEYWORD_STRING = "string";  //$NON-NLS-1$
	public static final String KEYWORD_SUPER = "super";  //$NON-NLS-1$
	public static final String KEYWORD_THIS = "this";  //$NON-NLS-1$
	public static final String KEYWORD_THROW = "throw";  //$NON-NLS-1$
	public static final String KEYWORD_TIME = "time";  //$NON-NLS-1$
	public static final String KEYWORD_TIMESTAMP = "timeStamp";  //$NON-NLS-1$
	public static final String KEYWORD_TO = "to";  //$NON-NLS-1$
	public static final String KEYWORD_TRANSACTION = "transaction";  //$NON-NLS-1$
	public static final String KEYWORD_TRANSFER = "transfer";  //$NON-NLS-1$
	public static final String KEYWORD_TRUE = "true";  //$NON-NLS-1$
	public static final String KEYWORD_TRY = "try";  //$NON-NLS-1$
	public static final String KEYWORD_TYPE = "type";  //$NON-NLS-1$
	public static final String KEYWORD_UNICODE = "unicode";  //$NON-NLS-1$
	public static final String KEYWORD_UPDATE = "update";  //$NON-NLS-1$
	public static final String KEYWORD_URL = "url";  //$NON-NLS-1$
	public static final String KEYWORD_USE = "use";  //$NON-NLS-1$
	public static final String KEYWORD_USING = "using";  //$NON-NLS-1$
	public static final String KEYWORD_USINGKEYS = "usingKeys";  //$NON-NLS-1$
	public static final String KEYWORD_WHEN = "when";  //$NON-NLS-1$
	public static final String KEYWORD_WHERE = "where";  //$NON-NLS-1$
	public static final String KEYWORD_WHILE = "while";  //$NON-NLS-1$
	public static final String KEYWORD_WITH = "with";  //$NON-NLS-1$
	public static final String KEYWORD_WITHV60COMPAT = "withV60Compat";  //$NON-NLS-1$
	public static final String KEYWORD_WRAP = "wrap";  //$NON-NLS-1$
	public static final String KEYWORD_YES = "yes";  //$NON-NLS-1$

	
	//V6001VALIDATION
	public static final String KEYWORD_MATHLIB = "mathLib";  //$NON-NLS-1$	
	public static final String KEYWORD_STRLIB = "strLib";  //$NON-NLS-1$	
	public static final String KEYWORD_SYSLIB = "sysLib";  //$NON-NLS-1$	
	public static final String KEYWORD_SYSVAR = "sysVar";  //$NON-NLS-1$	
	public static final String KEYWORD_CONSOLELIB = "consoleLib";  //$NON-NLS-1$	
	public static final String KEYWORD_REPORTLIB = "reportLib";  //$NON-NLS-1$	
	public static final String KEYWORD_LOBLIB = "lobLib";  //$NON-NLS-1$
	public static final String KEYWORD_VGVAR = "vgVar";  //$NON-NLS-1$	
	public static final String KEYWORD_VGLIB = "vgLib";  //$NON-NLS-1$
	public static final String KEYWORD_CONVERSEVAR = "converseVar";  //$NON-NLS-1$
	public static final String KEYWORD_JAVALIB = "javaLib";  //$NON-NLS-1$
	public static final String KEYWORD_DATETIMELIB = "dateTimeLib";  //$NON-NLS-1$
	public static final String KEYWORD_J2EELIB = "j2eeLib";  //$NON-NLS-1$
	public static final String KEYWORD_CONVERSELIB = "converseLib";  //$NON-NLS-1$
	public static final String KEYWORD_SERVICELIB = "serviceLib";  //$NON-NLS-1$
	
	// need to rename these constants
	// These do not belong here.  Only official keywords should be prefixed with
	// KWYWORD_  They all should come from EGLKeywordHandler and the String
	// declarations should be generated per the note in EGLKeywordHandler
	// I am leaving them here for now because of M2 builds
	
	
	///!!!!!!!!!!!! These should not be used!!!!!! Use MNEMONICs instead!!!!!!!!!!
	// These will eventually be deleted.

  	public static final String KEYWORD_DOWN = "down"; //$NON-NLS-1$
	public static final String KEYWORD_EVENTKEY = "eventKey"; //$NON-NLS-1$
 	public static final String KEYWORD_DEFAULTCOLOR = "defaultColor"; //$NON-NLS-1$
	public static final String KEYWORD_BLACK = "black"; //$NON-NLS-1$
	public static final String KEYWORD_BLUE = "blue"; //$NON-NLS-1$
	public static final String KEYWORD_GREEN = "green"; //$NON-NLS-1$
	public static final String KEYWORD_PINK = "pink"; //$NON-NLS-1$
	public static final String KEYWORD_RED = "red"; //$NON-NLS-1$
	public static final String KEYWORD_TURQUOISE = "turquoise"; //$NON-NLS-1$
	public static final String KEYWORD_YELLOW = "yellow"; //$NON-NLS-1$
	public static final String KEYWORD_WHITE = "white"; //$NON-NLS-1$
	public static final String KEYWORD_CYAN = "cyan"; //$NON-NLS-1$
	public static final String KEYWORD_MAGENTA = "magenta"; //$NON-NLS-1$
 	public static final String KEYWORD_NOHIGHLIGHT = "noHighlight"; //$NON-NLS-1$
	public static final String KEYWORD_BLINK = "blink"; //$NON-NLS-1$
	public static final String KEYWORD_REVERSE = "reverse"; //$NON-NLS-1$
	public static final String KEYWORD_UNDERLINE = "underline"; //$NON-NLS-1$
 	public static final String KEYWORD_NORMALINTENSITY = "normalIntensity"; //$NON-NLS-1$
	public static final String KEYWORD_BOLD = "bold"; //$NON-NLS-1$
	public static final String KEYWORD_INVISIBLE = "invisible"; //$NON-NLS-1$
	public static final String KEYWORD_NOOUTLINE = "noOutline"; //$NON-NLS-1$
	public static final String KEYWORD_BOX = "box"; //$NON-NLS-1$
	public static final String KEYWORD_RIGHT = "right"; //$NON-NLS-1$
	public static final String KEYWORD_LEFT = "left"; //$NON-NLS-1$
	public static final String KEYWORD_CENTER = "center"; //$NON-NLS-1$
	public static final String KEYWORD_OVER = "over"; //$NON-NLS-1$
	public static final String KEYWORD_UNDER = "under"; //$NON-NLS-1$
 	public static final String KEYWORD_SKIP = "skip"; //$NON-NLS-1$
 	public static final String KEYWORD_NONE = "none"; //$NON-NLS-1$
	public static final String KEYWORD_SYSTEMGREGORIAN = "systemGregorianDateFormat"; //$NON-NLS-1$
	public static final String KEYWORD_SYSTEMJULIAN = "systemJulianDateFormat"; //$NON-NLS-1$
	public static final String KEYWORD_LEADING = "leading"; //$NON-NLS-1$
 	public static final String KEYWORD_TRAILING = "trailing"; //$NON-NLS-1$





	//EGL mnemonics
	//Generated :  Sun Apr 17 16:52:38 EDT 2005
	//These mnemonics should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLMnemonicTool
	public static final String MNEMONIC_ACROSS = "across";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_DELETE = "after_Delete";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_FIELD = "after_Field";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_INSERT = "after_Insert";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_OPENUI = "after_Openui";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_ROW = "after_Row";  //$NON-NLS-1$
	public static final String MNEMONIC_AIX = "aix";  //$NON-NLS-1$
	public static final String MNEMONIC_ALARM = "alarm";  //$NON-NLS-1$
	public static final String MNEMONIC_ASKIP = "askip";  //$NON-NLS-1$
	public static final String MNEMONIC_AUTOCOMMIT = "autoCommit";  //$NON-NLS-1$
	public static final String MNEMONIC_AUTOMATIC = "automatic";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_DELETE = "before_Delete";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_FIELD = "before_Field";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_INSERT = "before_Insert";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_OPENUI = "before_Openui";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_ROW = "before_Row";  //$NON-NLS-1$
	public static final String MNEMONIC_BLACK = "black";  //$NON-NLS-1$
	public static final String MNEMONIC_BLANKS = "blanks";  //$NON-NLS-1$
	public static final String MNEMONIC_BLINK = "blink";  //$NON-NLS-1$
	public static final String MNEMONIC_BLUE = "blue";  //$NON-NLS-1$
	public static final String MNEMONIC_BOLD = "bold";  //$NON-NLS-1$
	public static final String MNEMONIC_BOTTOM = "bottom";  //$NON-NLS-1$
	public static final String MNEMONIC_BOX = "box";  //$NON-NLS-1$
	public static final String MNEMONIC_BUTTON = "button";  //$NON-NLS-1$
	public static final String MNEMONIC_BYINSERTION = "byInsertion";  //$NON-NLS-1$
	public static final String MNEMONIC_BYKEY = "byKey";  //$NON-NLS-1$
	public static final String MNEMONIC_BYPASS = "bypass";  //$NON-NLS-1$
	public static final String MNEMONIC_CLEAR = "clear";  //$NON-NLS-1$
	public static final String MNEMONIC_CENTER = "center";  //$NON-NLS-1$
	public static final String MNEMONIC_CHARACTER = "character";  //$NON-NLS-1$
	public static final String MNEMONIC_COLOR = "color";  //$NON-NLS-1$
	public static final String MNEMONIC_COMPRESS = "compress";  //$NON-NLS-1$
	public static final String MNEMONIC_COMMENTLINE = "commentLine";  //$NON-NLS-1$
	public static final String MNEMONIC_CONDITIONAL = "conditional";  //$NON-NLS-1$
	public static final String MNEMONIC_CSV = "csv";  //$NON-NLS-1$
	public static final String MNEMONIC_CURSOR = "cursor";  //$NON-NLS-1$
	public static final String MNEMONIC_CYAN = "cyan";  //$NON-NLS-1$
	public static final String MNEMONIC_DB2TIMESTAMPFORMAT = "db2TimeStampFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTCASE = "defaultCase";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTDATEFORMAT = "defaultDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTHIGHLIGHT = "defaultHighlight";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTINTENSITY = "defaultIntensity";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTTIMEFORMAT = "defaultTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTTIMESTAMPFORMAT = "defaultTimeStampFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_DIM = "dim";  //$NON-NLS-1$
	public static final String MNEMONIC_D1A = "d1a";  //$NON-NLS-1$
	public static final String MNEMONIC_D1C = "d1c";  //$NON-NLS-1$
	public static final String MNEMONIC_D1E = "d1e";  //$NON-NLS-1$
	public static final String MNEMONIC_D2A = "d2a";  //$NON-NLS-1$
	public static final String MNEMONIC_D2C = "d2c";  //$NON-NLS-1$
	public static final String MNEMONIC_D2E = "d2e";  //$NON-NLS-1$
	public static final String MNEMONIC_DALL = "dAll";  //$NON-NLS-1$
	public static final String MNEMONIC_DATA = "data";  //$NON-NLS-1$
	public static final String MNEMONIC_DATABASECONNECTION = "databaseConnection";  //$NON-NLS-1$
	public static final String MNEMONIC_DATASOURCE_DATABASE_CONNECTION = "datasource_database_Connection";  //$NON-NLS-1$
	public static final String MNEMONIC_DATASOURCE_SQL_STATEMENT = "datasource_sql_statement";  //$NON-NLS-1$
	public static final String MNEMONIC_DATASOURCE_REPORT_DATA = "datasource_report_data";  //$NON-NLS-1$
	public static final String MNEMONIC_DB = "DB";  //$NON-NLS-1$
	public static final String MNEMONIC_DCURRENT = "dCurrent";  //$NON-NLS-1$
	public static final String MNEMONIC_DEADLOCK = "deadLock";  //$NON-NLS-1$
	public static final String MNEMONIC_DEBUG = "debug";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTCOLOR = "defaultColor";  //$NON-NLS-1$
	public static final String MNEMONIC_DISC = "disc";  //$NON-NLS-1$
	public static final String MNEMONIC_DOUBLEBYTE = "doubleByte";  //$NON-NLS-1$
	public static final String MNEMONIC_DOWN = "down";  //$NON-NLS-1$
	public static final String MNEMONIC_DUPLICATE = "duplicate";  //$NON-NLS-1$
	public static final String MNEMONIC_EMPTY = "empty";  //$NON-NLS-1$
	public static final String MNEMONIC_ENDOFFILE = "endOfFile";  //$NON-NLS-1$
	public static final String MNEMONIC_ENTER = "enter";  //$NON-NLS-1$
	public static final String MNEMONIC_ERRORLINE = "errorLine";  //$NON-NLS-1$
	public static final String MNEMONIC_EURDATEFORMAT = "eurDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_EURTIMEFORMAT = "eurTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPLICIT = "explicit";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPORT_HTML = "export_html";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPORT_PDF = "export_pdf";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPORT_TEXT = "export_text";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPORT_XML = "export_xml";  //$NON-NLS-1$
	public static final String MNEMONIC_FILENOTAVAILABLE = "fileNotAvailable";  //$NON-NLS-1$
	public static final String MNEMONIC_FILENOTFOUND = "fileNotFound";  //$NON-NLS-1$
	public static final String MNEMONIC_FORM = "form";  //$NON-NLS-1$
	public static final String MNEMONIC_FORMLINE = "formLine";  //$NON-NLS-1$
	public static final String MNEMONIC_FULL = "full";  //$NON-NLS-1$
	public static final String MNEMONIC_GREEN = "green";  //$NON-NLS-1$
	public static final String MNEMONIC_GSAM = "GSAM";  //$NON-NLS-1$
	public static final String MNEMONIC_HARDIOERROR = "hardIoError";  //$NON-NLS-1$
	public static final String MNEMONIC_HIDDEN = "hidden";  //$NON-NLS-1$
	public static final String MNEMONIC_HIGHLIGHT = "highlight";  //$NON-NLS-1$
	public static final String MNEMONIC_HPUX = "hpux";  //$NON-NLS-1$
	public static final String MNEMONIC_HTML = "html";  //$NON-NLS-1$
	public static final String MNEMONIC_HYPERLINK = "hyperlink";  //$NON-NLS-1$
	public static final String MNEMONIC_I4GL = "I4GL";  //$NON-NLS-1$
	public static final String MNEMONIC_IMSBMP = "imsbmp";  //$NON-NLS-1$
	public static final String MNEMONIC_IMSVS = "imsvs";  //$NON-NLS-1$
	public static final String MNEMONIC_JAVASCRIPT = "javascript";  //$NON-NLS-1$

	public static final String MNEMONIC_AIXCICS = "aixcics";  //$NON-NLS-1$
	public static final String MNEMONIC_NTCICS = "ntcics";  //$NON-NLS-1$
	public static final String MNEMONIC_OS2 = "os2";  //$NON-NLS-1$
	public static final String MNEMONIC_OS2CICS = "os2cics";  //$NON-NLS-1$
	public static final String MNEMONIC_OS2GUI = "os2gui";  //$NON-NLS-1$
	public static final String MNEMONIC_SCO = "sco";  //$NON-NLS-1$
	public static final String MNEMONIC_SOLACICS = "solacics";  //$NON-NLS-1$
	public static final String MNEMONIC_TSO = "tso";  //$NON-NLS-1$
	public static final String MNEMONIC_VMCMS = "vmcms";  //$NON-NLS-1$
	public static final String MNEMONIC_VMBATCH = "vmbatch";  //$NON-NLS-1$
	public static final String MNEMONIC_WINGUI = "wingui";  //$NON-NLS-1$
	public static final String MNEMONIC_ZLINUX = "zlinux";  //$NON-NLS-1$
	
	
	public static final String MNEMONIC_INDEX = "index";  //$NON-NLS-1$
	public static final String MNEMONIC_INITIAL = "initial";  //$NON-NLS-1$
	public static final String MNEMONIC_INITIALATTRIBUTES = "initialAttributes";  //$NON-NLS-1$
	public static final String MNEMONIC_INPUT = "input";  //$NON-NLS-1$
	public static final String MNEMONIC_INPUTOUTPUT = "inputOutput";  //$NON-NLS-1$
	public static final String MNEMONIC_INTENSITY = "intensity";  //$NON-NLS-1$
	public static final String MNEMONIC_INVALIDFORMAT = "invalidFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_INVISIBLE = "invisible";  //$NON-NLS-1$
	public static final String MNEMONIC_IOERROR = "ioError";  //$NON-NLS-1$
	public static final String MNEMONIC_ISERIESC = "iseriesc";  //$NON-NLS-1$
	public static final String MNEMONIC_ISERIESJ = "iseriesj";  //$NON-NLS-1$
	public static final String MNEMONIC_ISODATEFORMAT = "isoDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_ISOTIMEFORMAT = "isoTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_JISDATEFORMAT = "jisDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_JISTIMEFORMAT = "jisTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_L = "l";  //$NON-NLS-1$
	public static final String MNEMONIC_LIBRARY = "library";  //$NON-NLS-1$
	public static final String MNEMONIC_LEADING = "leading";  //$NON-NLS-1$
	public static final String MNEMONIC_LEFT = "left";  //$NON-NLS-1$
	public static final String MNEMONIC_LINUX = "linux";  //$NON-NLS-1$
	public static final String MNEMONIC_LOCAL = "local";  //$NON-NLS-1$
	public static final String MNEMONIC_LOWER = "lower";  //$NON-NLS-1$
	public static final String MNEMONIC_MAGENTA = "magenta";  //$NON-NLS-1$
	public static final String MNEMONIC_MAIN = "main";  //$NON-NLS-1$
	public static final String MNEMONIC_MASKED = "masked";  //$NON-NLS-1$
	public static final String MNEMONIC_MENU_ACTION = "menu_Action";  //$NON-NLS-1$
	public static final String MNEMONIC_MESSAGELINE = "messageLine";  //$NON-NLS-1$
	public static final String MNEMONIC_MENULINE = "menuLine";  //$NON-NLS-1$
	public static final String MNEMONIC_MODIFIED = "modified";  //$NON-NLS-1$
	public static final String MNEMONIC_NO = "no";  //$NON-NLS-1$
	public static final String MNEMONIC_NOAUTOCOMMIT = "noAutoCommit";  //$NON-NLS-1$
	public static final String MNEMONIC_NOCOMMIT = "noCommit";  //$NON-NLS-1$
	public static final String MNEMONIC_NORECORDFOUND = "noRecordFound";  //$NON-NLS-1$
	public static final String MNEMONIC_NORMAL = "normal";  //$NON-NLS-1$
	public static final String MNEMONIC_NOHIGHLIGHT = "nohighlight";  //$NON-NLS-1$
	public static final String MNEMONIC_NONE = "none";  //$NON-NLS-1$
	public static final String MNEMONIC_NOOUTLINE = "noOutline";  //$NON-NLS-1$
	public static final String MNEMONIC_NORMALINTENSITY = "normalIntensity";  //$NON-NLS-1$
	public static final String MNEMONIC_NULLFILL = "nullFill";  //$NON-NLS-1$
	public static final String MNEMONIC_NUMERIC = "numeric";  //$NON-NLS-1$
	public static final String MNEMONIC_ODBCTIMESTAMPFORMAT = "odbcTimeStampFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_ON_KEY = "on_Key";  //$NON-NLS-1$
	public static final String MNEMONIC_OUTPUT = "output";  //$NON-NLS-1$
	public static final String MNEMONIC_PAKEY = "pakey";  //$NON-NLS-1$
	public static final String MNEMONIC_PARENS = "parens";  //$NON-NLS-1$
	public static final String MNEMONIC_PDF = "pdf";  //$NON-NLS-1$
	public static final String MNEMONIC_PFKEY = "pfkey";  //$NON-NLS-1$
	public static final String MNEMONIC_POSITION = "position";  //$NON-NLS-1$
	public static final String MNEMONIC_PROGRAMLINK = "programLink";  //$NON-NLS-1$
	public static final String MNEMONIC_PROMPTLINE = "promptLine";  //$NON-NLS-1$
	public static final String MNEMONIC_PROTECT = "protect";  //$NON-NLS-1$
	public static final String MNEMONIC_R = "r";  //$NON-NLS-1$
	public static final String MNEMONIC_READCOMMITTED = "readCommitted";  //$NON-NLS-1$
	public static final String MNEMONIC_READUNCOMMITTED = "readUncommitted";  //$NON-NLS-1$
	public static final String MNEMONIC_RED = "red";  //$NON-NLS-1$
	public static final String MNEMONIC_REPEATABLEREAD = "repeatableRead";  //$NON-NLS-1$
	public static final String MNEMONIC_REPORTDATA = "reportData";  //$NON-NLS-1$
	public static final String MNEMONIC_REQUEST = "request";  //$NON-NLS-1$
	public static final String MNEMONIC_REVERSE = "reverse";  //$NON-NLS-1$
	public static final String MNEMONIC_RIGHT = "right";  //$NON-NLS-1$
	public static final String MNEMONIC_SECRET = "secret";  //$NON-NLS-1$
	public static final String MNEMONIC_SERIALIZABLETRANSACTION = "serializableTransaction";  //$NON-NLS-1$
	public static final String MNEMONIC_SESSION = "session";  //$NON-NLS-1$
	public static final String MNEMONIC_SET = "set";  //$NON-NLS-1$
	public static final String MNEMONIC_SINGLEBYTE = "singleByte";  //$NON-NLS-1$
	public static final String MNEMONIC_SKIP = "skip";  //$NON-NLS-1$
	public static final String MNEMONIC_SOFTIOERROR = "softIoError";  //$NON-NLS-1$
	public static final String MNEMONIC_SOLARIS = "solaris";  //$NON-NLS-1$
	public static final String MNEMONIC_SQLSTATEMENT = "sqlStatement";  //$NON-NLS-1$
	public static final String MNEMONIC_SUBMIT = "submit";  //$NON-NLS-1$
	public static final String MNEMONIC_SUBMITBYPASS = "submitBypass";  //$NON-NLS-1$
	public static final String MNEMONIC_SYSTEMGREGORIANDATEFORMAT = "systemGregorianDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_SYSTEMJULIANDATEFORMAT = "systemJulianDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_TABLE = "table";  //$NON-NLS-1$
	public static final String MNEMONIC_TCPIP = "tcpip";  //$NON-NLS-1$
	public static final String MNEMONIC_TEXT = "text";  //$NON-NLS-1$
	public static final String MNEMONIC_TOP = "top";  //$NON-NLS-1$
	public static final String MNEMONIC_TP = "TP";  //$NON-NLS-1$
	public static final String MNEMONIC_TRAILING = "trailing";  //$NON-NLS-1$
	public static final String MNEMONIC_TRUNC = "trunc";  //$NON-NLS-1$
	public static final String MNEMONIC_TWOPHASE = "twoPhase";  //$NON-NLS-1$
	public static final String MNEMONIC_TYPE1 = "type1";  //$NON-NLS-1$
	public static final String MNEMONIC_TYPE2 = "type2";  //$NON-NLS-1$
	public static final String MNEMONIC_UIFORM = "uiForm";  //$NON-NLS-1$
	public static final String MNEMONIC_UNDERLINE = "underline";  //$NON-NLS-1$
	public static final String MNEMONIC_UNIQUE = "unique";  //$NON-NLS-1$
	public static final String MNEMONIC_UNPROTECT = "unprotect";  //$NON-NLS-1$
	public static final String MNEMONIC_UPPER = "upper";  //$NON-NLS-1$
	public static final String MNEMONIC_USADATEFORMAT = "usaDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_USATIMEFORMAT = "usaTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_USS = "uss";  //$NON-NLS-1$
	public static final String MNEMONIC_VALUE = "value";  //$NON-NLS-1$
	public static final String MNEMONIC_VSEBATCH = "vsebatch";  //$NON-NLS-1$
	public static final String MNEMONIC_VSECICS = "vsecics";  //$NON-NLS-1$
	public static final String MNEMONIC_WHITE = "white";  //$NON-NLS-1$
	public static final String MNEMONIC_WIN = "win";  //$NON-NLS-1$
	public static final String MNEMONIC_WORD = "word";  //$NON-NLS-1$
	public static final String MNEMONIC_XML = "xml";  //$NON-NLS-1$
	public static final String MNEMONIC_YELLOW = "yellow";  //$NON-NLS-1$
	public static final String MNEMONIC_YES = "yes";  //$NON-NLS-1$
	public static final String MNEMONIC_ZOSBATCH = "zosbatch";  //$NON-NLS-1$
	public static final String MNEMONIC_ZOSCICS = "zoscics";  //$NON-NLS-1$

	//	EGL SQL keywords
	//Generated :  Mon Jan 22 12:24:32 EST 2007
	//These keywords should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLSQLKeywordTool
	public static final String SQLKEYWORD_ABSOLUTE = "absolute";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ACTION = "action";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ADD = "add";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ALIAS = "alias";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ALL = "all";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ALLOCATE = "allocate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ALTER = "alter";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AND = "and";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ANY = "any";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ARE = "are";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AS = "as";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ASC = "asc";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ASSERTION = "assertion";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AT = "at";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AUTHORIZATION = "authorization";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AVG = "avg";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BEGIN = "begin";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BETWEEN = "between";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BIGINT = "bigint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BINARYLARGEOBJECT = "binaryLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BIT = "bit";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BIT_LENGTH = "bit_length";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BLOB = "blob";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BOOLEAN = "boolean";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BOTH = "both";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BY = "by";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CALL = "call";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CASCADE = "cascade";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CASCADED = "cascaded";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CASE = "case";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CAST = "cast";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CATALOG = "catalog";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHAR = "char";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHAR_LENGTH = "char_length";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARACTER = "character";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARACTER_LENGTH = "character_length";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARACTERLARGEOBJECT = "characterLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARACTERVARYING = "characterVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARLARGEOBJECT = "charLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARVARYING = "charVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHECK = "check";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CLOB = "clob";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CLOSE = "close";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COALESCE = "coalesce";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COLLATE = "collate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COLLATION = "collation";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COLUMN = "column";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COMMENT = "comment";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COMMIT = "commit";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONNECT = "connect";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONNECTION = "connection";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONSTRAINT = "constraint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONSTRAINTS = "constraints";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONTINUE = "continue";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONVERT = "convert";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COPY = "copy";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CORRESPONDING = "corresponding";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COUNT = "count";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CREATE = "create";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CROSS = "cross";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT = "current";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT_DATE = "current_date";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT_TIME = "current_time";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT_TIMESTAMP = "current_timestamp";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT_USER = "current_user";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURSOR = "cursor";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DATA = "data";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DATABASE = "database";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DATE = "date";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DATETIME = "dateTime";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DAY = "day";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEALLOCATE = "deallocate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEC = "dec";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DECIMAL = "decimal";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DECLARE = "declare";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEFAULT = "default";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEFERRABLE = "deferrable";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEFERRED = "deferred";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DELETE = "delete";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DESC = "desc";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DESCRIBE = "describe";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DIAGNOSTICS = "diagnostics";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DISCONNECT = "disconnect";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DISTINCT = "distinct";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DOMAIN = "domain";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DOUBLE = "double";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DOUBLEPRECISION = "doublePrecision";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DROP = "drop";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ELSE = "else";  //$NON-NLS-1$
	public static final String SQLKEYWORD_END = "end";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ENDEXEC = "endExec";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ESCAPE = "escape";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXCEPT = "except";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXCEPTION = "exception";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXEC = "exec";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXECUTE = "execute";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXISTS = "exists";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXPLAIN = "explain";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXTERNAL = "external";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXTRACT = "extract";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FALSE = "false";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FETCH = "fetch";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FIRST = "first";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FLOAT = "float";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FOR = "for";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FOREIGN = "foreign";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FOUND = "found";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FROM = "from";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FULL = "full";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GET = "get";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GETCURRENTCONNECTION = "getCurrentConnection";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GLOBAL = "global";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GO = "go";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GOTO = "goto";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GRAPHIC = "graphic";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GRANT = "grant";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GROUP = "group";  //$NON-NLS-1$
	public static final String SQLKEYWORD_HAVING = "having";  //$NON-NLS-1$
	public static final String SQLKEYWORD_HOUR = "hour";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IDENTITY = "identity";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IMAGE = "image";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IMMEDIATE = "immediate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IN = "in";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INDEX = "index";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INDICATOR = "indicator";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INITIALLY = "initially";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INNER = "inner";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INPUT = "input";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INSENSITIVE = "insensitive";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INSERT = "insert";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INT = "int";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INTEGER = "integer";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INTERSECT = "intersect";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INTO = "into";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IS = "is";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ISOLATION = "isolation";  //$NON-NLS-1$
	public static final String SQLKEYWORD_JOIN = "join";  //$NON-NLS-1$
	public static final String SQLKEYWORD_KEY = "key";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LANGUAGE = "language";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LAST = "last";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LEADING = "leading";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LEFT = "left";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LEVEL = "level";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LIKE = "like";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LOCAL = "local";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LONG = "long";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LONGINT = "longint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LOWER = "lower";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LTRIM = "ltrim";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MATCH = "match";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MAX = "max";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MIN = "min";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MINUTE = "minute";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MODULE = "module";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MONTH = "month";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONAL = "national";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARACTER = "nationalCharacter";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARACTERLARGEOBJECT = "nationalCharacterLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARACTERVARYING = "nationalCharacterVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARLARGEOBJECT = "nationalCharLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARVARYING = "nationalCharVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATURAL = "natural";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NCHAR = "nchar";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NCHARVARYING = "ncharVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NCLOB = "nclob";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NEXT = "next";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NO = "no";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NOT = "not";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NULL = "null";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NULLIF = "nullIf";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NUMBER = "number";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NUMERIC = "numeric";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OCTET_LENGTH = "octet_length";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OF = "of";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ON = "on";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ONLY = "only";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OPEN = "open";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OPTION = "option";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OR = "or";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ORDER = "order";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OUTER = "outer";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OUTPUT = "output";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OVERLAPS = "overlaps";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PAD = "pad";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PARTIAL = "partial";  //$NON-NLS-1$
	public static final String SQLKEYWORD_POSITION = "position";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PREPARE = "prepare";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PRESERVE = "preserve";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PRIMARY = "primary";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PRIOR = "prior";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PRIVILEGES = "privileges";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PROCEDURE = "procedure";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PUBLIC = "public";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RAW = "raw";  //$NON-NLS-1$
	public static final String SQLKEYWORD_READ = "read";  //$NON-NLS-1$
	public static final String SQLKEYWORD_REAL = "real";  //$NON-NLS-1$
	public static final String SQLKEYWORD_REFERENCES = "references";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RELATIVE = "relative";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RESTRICT = "restrict";  //$NON-NLS-1$
	public static final String SQLKEYWORD_REVOKE = "revoke";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RIGHT = "right";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ROLLBACK = "rollback";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ROWS = "rows";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RTRIM = "rtrim";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RUNTIMESTATISTICS = "runtimeStatistics";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SCHEMA = "schema";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SCROLL = "scroll";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SECOND = "second";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SECTION = "section";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SELECT = "select";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SESSION = "session";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SESSION_USER = "session_user";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SET = "set";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SIGNAL = "signal";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SIZE = "size";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SMALLINT = "smallint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SOME = "some";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SPACE = "space";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQL = "sql";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQLCONDITION = "sqlCondition";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQLCODE = "sqlcode";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQLERROR = "sqlerror";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQLSTATE = "sqlstate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SUBSTR = "substr";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SUBSTRING = "substring";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SUM = "sum";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SYSTEM_USER = "system_user";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TABLE = "table";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TABLESPACE = "tablespace";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TEMPORARY = "temporary";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TERMINATE = "terminate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_THEN = "then";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TIME = "time";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TIMESTAMP = "timestamp";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TIMEZONE_HOUR = "timezone_hour";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TIMEZONE_MINUTE = "timezone_minute";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TINYINT = "tinyint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TO = "to";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRAILING = "trailing";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRANSACTION = "transaction";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRANSLATE = "translate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRANSLATION = "translation";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRIM = "trim";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRUE = "true";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UNCATALOG = "uncatalog";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UNION = "union";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UNIQUE = "unique";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UNKNOWN = "unknown";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UPDATE = "update";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UPPER = "upper";  //$NON-NLS-1$
	public static final String SQLKEYWORD_USAGE = "usage";  //$NON-NLS-1$
	public static final String SQLKEYWORD_USER = "user";  //$NON-NLS-1$
	public static final String SQLKEYWORD_USING = "using";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VALUES = "values";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARBINARY = "varbinary";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARCHAR = "varchar";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARCHAR2 = "varchar2";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARGRAPHIC = "vargraphic";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARYING = "varying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VIEW = "view";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WHEN = "when";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WHENEVER = "whenever";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WHERE = "where";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WITH = "with";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WORK = "work";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WRITE = "write";  //$NON-NLS-1$
	public static final String SQLKEYWORD_YEAR = "year";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ZONE = "zone";  //$NON-NLS-1$
	
	//EGL system words
	//Generated :  Wed Mar 23 15:00:56 EST 2005
	//These system words should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLSystemWordTool
	public static final String SYSTEM_WORD_STORENEW = "StoreNew";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ABS = "abs";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACOS = "acos";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACTIVATEWINDOW = "activateWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACTIVATEWINDOWBYNAME = "activateWindowByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACTIVEFORM = "activeForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACTIVEWINDOW = "activeWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ADDREPORTDATA = "addReportData";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ADDREPORTPARAMETER = "addReportParameter";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_APPENDALL = "appendAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_APPENDELEMENT = "appendElement";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ARRAYINDEX = "arrayIndex";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ASIN = "asin";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATAN = "atan";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATAN2 = "atan2";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATTACHBLOBTOFILE = "attachBlobToFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATTACHBLOBTOTEMPFILE = "attachBlobToTempFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATTACHCLOBTOFILE = "attachClobToFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATTACHCLOBTOTEMPFILE = "attachClobToTempFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_AUDIT = "audit";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_BOOLEANASINT = "booleanAsInt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_BOOLEANASSTRING = "booleanAsString";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_BEGINDATABASETRANSACTION = "beginDatabaseTransaction";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_BYTES = "bytes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CALCULATECHKDIGITMOD10 = "calculateChkDigitMod10";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CALCULATECHKDIGITMOD11 = "calculateChkDigitMod11";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CALLCMD = "callCmd";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CALLCONVERSIONTABLE = "callConversionTable";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CANCELARRAYDELETE = "cancelArrayDelete";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CANCELARRAYINSERT = "cancelArrayInsert";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CEILING = "ceiling";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CHARACTERASINT = "characterAsInt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CICSCONDITION = "cicsCondition";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CICSERROR = "cicsError";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CICSRESTART = "cicsRestart";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARACTIVEFORM = "clearActiveForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARACTIVEWINDOW = "clearActiveWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEAREGLSESSIONATTRS = "clearEGLSessionAttrs";//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARFIELDS = "clearFields";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARFIELDSBYNAME = "clearFieldsByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARFORM = "clearForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARREQUESTATTR = "clearRequestAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARSCREEN = "clearScreen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARSESSIONATTR = "clearSessionAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARWINDOW = "clearWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARWINDOWBYNAME = "clearWindowByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLIP = "clip";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLOSEACTIVEWINDOW = "closeActiveWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLOSEWINDOW = "closeWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLOSEWINDOWBYNAME = "closeWindowByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMMENTLINE = "commentLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMMIT = "commit";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMMITONCONVERSE = "commitOnConverse";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMPAREBYTES = "compareBytes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMPARENUM = "compareNum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMPARESTR = "compareStr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONCATENATE = "concatenate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONCATENATEBYTES = "concatenateBytes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONCATENATEWITHSEPARATOR = "concatenateWithSeparator";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONDITIONASINT = "conditionAsInt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONNECT = "connect";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONNECTIONSERVICE = "connectionService";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONTAINSKEY = "containsKey";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONVERSATIONID = "conversationId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONVERT = "convert";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COPYBYTES = "copyBytes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COPYSTR = "copyStr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COS = "cos";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COSH = "cosh";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTARRAYCOUNT = "currentArrayCount";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTARRAYDATALINE = "currentArrayDataLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTARRAYSCREENLINE = "currentArrayScreenLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTDATE = "currentDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTDISPLAYATTRS = "currentDisplayAttrs";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTEXCEPTION = "currentException";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTFORMATTEDGREGORIANDATE = "currentFormattedGregorianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTFORMATTEDJULIANDATE = "currentFormattedJulianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTFORMATTEDTIME = "currentFormattedTime";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTGREGORIANDATE = "currentGregorianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTJULIANDATE = "currentJulianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTROWATTRS = "currentRowAttrs";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTSHORTGREGORIANDATE = "currentShortGregorianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTSHORTJULIANDATE = "currentShortJulianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTTIME = "currentTime";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTTIMESTAMP = "currentTimeStamp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURSORWRAP = "cursorWrap";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEFROMINT = "dateFromInt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEOF = "dateOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEVALUE = "dateValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEVALUEFROMGREGORIAN = "dateValueFromGregorian";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEVALUEFROMJULIAN = "dateValueFromJulian";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DAYOF = "dayOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DB2TIMESTAMPFORMAT = "db2TimeStampFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DBNAME = "dbName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTDATEFORMAT = "defaultDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTDISPLAYATTRIBUTES = "defaultDisplayAttributes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTINPUTATTRIBUTES = "defaultInputAttributes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTMONEYFORMAT = "defaultMoneyFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTNUMERICFORMAT = "defaultNumericFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTTIMEFORMAT = "defaultTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTTIMESTAMPFORMAT = "defaultTimeStampFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFERINTERRUPT = "deferInterrupt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFERQUIT = "deferQuit";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFINEDATABASEALIAS = "defineDatabaseAlias";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFINEDFIELDORDER = "definedFieldOrder";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISCONNECT = "disconnect";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISCONNECTALL = "disconnectAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYATLINE = "displayAtLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYATPOSITION = "displayAtPosition";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYERROR = "displayError";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYFIELDS = "displayFields";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYFIELDSBYNAME = "displayFieldsByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYFORM = "displayForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYFORMBYNAME = "displayFormByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYLINEMODE = "displayLineMode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYMESSAGE = "displayMessage";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYMSGNUM = "displayMsgNum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DRAWBOX = "drawBox";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DRAWBOXWITHCOLOR = "drawBoxWithColor";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORCODE = "errorCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORLINE = "errorLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORLOG = "errorLog";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORWINDOW = "errorWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORWINDOWVISIBLE = "errorWindowVisible";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EURDATEFORMAT = "eurDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EURTIMEFORMAT = "eurTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EVENTKEY = "eventKey";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EXP = "exp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EXPORTREPORT = "exportReport";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EXTEND = "extend";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FIELDINPUTLENGTH = "fieldInputLength";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FILLREPORT = "fillReport";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FINDSTR = "findStr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGASSIGN = "floatingAssign";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGDIFFERENCE = "floatingDifference";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGMOD = "floatingMod";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGPRODUCT = "floatingProduct";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGQUOTIENT = "floatingQuotient";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGSUM = "floatingSum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOOR = "floor";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMCONVERSIONTABLE = "formConversionTable";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMLINE = "formLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMATDATE = "formatDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMATNUMBER = "formatNumber";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMATTIME = "formatTime";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMATTIMESTAMP = "formatTimeStamp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FREEBLOB = "freeBlob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FREECLOB = "freeClob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FREXP = "frexp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETBLOBLEN = "getBlobLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETCLOBLEN = "getClobLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETCMDLINEARG = "getCmdLineArg";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETCMDLINEARGCOUNT = "getCmdLineArgCount";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETDATACOLUMNBINDING = "getDataColumnBinding";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETFIELD = "getField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETFIELDVALUE = "getFieldValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETKEY = "getKey";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETKEYCODE = "getKeyCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETKEYNAME = "getKeyName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETKEYS = "getKeys";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETMAXSIZE = "getMaxSize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETMESSAGE = "getMessage";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETNEXTTOKEN = "getNextToken";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETPROPERTY = "getProperty";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETREPORTDATA = "getReportData";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETREPORTPARAMETER = "getReportParameter";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETREPORTVARIABLEVALUE = "getReportVariableValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETREQUESTATTR = "getRequestAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETSESSIONATTR = "getSessionAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETSIZE = "getSize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETSTRFROMCLOB = "getStrFromClob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETSUBSTRFROMCLOB = "getSubStrFromClob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETTCPIPLOCATION = "getTCPIPLocation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETVAGSYSTYPE = "getVAGSysType";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETVALUES = "getValues";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETWEBSERVICELOCATION = "getWebServiceLocation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GOTOFIELD = "gotoField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GOTOFIELDBYNAME = "gotoFieldByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GOTOMENUITEM = "gotoMenuItem";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GOTOMENUITEMBYNAME = "gotoMenuItemByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HANDLEHARDIOERRORS = "handleHardIOErrors";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HANDLEOVERFLOW = "handleOverflow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HANDLESYSLIBRARYERRORS = "handleSysLibraryErrors";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HIDEALLMENUITEMS = "hideAllMenuItems";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HIDEERRORWINDOW = "hideErrorWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HIDEMENUITEM = "hideMenuItem";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HIDEMENUITEMBYNAME = "hideMenuItemByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INSERTALL = "insertAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INSERTELEMENT = "insertElement";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INTEGERASCHAR = "integerAsChar";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INTERRUPTREQUESTED = "interruptRequested";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INTERVALVALUE = "intervalValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INTERVALVALUEWITHPATTERN = "intervalValueWithPattern";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INVOKE = "invoke";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISCURRENTFIELD = "isCurrentField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISCURRENTFIELDBYNAME = "isCurrentFieldByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISFIELDMODIFIED = "isFieldModified";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISFIELDMODIFIEDBYNAME = "isFieldModifiedByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISNULL = "isNull";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISOBJID = "isObjId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISODATEFORMAT = "isoDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISOTIMEFORMAT = "isoTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_JISDATEFORMAT = "jisDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_JISTIMEFORMAT = "jisTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEYAREA = "keyArea";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEYAREAHEX = "keyAreaHex";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEYAREALEN = "keyAreaLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_ACCEPT = "key_accept";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_DELETELINE = "key_deleteLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_HELP = "key_help";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_INSERTLINE = "key_insertLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_INTERRUPT = "key_interrupt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_PAGEDOWN = "key_pageDown";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_PAGEUP = "key_pageUp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_QUIT = "key_quit";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LASTKEYTYPED = "lastKeyTyped";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LDEXP = "ldexp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOADBLOBFROMFILE = "loadBlobFromFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOADCLOBFROMFILE = "loadClobFromFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOADSERVICE = "loadService";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOADTABLE = "loadTable";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOG = "log";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOG10 = "log10";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOWERCASE = "lowerCase";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MAXIMUM = "maximum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MAXIMUMSIZE = "maximumSize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MDY = "mdy";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MENULINE = "menuLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MESSAGELINE = "messageLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MESSAGERESOURCE = "messageResource";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MINIMUM = "minimum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MODF = "modf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MONTHOF = "monthOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MQCONDITIONCODE = "mqConditionCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_NEXTFIELD = "nextField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_NULLFILL = "nullFill";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_NUMSENSITIVESEGS = "numSensitiveSegs";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ODBCTIMESTAMPFORMAT = "odbcTimeStampFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OPENWINDOW = "openWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OPENWINDOWBYNAME = "openWindowByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OPENWINDOWWITHFORM = "openWindowWithForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OPENWINDOWWITHFORMBYNAME = "openWindowWithFormByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OVERFLOWINDICATOR = "overflowIndicator";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PAGEEJECT = "pageEject";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_POW = "pow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PRECISION = "precision";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PREVIOUSFIELD = "previousField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PRINTERASSOCIATION = "printerAssociation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PROCOPTIONS = "procOptions";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PROMPTLINE = "promptLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PROMPTLINEMODE = "promptLineMode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PURGE = "purge";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_QUALIFIEDTYPENAME = "qualifiedTypeName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_QUERYCURRENTDATABASE = "queryCurrentDatabase";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_QUITREQUESTED = "quitRequested";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_REMOTESYSTEMID = "remoteSystemId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_REMOVE = "remove";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_REMOVEALL = "removeAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_REMOVEELEMENT = "removeElement";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RESETREPORTPARAMETERS = "resetReportParameters";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RESIZE = "resize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RESIZEALL = "resizeAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RESOURCEASSOCIATION = "resourceAssociation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RETURNCODE = "returnCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ROLLBACK = "rollback";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ROUND = "round";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCREEN = "screen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCROLLDOWNLINES = "scrollDownLines";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCROLLDOWNPAGE = "scrollDownPage";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCROLLUPLINES = "scrollUpLines";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCROLLUPPAGE = "scrollUpPage";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SEGMENTLEVEL = "segmentLevel";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SEGMENTNAME = "segmentName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SEGMENTEDMODE = "segmentedMode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SESSIONID = "sessionId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETARRAYLINE = "setArrayLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETBLANKTERMINATOR = "setBlankTerminator";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETCLOBFROMSTRING = "setClobFromString";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETCLOBFROMSTRINGATPOSITION = "setClobFromStringAtPosition";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETCURRENTARRAYCOUNT = "setCurrentArrayCount";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETCURRENTDATABASE = "setCurrentDatabase";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETELEMENT = "setElement";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETELEMENTSEMPTY = "setElementsEmpty";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETERROR = "setError";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETFIELD = "setField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETLOCALE = "setLocale";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETMAXSIZE = "setMaxSize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETMAXSIZES = "setMaxSizes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETNULLTERMINATOR = "setNullTerminator";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETREMOTEUSER = "setRemoteUser";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETREPORTVARIABLEVALUE = "setReportVariableValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETREQUESTATTR = "setRequestAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETSESSIONATTR = "setSessionAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETSUBSTR = "setSubStr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETTCPIPLOCATION = "setTCPIPLocation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETWEBSERVICELOCATION = "setWebServiceLocation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SHOWALLMENUITEMS = "showAllMenuItems";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SHOWHELP = "showHelp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SHOWMENUITEM = "showMenuItem";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SHOWMENUITEMBYNAME = "showMenuItemByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SIN = "sin";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SINH = "sinh";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SIZE = "size";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SPACES = "spaces";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLINTERRUPT = "sqlInterrupt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLISOLATIONLEVEL = "sqlIsolationLevel";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLSTATE = "sqlState";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLCA = "sqlca";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLCODE = "sqlcode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLERRD = "sqlerrd";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLERRMC = "sqlerrmc";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLWARN = "sqlwarn";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQRT = "sqrt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STARTCMD = "startCmd";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STARTLOG = "startLog";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STARTTRANSACTION = "startTransaction";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STATUSCODE = "statusCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STORE = "store";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STORECOPY = "storeCopy";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STOREFIELD = "storeField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STRLEN = "strLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STRINGASDECIMAL = "stringAsDecimal";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STRINGASFLOAT = "stringAsFloat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STRINGASINT = "stringAsInt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SYSTEMGREGORIANDATEFORMAT = "systemGregorianDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SYSTEMJULIANDATEFORMAT = "systemJulianDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SYSTEMTYPE = "systemType";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TAN = "tan";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TANH = "tanh";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TERMINALID = "terminalId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TEXTLEN = "textLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMEOF = "timeOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMESTAMPVALUE = "timeStampValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMESTAMPVALUEWITHPATTERN = "timeStampValueWithPattern";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMEVALUE = "timeValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMESTAMPFROM = "timestampFrom";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TRANSACTIONID = "transactionId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TRANSFERNAME = "transferName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TRUNCATEBLOB = "truncateBlob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TRUNCATECLOB = "truncateClob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UNLOADTABLE = "unloadTable";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UPDATEBLOBTOFILE = "updateBlobToFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UPDATECLOBTOFILE = "updateClobToFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UPDATEWINDOWATTRIBUTES = "updateWindowAttributes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UPPERCASE = "upperCase";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_USADATEFORMAT = "usaDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_USATIMEFORMAT = "usaTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_USERID = "userId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_VALIDATIONFAILED = "validationFailed";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_VALIDATIONMSGNUM = "validationMsgNum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_VERIFYCHKDIGITMOD10 = "verifyChkDigitMod10";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_VERIFYCHKDIGITMOD11 = "verifyChkDigitMod11";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_WAIT = "wait";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_WEEKDAYOF = "weekdayOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_WRITESTDOUT = "writeStdout";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_WRITESTDERR = "writeStderr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_YEAROF = "yearOf";	//$NON-NLS-1$




	//EGL properties
	//Generated :  Wed Jun 08 15:37:21 EDT 2005
	//These properties should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLPropertiesTool
	public static final String PROPERTY_ACTION = "action";  //$NON-NLS-1$
	public static final String PROPERTY_ADDSPACEFORSOSI = "addSpaceForSOSI";  //$NON-NLS-1$
	public static final String PROPERTY_ALIAS = "alias";  //$NON-NLS-1$
	public static final String PROPERTY_ALIGN = "align";  //$NON-NLS-1$
	public static final String PROPERTY_ALLOWAPPEND = "allowAppend";  //$NON-NLS-1$
	public static final String PROPERTY_ALLOWDELETE = "allowDelete";  //$NON-NLS-1$
	public static final String PROPERTY_ALLOWINSERT = "allowInsert";  //$NON-NLS-1$
	public static final String PROPERTY_ALLOWUNQUALIFIEDITEMREFERENCES = "allowUnqualifiedItemReferences";  //$NON-NLS-1$
	public static final String PROPERTY_ASBYTES = "asBytes";  //$NON-NLS-1$
	public static final String PROPERTY_BIDITYPE = "bidiType";  //$NON-NLS-1$
	public static final String PROPERTY_BIDICONVERSIONTABLE = "bidiConversionTable";  //$NON-NLS-1$
	public static final String PROPERTY_BIDIINPUT = "BidiInput"; //$NON-NLS-1$
	public static final String PROPERTY_BIDIINPUTVISUAL = "visual"; //$NON-NLS-1$
	public static final String PROPERTY_BIDIINPUTLOGICAL = "logical"; //$NON-NLS-1$
	public static final String PROPERTY_BIDIORIENTATION = "orientation"; //$NON-NLS-1$
	public static final String PROPERTY_BIDIORIENTATIONLTR = "ltr"; //$NON-NLS-1$
	public static final String PROPERTY_BIDIORIENTATIONRTL = "rtl"; //$NON-NLS-1$
	public static final String PROPERTY_BINDING = "binding";  //$NON-NLS-1$
	public static final String PROPERTY_BINDINGBYNAME = "bindingByName";  //$NON-NLS-1$
	public static final String PROPERTY_BINDSERVICE = "bindService";  //$NON-NLS-1$
	public static final String PROPERTY_BINDINGKEY = "bindingKey";  //$NON-NLS-1$
	public static final String PROPERTY_BOTTOMMARGIN = "bottomMargin";  //$NON-NLS-1$
	public static final String PROPERTY_BOUNDS = "bounds";  //$NON-NLS-1$
	public static final String PROPERTY_BYPASSVALIDATION = "bypassValidation";  //$NON-NLS-1$
	public static final String PROPERTY_CALLINGCONVENTION = "callingConvention";  //$NON-NLS-1$
	public static final String PROPERTY_CALLINTERFACE = "callInterface";  //$NON-NLS-1$
	public static final String PROPERTY_CANCELONPAGETRANSITION = "cancelOnPageTransition";  //$NON-NLS-1$
	public static final String PROPERTY_CASESENSITIVE = "caseSensitive";  //$NON-NLS-1$
	public static final String PROPERTY_COLOR = "color";  //$NON-NLS-1$
	public static final String PROPERTY_COLUMN = "column";  //$NON-NLS-1$
	public static final String PROPERTY_COLUMNS = "columns";  //$NON-NLS-1$
	public static final String PROPERTY_COMMANDVALUEITEM = "commandValueItem";  //$NON-NLS-1$
	public static final String PROPERTY_COMMTYPE = "commType";  //$NON-NLS-1$
	public static final String PROPERTY_CONNECTIONNAME = "connectionName";  //$NON-NLS-1$
	public static final String PROPERTY_CONTAINERCONTEXTDEPENDENT = "containerContextDependent";  //$NON-NLS-1$
	public static final String PROPERTY_CONTENTS = "contents";  //$NON-NLS-1$
	public static final String PROPERTY_CURRENCY = "currency";  //$NON-NLS-1$
	public static final String PROPERTY_CURRENCYSYMBOL = "currencySymbol";  //$NON-NLS-1$
	public static final String PROPERTY_CURRENTARRAYCOUNT = "currentArrayCount";  //$NON-NLS-1$
	public static final String PROPERTY_CURSOR = "cursor";  //$NON-NLS-1$
	public static final String PROPERTY_DATA = "data";  //$NON-NLS-1$
	public static final String PROPERTY_DATATYPE = "dataType";  //$NON-NLS-1$
	public static final String PROPERTY_DATEFORMAT = "dateFormat";  //$NON-NLS-1$
	public static final String PROPERTY_DEBUGIMPL = "debugImpl";  //$NON-NLS-1$
	public static final String PROPERTY_DEDICATEDSERVICE = "dedicatedService";  //$NON-NLS-1$
	public static final String PROPERTY_RESOURCE = "Resource";  //$NON-NLS-1$
	public static final String PROPERTY_DEFAULTSELECTCONDITION = "defaultSelectCondition";  //$NON-NLS-1$
	public static final String PROPERTY_DELETEAFTERUSE = "deleteAfterUse";  //$NON-NLS-1$
	public static final String PROPERTY_DELIMITERS = "delimiters";  //$NON-NLS-1$
	public static final String PROPERTY_DELIMITER = "delimiter";  //$NON-NLS-1$
	public static final String PROPERTY_DERIVATIONBASE = "derivationBase";  //$NON-NLS-1$
	public static final String PROPERTY_DETECTABLE = "detectable";  //$NON-NLS-1$
	public static final String PROPERTY_DEVICETYPE = "deviceType";  //$NON-NLS-1$
	public static final String PROPERTY_DISPLAYNAME = "displayName";  //$NON-NLS-1$
	public static final String PROPERTY_DISPLAYONLY = "displayOnly";  //$NON-NLS-1$
	public static final String PROPERTY_DISPLAYUSE = "displayUse";  //$NON-NLS-1$
	public static final String PROPERTY_DLLNAME = "dllName";  //$NON-NLS-1$
	public static final String PROPERTY_EGLBINDING = "eglBinding";  //$NON-NLS-1$
	public static final String PROPERTY_ELEMENTNAME = "elementName";  //$NON-NLS-1$
	public static final String PROPERTY_ENABLESAVERESTORE = "enableSaveRestore";  //$NON-NLS-1$
	public static final String PROPERTY_ENDPOINT = "endpoint";  //$NON-NLS-1$
	public static final String PROPERTY_ENUMERATION = "enum";  //$NON-NLS-1$
	public static final String PROPERTY_ENUM = "enum";  //$NON-NLS-1$
	public static final String PROPERTY_ENTITY = "Entity";  //$NON-NLS-1$
	public static final String PROPERTY_EVENTLISTENER = "eventListener";  //$NON-NLS-1$
	public static final String PROPERTY_EVENTVALUEITEM = "eventValueItem";  //$NON-NLS-1$
	public static final String PROPERTY_FIELDDECLARATION = "fieldDeclaration";  //$NON-NLS-1$
	public static final String PROPERTY_FIELDLEN = "fieldLen";  //$NON-NLS-1$
	public static final String PROPERTY_FIELDSMATCHCOLUMNS = "fieldsMatchColumns";  //$NON-NLS-1$
	public static final String PROPERTY_FILENAME = "fileName";  //$NON-NLS-1$
	public static final String PROPERTY_FILL = "fill";  //$NON-NLS-1$
	public static final String PROPERTY_FILLCHARACTER = "fillCharacter";  //$NON-NLS-1$
	public static final String PROPERTY_FORMCONVERSIONTABLE = "formConversionTable";  //$NON-NLS-1$
	public static final String PROPERTY_FORMSIZE = "formSize";  //$NON-NLS-1$
	public static final String PROPERTY_GETINPARENT = "getInParent";  //$NON-NLS-1$
	public static final String PROPERTY_GETOPTIONSRECORD = "getOptionsRecord";  //$NON-NLS-1$
	public static final String PROPERTY_GENERATEDVALUE = "generatedValue";  //$NON-NLS-1$
	public static final String PROPERTY_HANDLEHARDIOERRORS = "handleHardIOErrors";  //$NON-NLS-1$
	public static final String PROPERTY_HASCOMMENT = "hasComment";  //$NON-NLS-1$
	public static final String PROPERTY_HELP = "help";  //$NON-NLS-1$
	public static final String PROPERTY_HELPFORM = "helpForm";  //$NON-NLS-1$
	public static final String PROPERTY_HELPGROUP = "helpGroup";  //$NON-NLS-1$
	public static final String PROPERTY_HELPKEY = "helpKey";  //$NON-NLS-1$
	public static final String PROPERTY_HELPMSGKEY = "helpMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_HIERARCHY = "hierarchy";  //$NON-NLS-1$
	public static final String PROPERTY_HIGHLIGHT = "highlight";  //$NON-NLS-1$
	public static final String PROPERTY_HOSTVARQUALIFIER = "hostVarQualifier";  //$NON-NLS-1$
	public static final String PROPERTY_I4GLITEMSNULLABLE = "I4GLItemsNullable";  //$NON-NLS-1$
	public static final String PROPERTY_ID = "Id";  //$NON-NLS-1$
	public static final String PROPERTY_INCLUDEMSGINTRANSACTION = "includeMsgInTransaction";  //$NON-NLS-1$
	public static final String PROPERTY_INCLUDEREFERENCEDFUNCTIONS = "includeReferencedFunctions";  //$NON-NLS-1$
	public static final String PROPERTY_INDEXORIENTATION = "indexOrientation";  //$NON-NLS-1$
	public static final String PROPERTY_INITIALIZED = "initialized";  //$NON-NLS-1$
	public static final String PROPERTY_INSERTABLE = "insertable";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTFORM = "inputForm";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTUIRECORD = "inputUIRecord";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTRECORD = "inputRecord";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTREQUIRED = "inputRequired";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATIONPROPERTIESLIBRARY = "validationPropertiesLibrary";
	public static final String PROPERTY_INPUTREQUIREDMSGKEY = "inputRequiredMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_INTENSITY = "intensity";  //$NON-NLS-1$
	public static final String PROPERTY_ISBOOLEAN = "isBoolean";  //$NON-NLS-1$
	public static final String PROPERTY_ISCONSTRUCT = "isConstruct";  //$NON-NLS-1$
	public static final String PROPERTY_ISDECIMALDIGIT = "isDecimalDigit";  //$NON-NLS-1$
	public static final String PROPERTY_ISEXTERNAL = "isExternal";  //$NON-NLS-1$
	public static final String PROPERTY_ISHEXDIGIT = "isHexDigit";  //$NON-NLS-1$
	public static final String PROPERTY_ISLASTPARAMRETURNVALUE = "isLastParamReturnValue";  //$NON-NLS-1$
	public static final String PROPERTY_ISNOREFRESH = "isNoRefresh";  //$NON-NLS-1$
	public static final String PROPERTY_ISREADONLY = "isReadOnly";  //$NON-NLS-1$
	public static final String PROPERTY_ISSQLNULLABLE = "isSqlNullable";  //$NON-NLS-1$
	public static final String PROPERTY_ITEMS = "items";  //$NON-NLS-1$
	public static final String PROPERTY_JAVANAME = "javaName";  //$NON-NLS-1$
	public static final String PROPERTY_JAVAPROPERTY = "javaProperty";  //$NON-NLS-1$
	public static final String PROPERTY_KEYITEM = "keyItem";  //$NON-NLS-1$
	public static final String PROPERTY_KEYITEMS = "keyItems";  //$NON-NLS-1$
	public static final String PROPERTY_LABELITEM = "labelItem";  //$NON-NLS-1$
	public static final String PROPERTY_LABELANDHELPRESOURCE = "labelAndHelpResource";  //$NON-NLS-1$
	public static final String PROPERTY_LEFTMARGIN = "leftMargin";  //$NON-NLS-1$
	public static final String PROPERTY_LENGTHITEM = "lengthItem";  //$NON-NLS-1$
	public static final String PROPERTY_LINESBETWEENROWS = "linesBetweenRows";  //$NON-NLS-1$
	public static final String PROPERTY_LINEWRAP = "lineWrap";  //$NON-NLS-1$
	public static final String PROPERTY_LINKAGEKEY = "linkageKey";  //$NON-NLS-1$
	public static final String PROPERTY_LINKPARMS = "linkParms";  //$NON-NLS-1$
	public static final String PROPERTY_LINKPARAMETER = "linkParameter";  //$NON-NLS-1$
	public static final String PROPERTY_LOCALSQLSCOPE = "localSQLScope";  //$NON-NLS-1$
	public static final String PROPERTY_LOWERCASE = "lowerCase";  //$NON-NLS-1$
	public static final String PROPERTY_MASKED = "masked";  //$NON-NLS-1$
	public static final String PROPERTY_MAXARRAYCOUNT = "maxArrayCount";  //$NON-NLS-1$
	public static final String PROPERTY_MAXINCLUSIVE = "maxInclusive";  //$NON-NLS-1$
	public static final String PROPERTY_MAXEXCLUSIVE = "maxExclusive";  //$NON-NLS-1$
	public static final String PROPERTY_MAXLENGTH = "maxLength";  //$NON-NLS-1$
	public static final String PROPERTY_MAXLEN = "maxLen";  //$NON-NLS-1$
	public static final String PROPERTY_MAXSIZE = "maxSize";  //$NON-NLS-1$
	public static final String PROPERTY_MINEXCLUSIVE = "minExclusive";  //$NON-NLS-1$
	public static final String PROPERTY_MININCLUSIVE = "minInclusive";  //$NON-NLS-1$
	public static final String PROPERTY_MINLENGTH = "minLength";  //$NON-NLS-1$
	public static final String PROPERTY_MINIMUMINPUT = "minimumInput";  //$NON-NLS-1$
	public static final String PROPERTY_MINIMUMINPUTMSGKEY = "minimumInputMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_MODIFIED = "modified";  //$NON-NLS-1$
	public static final String PROPERTY_MSGDESCRIPTORRECORD = "msgDescriptorRecord";  //$NON-NLS-1$
	public static final String PROPERTY_MSGFIELD = "msgField";  //$NON-NLS-1$
	public static final String PROPERTY_MSGKEY = "msgKey";  //$NON-NLS-1$
	public static final String PROPERTY_MSGRESOURCE = "msgResource";  //$NON-NLS-1$
	public static final String PROPERTY_MSGTABLEPREFIX = "msgTablePrefix";  //$NON-NLS-1$
	public static final String PROPERTY_NAME = "name";  //$NON-NLS-1$
	public static final String PROPERTY_NAMESPACE = "namespace";  //$NON-NLS-1$
	public static final String PROPERTY_NEEDSSOSI = "needsSOSI";  //$NON-NLS-1$
	public static final String PROPERTY_NEWWINDOW = "newWindow";  //$NON-NLS-1$
	public static final String PROPERTY_NUMELEMENTSITEM = "numElementsItem";  //$NON-NLS-1$
	public static final String PROPERTY_NUMERICSEPARATOR = "numericSeparator";  //$NON-NLS-1$
	public static final String PROPERTY_NUMERICSWAPPING = "numericSwapping";  //$NON-NLS-1$
	public static final String PROPERTY_ONCONSTRUCTIONFUNCTION = "onConstructionFunction";  //$NON-NLS-1$
	public static final String PROPERTY_ONPOSTRENDERFUNCTION = "onPostRenderFunction";  //$NON-NLS-1$
	public static final String PROPERTY_ONPRERENDERFUNCTION = "onPreRenderFunction";  //$NON-NLS-1$
	public static final String PROPERTY_ONVALUECHANGEFUNCTION = "onValueChangeFunction";  //$NON-NLS-1$
	public static final String PROPERTY_OPENOPTIONSRECORD = "openOptionsRecord";  //$NON-NLS-1$
	public static final String PROPERTY_OPENQUEUEEXCLUSIVE = "openQueueExclusive";  //$NON-NLS-1$
	public static final String PROPERTY_ORDERING = "ordering";  //$NON-NLS-1$
	public static final String PROPERTY_ORIENTINDEXACROSS = "orientIndexAcross";  //$NON-NLS-1$
	public static final String PROPERTY_OUTLINE = "outline";  //$NON-NLS-1$
	public static final String PROPERTY_PACKAGENAME = "packageName";  //$NON-NLS-1$
	public static final String PROPERTY_PAGESIZE = "pageSize";  //$NON-NLS-1$
	public static final String PROPERTY_PARENTRECORD = "parentRecord";  //$NON-NLS-1$
	public static final String PROPERTY_PATTERN = "pattern";  //$NON-NLS-1$
	public static final String PROPERTY_PERSISTENT = "persistent";  //$NON-NLS-1$
	public static final String PROPERTY_PFKEYEQUATE = "pfKeyEquate";  //$NON-NLS-1$
	public static final String PROPERTY_POSITION = "position";  //$NON-NLS-1$
	public static final String PROPERTY_PRINTFLOATINGAREA = "printFloatingArea";  //$NON-NLS-1$
	public static final String PROPERTY_PRINTFLOATINGAREAS = "printFloatingAreas";  //$NON-NLS-1$
	public static final String PROPERTY_PROGRAMLINKDATA = "programLinkData";  //$NON-NLS-1$
	public static final String PROPERTY_PROGRAMNAME = "programName";  //$NON-NLS-1$
	public static final String PROPERTY_PROMPT = "prompt";  //$NON-NLS-1$
	public static final String PROPERTY_PROTECT = "protect";  //$NON-NLS-1$
	public static final String PROPERTY_PUBLISHHELPER = "publishHelper";  //$NON-NLS-1$
	public static final String PROPERTY_PUBLISHMESSAGEHELPER = "publishMessageHelper";  //$NON-NLS-1$
	public static final String PROPERTY_PUTOPTIONSRECORD = "putOptionsRecord";  //$NON-NLS-1$
	public static final String PROPERTY_QUEUEDESCRIPTORRECORD = "queueDescriptorRecord";  //$NON-NLS-1$
	public static final String PROPERTY_QUEUENAME = "queueName";  //$NON-NLS-1$
	public static final String PROPERTY_RECORDNUMITEM = "recordNumItem";  //$NON-NLS-1$
	public static final String PROPERTY_REDEFINES = "redefines";  //$NON-NLS-1$
	public static final String PROPERTY_RELATIONSHIP = "relationship";  //$NON-NLS-1$
	public static final String PROPERTY_REPORTDESIGNFILE = "reportDesignFile";  //$NON-NLS-1$
	public static final String PROPERTY_REPORTDESTINATIONFILE = "reportDestinationFile";  //$NON-NLS-1$
	public static final String PROPERTY_REPORTEXPORTFILE = "reportExportFile";  //$NON-NLS-1$
	public static final String PROPERTY_REPORTDATA = "reportData";  //$NON-NLS-1$
	public static final String PROPERTY_REQUIRED = "required";  //$NON-NLS-1$
	public static final String PROPERTY_RESIDENT = "resident";  //$NON-NLS-1$
	public static final String PROPERTY_RETRIEVEVALIDSTATEHELPER = "retrieveValidStateHelper";  //$NON-NLS-1$
	public static final String PROPERTY_RETRIEVEVIEWHELPER = "retrieveViewHelper";  //$NON-NLS-1$
	public static final String PROPERTY_RIGHTMARGIN = "rightMargin";  //$NON-NLS-1$
	public static final String PROPERTY_RUNVALIDATORFROMPROGRAM = "runValidatorFromProgram";  //$NON-NLS-1$
	public static final String PROPERTY_SCOPE = "scope";  //$NON-NLS-1$
	public static final String PROPERTY_SCREENFLOATINGAREA = "screenFloatingArea";  //$NON-NLS-1$
	public static final String PROPERTY_SCREENFLOATINGAREAS = "screenFloatingAreas";  //$NON-NLS-1$
	public static final String PROPERTY_SCREENSIZE = "screenSize";  //$NON-NLS-1$
	public static final String PROPERTY_SCREENSIZES = "screenSizes";  //$NON-NLS-1$
	public static final String PROPERTY_SECONDARYINDEX = "secondaryIndex";  //$NON-NLS-1$
	public static final String PROPERTY_SECONDARYINDEXITEM = "secondaryIndexItem";  //$NON-NLS-1$
	public static final String PROPERTY_SEGMENTED = "segmented";  //$NON-NLS-1$
	public static final String PROPERTY_SEGMENTNAME = "segmentName";  //$NON-NLS-1$
	public static final String PROPERTY_SEGMENTRECORD = "segmentRecord";  //$NON-NLS-1$
	public static final String PROPERTY_SEGMENTS = "segments";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTEDINDEXITEM = "selectedIndexItem";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTFROMLISTITEM = "selectFromListItem";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTEDROWITEM = "selectedRowItem";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTEDVALUEITEM = "selectedValueItem";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTIONLIST = "selectionList";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTTYPE = "selectType";  //$NON-NLS-1$
	public static final String PROPERTY_SERVICENAME = "serviceName";  //$NON-NLS-1$
	public static final String PROPERTY_SERVICEPACKAGE = "servicePackage";  //$NON-NLS-1$
	public static final String PROPERTY_SERVICEPROPERTY = "serviceProperty"; //$NON-NLS-1$
	public static final String PROPERTY_SERVICEALIAS = "serviceAlias";  //$NON-NLS-1$
	public static final String PROPERTY_SETINITIAL = "setInitial";  //$NON-NLS-1$
	public static final String PROPERTY_SHARED = "shared";  //$NON-NLS-1$
	public static final String PROPERTY_SHOWBRACKETS = "showBrackets";  //$NON-NLS-1$
	public static final String PROPERTY_SIGN = "sign";  //$NON-NLS-1$
	public static final String PROPERTY_SOSITAKEPOSITION = "SOSITakePosition";  //$NON-NLS-1$
	public static final String PROPERTY_SPACESBETWEENCOLUMNS = "spacesBetweenColumns";  //$NON-NLS-1$
	public static final String PROPERTY_SQLDATACODE = "sqlDataCode";  //$NON-NLS-1$
	public static final String PROPERTY_SQLDATASOURCE = "sqldatasource";  //$NON-NLS-1$
	public static final String PROPERTY_SQLSTATEMENT = "sqlStatement";  //$NON-NLS-1$
	public static final String PROPERTY_SQLVARIABLELEN = "sqlVariableLen";  //$NON-NLS-1$
	public static final String PROPERTY_STYLE = "style";  //$NON-NLS-1$
	public static final String PROPERTY_SYMMETRICSWAPPING = "symmetricSwapping";  //$NON-NLS-1$
	public static final String PROPERTY_TABLE= "Table";  //$NON-NLS-1$
	public static final String PROPERTY_TABLENAMEVARIABLES = "tableNameVariables";  //$NON-NLS-1$
	public static final String PROPERTY_TABLENAMES = "tableNames";  //$NON-NLS-1$
	public static final String PROPERTY_TARGETS = "targets";  //$NON-NLS-1$
	public static final String PROPERTY_TARGETTYPES = "targetTypes";  //$NON-NLS-1$
	public static final String PROPERTY_TCPIPLOCATION = "tcpipLocation";  //$NON-NLS-1$
	public static final String PROPERTY_TEXT = "text";  //$NON-NLS-1$
	public static final String PROPERTY_TEXTQUALIFIER = "textQualifier";  //$NON-NLS-1$
	public static final String PROPERTY_THROWNRFEOFEXCEPTIONS = "throwNrfEofExceptions";  //$NON-NLS-1$
	public static final String PROPERTY_THROWSEXCEPTIONS = "throwsExceptions";  //$NON-NLS-1$
	public static final String PROPERTY_TIMEFORMAT = "timeFormat";  //$NON-NLS-1$
	public static final String PROPERTY_TIMESTAMPFORMAT = "timeStampFormat";  //$NON-NLS-1$
	public static final String PROPERTY_TITLE = "title";  //$NON-NLS-1$
	public static final String PROPERTY_THEME = "theme";  //$NON-NLS-1$
	public static final String PROPERTY_TOPMARGIN = "topMargin";  //$NON-NLS-1$
	public static final String PROPERTY_TYPEAHEADFUNCTION = "typeAheadFunction";  //$NON-NLS-1$
	public static final String PROPERTY_TYPEAHEAD = "typeAhead";  //$NON-NLS-1$
	public static final String PROPERTY_TYPECHKMSGKEY = "typeChkMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_UIRECORDNAME = "uiRecordName";  //$NON-NLS-1$
	public static final String PROPERTY_UITYPE = "uiType";  //$NON-NLS-1$
	public static final String PROPERTY_UNLOADONEXIT = "unloadOnExit";  //$NON-NLS-1$
	public static final String PROPERTY_UPPERCASE = "upperCase";  //$NON-NLS-1$
	public static final String PROPERTY_UPDATEABLE = "updateable";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATIONBYPASSFUNCTIONS = "validationBypassFunctions";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATIONBYPASSKEYS = "validationBypassKeys";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATIONCLASS = "validationClass";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATIONORDER = "validationOrder";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATORDATATABLE = "validatorDataTable";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATORDATATABLEMSGKEY = "validatorDataTableMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATORFUNCTION = "validatorFunction";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATORFUNCTIONMSGKEY = "validatorFunctionMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDVALUES = "validValues";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDVALUESMSGKEY = "validValuesMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_VALUE = "value";  //$NON-NLS-1$
	public static final String PROPERTY_VALUEITEM = "valueItem";  //$NON-NLS-1$
	public static final String PROPERTY_VALUEREF = "valueRef";  //$NON-NLS-1$
	public static final String PROPERTY_VERIFY = "verify";  //$NON-NLS-1$
	public static final String PROPERTY_VIEW = "view";  //$NON-NLS-1$
	public static final String PROPERTY_VIEWROOTVAR = "viewRootVar";  //$NON-NLS-1$
	public static final String PROPERTY_RESTBINDING = "restBinding";  //$NON-NLS-1$
	public static final String PROPERTY_WEBBINDING = "webBinding";  //$NON-NLS-1$
	public static final String PROPERTY_WHITESPACE = "whitespace";  //$NON-NLS-1$	
	public static final String PROPERTY_WSDLFILE = "wsdlFile";  //$NON-NLS-1$
	public static final String PROPERTY_WSDLPORT = "wsdlPort";  //$NON-NLS-1$
	public static final String PROPERTY_WSDLSERVICE = "wsdlService";  //$NON-NLS-1$
	public static final String PROPERTY_XML = "xml";  //$NON-NLS-1$
	public static final String PROPERTY_ZEROFORMAT = "zeroFormat";  //$NON-NLS-1$
	// END Generated words
	
	public static final String PROPERTY_BASICRECORD = "BasicRecord";
	public static final String PROPERTY_INDEXEDRECORD = "IndexedRecord";
	public static final String PROPERTY_MQRECORD = "MQRecord";
	public static final String PROPERTY_RELATIVERECORD = "RelativeRecord";
	public static final String PROPERTY_SERIALRECORD = "SerialRecord";
	public static final String PROPERTY_SQLRECORD = "SQLRecord";
	public static final String PROPERTY_EXCEPTION = "Exception";
	public static final String PROPERTY_CSVRECORD = "CSVRecord";

	        
	public static final String PROPERTY_BASICTABLE = "BasicTable";
	public static final String PROPERTY_MATCHINVALIDTABLE = "MatchInvalidTable";
	public static final String PROPERTY_MATCHVALIDTABLE = "MatchValidTable";
	public static final String PROPERTY_MSGTABLE = "MsgTable";
	public static final String PROPERTY_RANGECHKTABLE = "RangeChkTable";
	                
	public static final String PROPERTY_PRINTFORM = "PrintForm";
	public static final String PROPERTY_TEXTFORM = "TextForm";

	public static final String PROPERTY_EGLPROPERTY = "eglProperty";  //$NON-NLS-1$
	public static final String PROPERTY_GETMETHOD = "getMethod";
	public static final String PROPERTY_SETMETHOD = "setMethod";
	public static final String PROPERTY_RUIWIDGET = "ruiWidget";
	public static final String PROPERTY_RUIHANDLER = "ruiHandler";
	public static final String PROPERTY_PROPERTIESFILE = "propertiesFile";
	
	public static final String PROPERTY_URITEMPLATE = "uriTemplate";
	public static final String PROPERTY_REQUESTFORMAT = "requestFormat";
	public static final String PROPERTY_RESPONSEFORMAT = "responseFormat";
	public static final String PROPERTY_DELETEREST = "deleteRest";
	public static final String PROPERTY_GETREST = "getRest";
	public static final String PROPERTY_POSTREST = "postRest";
	public static final String PROPERTY_PUTREST = "putRest";
	

	public static final String PROPERTY_BASICPROGRAM = "BasicProgram";
	public static final String PROPERTY_TEXTUIPROGRAM = "TextUIProgram";
	public static final String PROPERTY_VGWEBTRANSACTION = "VGWebTransaction";
	public static final String PROPERTY_UIPROGRAM = "UIProgram";
	        
	public static final String PROPERTY_BASICLIBRARY = "BasicLibrary";
	public static final String PROPERTY_NATIVELIBRARY = "NativeLibrary";
	public static final String PROPERTY_NATIVETYPE = "NativeType";
	        
	public static final String PROPERTY_JASPERREPORT = "JasperReport";
	public static final String PROPERTY_BIRTHANDLER = "BirtHandler";
	public static final String PROPERTY_JSFHANDLER = "JSFHandler";
	public static final String PROPERTY_BASICHANDLER = "BasicHandler";
	
	public static final String PROPERTY_NOREFLECT = "NoReflect";
	public static final String[] PACKAGE_EGL_LANG_REFLECT = new String[] {"egl", "lang", "reflect"};

//////////////////
//	 The following block of constants have not been generated.  
//	 They have been copied from DataItem in the old Generation Base Framework plugin.
//	 If a system word is added above, a constant needs to be added to the list below.
//////////////////	  
		
	// string representations of the primitive types
	public static String EGL_REPORTS_JASPER_EXPORTFORMAT_STRING = "egl.reports.jasper.EXPORTFORMAT";
	public static String EGL_REPORTS_JASPER_DATASOURCE_STRING = "egl.reports.jasper.DATASOURCE";
	public static String EGL_REPORTS_JASPER_REPORT_STRING = "egl.reports.jasper.REPORT";
	public static String EGL_REPORTS_JASPER_DATASOURCE = "DATASOURCE";
	public static String EGL_REPORTS_REPORT = "Report";
	public static String EGL_REPORTS_REPORTDATA = "ReportData";
	
	public static String EGL_CONSOLE_UI_COLORKIND_STRING = "egl.console.ui.COLORKIND";
	public static String EGL_CONSOLE_UI_PFKEYKIND_STRING = "egl.console.ui.PFKEYKIND";
	public static String EGL_CONSOLE_UI_BOOLEAN_STRING = "egl.console.ui.BOOLEAN";
	public static String EGL_CONSOLE_UI_CONSOLEFORM_STRING = "egl.console.ui.CONSOLEFORM";
	public static String EGL_CONSOLE_UI_CONSOLEFIELD_STRING = "egl.console.ui.CONSOLEFIELD";
	public static String EGL_CONSOLE_UI_WINDOW_STRING = "egl.console.ui.WINDOW";
	public static String EGL_CONSOLE_UI_PRESENTATIONATTRIBUTES_STRING = "egl.console.ui.PRESENTATIONATTRIBUTES";
	public static String EGL_CONSOLE_UI_CONSOLEFIELD = "ConsoleField";
	public static String EGL_CONSOLE_UI_MENU = "Menu";
	public static String EGL_CONSOLE_UI_MENUITEM = "MenuItem";
	public static String EGL_CONSOLE_UI_PRESENTATIONATTRIBUTES = "PresentationAttributes";
	public static String EGL_CONSOLE_UI_PROMPT = "Prompt";
	public static String EGL_CONSOLE_UI_WINDOW = "Window";
	public static String EGL_CONSOLE_UI_WINDOWATTRIBUTEKIND_STRING = "egl.console.ui.WINDOWATTRIBUTEKIND";
	
	public static String BIN_STRING = "BIN"; //$NON-NLS-1$
	public static String BIN9_2_STRING = "BIN9_2"; //$NON-NLS-1$
	public static String CHAR_STRING = "CHAR"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR1_STRING = "CHAR1"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR2_STRING = "CHAR2"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR4_STRING = "CHAR4"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR8_STRING = "CHAR8"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR18_STRING = "CHAR18"; //$NON-NLS-1$			// Was CHA_STRING
	public static String DBCHAR_STRING = "DBCHAR"; //$NON-NLS-1$		// Was DBCS_STRING
	public static String HEX_STRING = "HEX"; //$NON-NLS-1$	
	public static String MBCHAR_STRING = "MBCHAR"; //$NON-NLS-1$		// WAS MIX_STRING
	public static String NUM_STRING = "NUM"; //$NON-NLS-1$
	public static String NUMC_STRING = "NUMC"; //$NON-NLS-1$			// Deprecated
	public static String PACF_STRING = "PACF"; //$NON-NLS-1$			// Deprecated
	public static String UNICODE_STRING = "UNICODE"; //$NON-NLS-1$
	public static String SMALLINT_STRING = "SMALLINT"; //$NON-NLS-1$
	public static String INT_STRING = "INT"; //$NON-NLS-1$
	public static String BIGINT_STRING = "BIGINT"; //$NON-NLS-1$
	public static String FLOAT_STRING = "FLOAT"; //v6.0		
	public static String SMALLFLOAT_STRING = "SMALLFLOAT"; //v6.0			
	public static String MONEY_STRING = "MONEY"; //v6.0	
	public static String DATE_STRING = "DATE"; //v6.0
	public static String TIME_STRING = "TIME"; //v6.0
	public static String TIMESTAMP_STRING = "TIMESTAMP"; //v6.0
	public static String TIMESTAMP_F6_STRING = "TIMESTAMP_F6"; //v6.0
	public static String INTERVAL_STRING = "INTERVAL"; //v6.0
	public static String CLOB_STRING = "CLOB"; //v6.0
	public static String BLOB_STRING = "BLOB"; //v6.0
	public static String NUMBER_STRING = "NUMBER"; //$NON-NLS-1$	
	public static String DECIMAL_STRING = "DECIMAL"; //$NON-NLS-1$
	public static String STRING_STRING = "STRING"; //$NON-NLS-1$
	public static String BOOLEAN_STRING = "BOOLEAN"; //$NON-NLS-1$
	public static String ANY_STRING = "ANY";
	public static String REPORT_DATA_STRING = "REPORTDATA";
	public static String MENU_ITEM_STRING = "MENUITEM";
	
	
	public static String ARRAY_OR_TABLE = "ARRAYORTABLE"; //$NON-NLS-1$
	public static String DYNAMIC_ARRAY = "DYNAMICARRAY"; //$NON-NLS-1$
	public static String DICTIONARY_STRING = "DICTIONARY"; //$NON-NLS-1$
	public static String ARRAYDICTIONARY_STRING = "ARRAYDICTIONARY"; //$NON-NLS-1$
	
	public static String MIXED_ANY_STRING = "any"; //$NON-NLS-1$
	public static String MIXED_ARRAYDICTIONARY_STRING = "arrayDictionary"; //$NON-NLS-1$
	public static String MIXED_BLOB_STRING = "blob";  //$NON-NLS-1$
	public static String MIXED_CLOB_STRING = "clob";  //$NON-NLS-1$
	public static String MIXED_CONSOLEFIELD_STRING = "consoleField";  //$NON-NLS-1$
	public static String MIXED_DICTIONARY_STRING = "dictionary"; //$NON-NLS-1$
	
	public static int BEGIN_LEVEL = 5;	

	//type
	public static String TYPE = "type"; //$NON-NLS-1$

	//Program subtypes
	public static String PROGRAM_SUBTYPE_BASIC = "BasicProgram"; //$NON-NLS-1$
	public static String PROGRAM_SUBTYPE_TEXT_UI = "TextUIProgram"; //$NON-NLS-1$
	public static String PROGRAM_SUBTYPE_VG_WEB_TRANSACTION = "VGWebTransaction"; //$NON-NLS-1$

	//Record subtypes
	public static String RECORD_SUBTYPE_BASIC = "BasicRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_INDEXED = "IndexedRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_MQ = "MQRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_RELATIVE = "RelativeRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_SERIAL = "SerialRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_SQl = "SQLRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_CONSOLE_FORM = "ConsoleForm"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_VGUI = "VGUIRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_CSV = "CSVRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_EXCEPTION = "exception"; //$NON-NLS-1$
	
	//Form subtypes
	public static String FORM_SUBTYPE_TEXT = "TextForm"; //$NON-NLS-1$
	public static String FORM_SUBTYPE_PRINT = "PrintForm"; //$NON-NLS-1$
	
	//Library subtypes
	public static String LIBRARY_SUBTYPE_BASIC = "BasicLibrary"; //$NON-NLS-1$
	public static String LIBRARY_SUBTYPE_NATIVE = "NativeLibrary"; //$NON-NLS-1$
	
	//Handler subtypes
	public static String HANDLER_SUBTYPE_JASPER = "JasperReport"; //$NON-NLS-1$
	public static String HANDLER_SUBTYPE_JSF = "JSFHandler"; //$NON-NLS-1$
	
	//DataTable subtypes
	public static String DATATABLE_SUBTYPE_BASIC = "BasicTable"; //$NON-NLS-1$
	public static String DATATABLE_SUBTYPE_MATCHINVALID = "MatchInvalidTable"; //$NON-NLS-1$
	public static String DATATABLE_SUBTYPE_MATCHVALID = "MatchvalidTable"; //$NON-NLS-1$
	public static String DATATABLE_SUBTYPE_MSG = "MsgTable"; //$NON-NLS-1$
	public static String DATATABLE_SUBTYPE_RANGECHK = "RangeChkTable"; //$NON-NLS-1$
	
	//ExternalType subtypes
	public static String EXTERNALTYPE_SUBTYPE_JAVAOBJECT = "JavaObject"; //$NON-NLS-1$
	public static String EXTERNALTYPE_SUBTYPE_JAVASCRIPTOBJECT = "JavaScriptObject"; //$NON-NLS-1$
	public static String EXTERNALTYPE_SUBTYPE_HOSTPROGRAM = "HostProgram"; //$NON-NLS-1$
	public static String EXTERNALTYPE_SUBTYPE_NATIVETYPE = "NativeType"; //$NON-NLS-1$
	
	//Interface subtypes
	//TODO - these need to be removed once all references are removed
	public static String INTERFACE_SUBTYPE_BASIC = "BasicInterface"; //$NON-NLS-1$
	public static String INTERFACE_SUBTYPE_JAVAOBJECT = "JavaObject"; //$NON-NLS-1$
	
	//Contant for printer, which is used by generation in the ResourceAssociation file
	public static String PRINTER_STRING = "printer"; //$NON-NLS-1$
//	Contants used when creating markers
	public static String EGL_PART_NAME = "EGPartName"; //$NON-NLS-1$
	public static String EGL_IS_EGLMESSAGE = "EGLisEGLMessage"; //$NON-NLS-1$
	public static String EGL_NUMBER_OF_INSERTS = "EGLNumberOfInserts"; //$NON-NLS-1$
	public static String EGL_INSERT = "EGLInsert"; //$NON-NLS-1$
	public static String EGL_Build_aborted = "EGBuilAborted"; //$NON-NLS-1$
	
	// Constant for adding the original ConstantField object to its literal value when
	// inlining the value into expressions.
	public static String CONSTANT_FIELD = "ConstantField"; //$NON-NLS-1$

	public static String EGL_ANYEXCEPTION = "AnyException"; //$NON-NLS-1$
	
	public static final String LOCATION = "eglLocation"; //$NON-NLS-1$


}
