/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.edt.debug.core.IEGLStackFrame;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class EGLDebugContextListener
implements IDebugContextListener {
    private static final String EGL_DEBUGGER_ACTIVE = "org.eclipse.edt.debug.ui.eglDebuggerActive";
    private static final EGLDebugContextListener INSTANCE = new EGLDebugContextListener();
    private final Set<IWorkbenchPage> activePages = new HashSet<IWorkbenchPage>();

    private EGLDebugContextListener() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public static EGLDebugContextListener getInstance() {
        return INSTANCE;
    }

    public void debugContextChanged(DebugContextEvent event) {
        IWorkbenchPart part;
        if ((event.getFlags() & 1) > 0 && (part = event.getDebugContextProvider().getPart()) != null) {
            IEGLStackFrame frame;
            Object element;
            IStructuredSelection ss;
            IWorkbenchPage page = part.getSite().getPage();
            ISelection selection = event.getContext();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable && (frame = (IEGLStackFrame)((IAdaptable)element).getAdapter(IEGLStackFrame.class)) != null) {
                this.activePages.add(page);
                System.setProperty(EGL_DEBUGGER_ACTIVE, "true");
                return;
            }
            this.activePages.remove(page);
            if (this.activePages.isEmpty()) {
                System.setProperty(EGL_DEBUGGER_ACTIVE, "false");
            }
        }
    }
}

