/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.groupconversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.Address;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.BasicPostal;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.Complete;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.Complex;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.EndUserImpl;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.User;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class GroupConversionValidationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)GroupConversionValidationTest.webArchiveBuilder().withTestClassPackage(GroupConversionValidationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a")})
    public void testGroupConversionIsAppliedOnField() {
        Set constraintViolations = this.getValidator().validate((Object)TestUsers.withInvalidMainAddress(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("mainAddress").property("street1"), ConstraintViolationAssert.pathWith().property("mainAddress").property("zipCode"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a")})
    public void testSeveralGroupConversionsAppliedOnField() {
        User userWithInvalidPreferredShipmentAddress = TestUsers.withInvalidPreferredShipmentAddress();
        Set constraintViolations = this.getValidator().validate((Object)userWithInvalidPreferredShipmentAddress, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("street1"), ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("zipCode"));
        constraintViolations = this.getValidator().validate((Object)userWithInvalidPreferredShipmentAddress, new Class[]{Complex.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("doorCode"));
        constraintViolations = this.getValidator().validate((Object)userWithInvalidPreferredShipmentAddress, new Class[]{Default.class, Complex.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("street1"), ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("zipCode"), ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("doorCode"));
        constraintViolations = this.getValidator().validate((Object)userWithInvalidPreferredShipmentAddress, new Class[]{Complete.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("street1"), ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("zipCode"), ConstraintViolationAssert.pathWith().property("preferredShipmentAddress").property("doorCode"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnProperty() {
        Set constraintViolations = this.getValidator().validate((Object)TestUsers.withInvalidShipmentAddress(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("shipmentAddresses").property("street1", true, null, 0, List.class, 0), ConstraintViolationAssert.pathWith().property("shipmentAddresses").property("zipCode", true, null, 0, List.class, 0));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnMethodReturnValue() throws Exception {
        User user = TestUsers.validUser();
        Method method = User.class.getMethod("retrieveMainAddress", new Class[0]);
        Address returnValue = TestAddresses.withInvalidStreet1();
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)user, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().method("retrieveMainAddress").returnValue().property("street1"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionDefinedInSubClassIsAppliedOnMethodReturnValue() throws Exception {
        EndUserImpl user = TestUsers.validEndUser();
        Method method = EndUserImpl.class.getMethod("retrieveWeekendAddress", new Class[0]);
        Address returnValue = TestAddresses.withInvalidStreet1();
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)user, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().method("retrieveWeekendAddress").returnValue().property("street1"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionDefinedInImplementedClassIsAppliedOnMethodReturnValue() throws Exception {
        EndUserImpl user = TestUsers.validEndUser();
        Method method = EndUserImpl.class.getMethod("retrieveFallbackAddress", new Class[0]);
        Address returnValue = TestAddresses.withInvalidStreet1();
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)user, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().method("retrieveFallbackAddress").returnValue().property("street1"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnMethodParameter() throws Exception {
        User user = TestUsers.validUser();
        Method method = User.class.getMethod("setMainAddress", Address.class);
        Object[] arguments = new Object[]{TestAddresses.withInvalidStreet1()};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)user, method, arguments, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().method("setMainAddress").parameter("mainAddress", 0).property("street1"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnConstructorReturnValue() throws Exception {
        Constructor constructor = User.class.getConstructor(Address.class);
        User createdObject = new User(TestAddresses.withInvalidStreet1());
        Set constraintViolations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).returnValue().property("mainAddress").property("street1"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnConstructorParameter() throws Exception {
        Constructor constructor = User.class.getConstructor(Address.class);
        Object[] arguments = new Object[]{TestAddresses.withInvalidStreet1()};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, arguments, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("mainAddress", 0).property("street1"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="e")
    public void testGroupConversionIsNotExecutedRecursively() {
        Set constraintViolations = this.getValidator().validate((Object)TestUsers.withInvalidOfficeAddress(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("officeAddress").property("street1"), ConstraintViolationAssert.pathWith().property("officeAddress").property("zipCode"));
        constraintViolations = this.getValidator().validate((Object)TestUsers.withInvalidOfficeAddress(), new Class[]{BasicPostal.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("officeAddress").property("doorCode"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="h")
    public void testGroupConversionWithSequenceAsTo() {
        User user = TestUsers.validUser();
        Set constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        user.getWeekendAddress().setDoorCode("ABC");
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("weekendAddress").property("doorCode"));
        user.getWeekendAddress().setStreet1(null);
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("weekendAddress").property("street1"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="b")
    public void testGroupIsPassedAsIsToNestedElementWithoutConversion() {
        Set constraintViolations = this.getValidator().validate((Object)new FooHolder(), new Class[0]);
        Assert.assertTrue((boolean)constraintViolations.isEmpty(), (String)"No violations expected for default group");
        constraintViolations = this.getValidator().validate((Object)new FooHolder(), new Class[]{Complex.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("foo").property("bar"));
    }

    private static class Foo {
        @NotNull(groups={Complex.class})
        private String bar;

        private Foo() {
        }
    }

    private static class FooHolder {
        @Valid
        private final Foo foo = new Foo();

        private FooHolder() {
        }
    }

    private static class TestAddresses {
        private TestAddresses() {
        }

        public static Address validAddress() {
            return new Address("Main Street", "c/o Hitchcock", "123", "AB");
        }

        public static Address invalidAddress() {
            return new Address(null, null, "12", "ABC");
        }

        public static Address withInvalidStreet1() {
            Address address = TestAddresses.validAddress();
            address.setStreet1(null);
            return address;
        }
    }

    private static class TestUsers {
        private TestUsers() {
        }

        public static User validUser() {
            return new User(TestAddresses.validAddress(), Arrays.asList(TestAddresses.validAddress()), TestAddresses.validAddress(), TestAddresses.validAddress(), TestAddresses.validAddress());
        }

        public static EndUserImpl validEndUser() {
            return new EndUserImpl(TestAddresses.validAddress(), Arrays.asList(TestAddresses.validAddress()), TestAddresses.validAddress(), TestAddresses.validAddress(), TestAddresses.validAddress());
        }

        public static User withInvalidMainAddress() {
            User user = TestUsers.validUser();
            user.setMainAddress(TestAddresses.invalidAddress());
            return user;
        }

        public static User withInvalidShipmentAddress() {
            User user = TestUsers.validUser();
            user.setShipmentAddresses(Arrays.asList(TestAddresses.invalidAddress()));
            return user;
        }

        public static User withInvalidPreferredShipmentAddress() {
            User user = TestUsers.validUser();
            user.setPreferredShipmentAddress(TestAddresses.invalidAddress());
            return user;
        }

        public static User withInvalidOfficeAddress() {
            User user = TestUsers.validUser();
            user.setOfficeAddress(TestAddresses.invalidAddress());
            return user;
        }
    }
}

