/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.TreeNode;
import com.sun.webui.jsf.util.CookieUtils;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.MethodBinding;
import jakarta.faces.el.ValueBinding;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.FacesListener;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.event.ValueChangeListener;
import jakarta.faces.validator.Validator;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Tree
extends TreeNode
implements EditableValueHolder {
    private static final long serialVersionUID = -3186310519238174661L;
    public static final String JAVA_SCRIPT_THEME_KEY = "tree";
    public static final String SELECTED_SUFFIX = "_select";
    public static final String COOKIE_SUFFIX = "-hi";
    public static final String COOKIE_SUFFIX_EXPAND = "-expand";
    public static final String TREE_CONTENT_FACET_NAME = "content";
    public static final String TREE_IMAGE_FACET_NAME = "image";
    private Converter converter = null;
    private List<Validator> validators = null;
    private MethodBinding validatorBinding = null;
    private Object submittedValue = null;
    private boolean valid = true;
    private boolean localValueSet;
    private MethodBinding valueChangeMethod = null;
    private Object value = null;
    private boolean clientSide = false;
    private boolean clientSideSet = false;
    private boolean expandOnSelect = false;
    private boolean expandOnSelectSet = false;
    private boolean immediate = false;
    private boolean immediateSet = false;
    private boolean required = false;
    private boolean requiredSet = false;
    private String style = null;
    private String styleClass = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public Tree() {
        this.setRendererType("com.sun.webui.jsf.Tree");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.Tree";
    }

    @Override
    public void setId(String id) {
        super.setId(id);
    }

    @Override
    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    @Override
    public String getTarget() {
        return super.getTarget();
    }

    @Override
    public String getUrl() {
        return super.getUrl();
    }

    @Override
    public String getImageURL() {
        return super.getImageURL();
    }

    @Override
    public MethodExpression getActionListenerExpression() {
        return super.getActionListenerExpression();
    }

    @Override
    public MethodExpression getActionExpression() {
        return super.getActionExpression();
    }

    @Override
    public boolean isExpanded() {
        return super.isExpanded();
    }

    public String getSelected() {
        return (String)this.getValue();
    }

    public boolean isClientSide() {
        if (this.clientSideSet) {
            return this.clientSide;
        }
        ValueExpression vb = this.getValueExpression("clientSide");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setClientSide(boolean newClientSide) {
        this.clientSide = newClientSide;
        this.clientSideSet = true;
    }

    public boolean isExpandOnSelect() {
        if (this.expandOnSelectSet) {
            return this.expandOnSelect;
        }
        ValueExpression vb = this.getValueExpression("expandOnSelect");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setExpandOnSelect(boolean newExpandOnSelect) {
        this.expandOnSelect = newExpandOnSelect;
        this.expandOnSelectSet = true;
    }

    public boolean isImmediate() {
        if (this.immediateSet) {
            return this.immediate;
        }
        ValueExpression vb = this.getValueExpression("immediate");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setImmediate(boolean newImmediate) {
        this.immediate = newImmediate;
        this.immediateSet = true;
    }

    public boolean isRequired() {
        if (this.requiredSet) {
            return this.required;
        }
        ValueExpression vb = this.getValueExpression("required");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setRequired(boolean newRequired) {
        this.required = newRequired;
        this.requiredSet = true;
    }

    @Override
    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    @Override
    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    @Override
    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    @Override
    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void setSelected(String newSelected) {
        FacesContext context;
        Cookie cookie;
        if (!(newSelected != null && newSelected.length() != 0 || (cookie = CookieUtils.getCookieValue(context = FacesContext.getCurrentInstance(), this.getClientId(context) + COOKIE_SUFFIX)) == null || RenderingUtilities.isPortlet(context))) {
            ExternalContext extCtx = context.getExternalContext();
            HttpServletResponse res = (HttpServletResponse)extCtx.getResponse();
            cookie.setMaxAge(0);
            cookie.setPath("/");
            res.addCookie(cookie);
            this.setValue(null);
        }
        this.setValue(newSelected);
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("selected")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("selected")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter newConverted) {
        this.converter = newConverted;
    }

    public Object getLocalValue() {
        return this.value;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        ValueExpression vb = this.getValueExpression("value");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            return result;
        }
        return null;
    }

    public void setValue(Object newValue) {
        this.value = newValue;
        this.setLocalValueSet(true);
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public void setSubmittedValue(Object newSubmittedValue) {
        this.submittedValue = newSubmittedValue;
    }

    public boolean isLocalValueSet() {
        return this.localValueSet;
    }

    public void setLocalValueSet(boolean newLocalValueSet) {
        this.localValueSet = newLocalValueSet;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean newValid) {
        this.valid = newValid;
    }

    public MethodBinding getValidator() {
        return this.validatorBinding;
    }

    public void setValidator(MethodBinding newValidatorBinding) {
        this.validatorBinding = newValidatorBinding;
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        if (this.validators == null) {
            this.validators = new ArrayList<Validator>();
        }
        this.validators.add(validator);
    }

    public Validator[] getValidators() {
        if (this.validators == null) {
            return new Validator[0];
        }
        return this.validators.toArray(new Validator[this.validators.size()]);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public MethodBinding getValueChangeListener() {
        return this.valueChangeMethod;
    }

    public void setValueChangeListener(MethodBinding newValueChangeMethod) {
        this.valueChangeMethod = newValueChangeMethod;
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void decode(FacesContext context) {
        this.setValid(true);
        super.decode(context);
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding method;
        super.broadcast(event);
        if (event instanceof ValueChangeEvent && (method = this.getValueChangeListener()) != null) {
            FacesContext context = this.getFacesContext();
            method.invoke(context, new Object[]{event});
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException ex) {
            context.renderResponse();
            throw new RuntimeException(ex);
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueBinding vb = this.getValueBinding("value");
        if (vb == null) {
            return;
        }
        try {
            vb.setValue(context, this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
            return;
        }
        catch (EvaluationException ex) {
            String messageStr = ex.getMessage();
            if (messageStr != null) {
                FacesMessage message = new FacesMessage(messageStr);
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), message);
            }
            this.setValid(false);
            if (LogUtil.configEnabled()) {
                LogUtil.config("Unable to update Model!", ex);
            }
            return;
        }
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        if (!this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object val = this.getSubmittedValue();
        if (val == null) {
            return;
        }
        Object newValue = val;
        this.validateValue(context, newValue);
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.isDifferent(previous, newValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previous, newValue));
            }
        }
    }

    protected boolean isDifferent(Object val1, Object val2) {
        if (val1 == val2) {
            return false;
        }
        if (val1 == null) {
            return true;
        }
        return !val1.equals(val2);
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (!this.isValid()) {
            return;
        }
        if (this.isRequired() && (newValue == null || newValue.toString().trim().equals(""))) {
            this.setValid(false);
        }
    }

    public void selectTreeNode(TreeNode treeNode) {
        this.setSelected(treeNode.getId());
    }

    public void selectTreeNode(String id) {
        this.setSelected(id);
    }

    public String getCookieSelectedTreeNode() {
        FacesContext context = FacesContext.getCurrentInstance();
        Cookie cookie = CookieUtils.getCookieValue(context, this.getClientId(context) + COOKIE_SUFFIX);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public String getCookieExpandNode() {
        FacesContext context = FacesContext.getCurrentInstance();
        Cookie cookie = CookieUtils.getCookieValue(context, this.getClientId(context) + COOKIE_SUFFIX_EXPAND);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.clientSide ? Boolean.TRUE : Boolean.FALSE, this.clientSideSet ? Boolean.TRUE : Boolean.FALSE, this.expandOnSelect ? Boolean.TRUE : Boolean.FALSE, this.expandOnSelectSet ? Boolean.TRUE : Boolean.FALSE, this.immediate ? Boolean.TRUE : Boolean.FALSE, this.immediateSet ? Boolean.TRUE : Boolean.FALSE, this.required ? Boolean.TRUE : Boolean.FALSE, this.requiredSet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE, Tree.saveAttachedState((FacesContext)context, (Object)this.converter), this.value, this.localValueSet ? Boolean.TRUE : Boolean.FALSE, this.valid ? Boolean.TRUE : Boolean.FALSE, Tree.saveAttachedState((FacesContext)context, this.validators), Tree.saveAttachedState((FacesContext)context, (Object)this.validatorBinding), Tree.saveAttachedState((FacesContext)context, (Object)this.valueChangeMethod)};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.clientSide = (Boolean)values[1];
        this.clientSideSet = (Boolean)values[2];
        this.expandOnSelect = (Boolean)values[3];
        this.expandOnSelectSet = (Boolean)values[4];
        this.immediate = (Boolean)values[5];
        this.immediateSet = (Boolean)values[6];
        this.required = (Boolean)values[7];
        this.requiredSet = (Boolean)values[8];
        this.style = (String)values[9];
        this.styleClass = (String)values[10];
        this.visible = (Boolean)values[11];
        this.visibleSet = (Boolean)values[12];
        this.converter = (Converter)Tree.restoreAttachedState((FacesContext)context, (Object)values[13]);
        this.value = values[14];
        this.localValueSet = (Boolean)values[15];
        this.valid = (Boolean)values[16];
        List restoredValidators = (List)Tree.restoreAttachedState((FacesContext)context, (Object)values[17]);
        if (restoredValidators != null) {
            if (null != this.validators) {
                Iterator iter = restoredValidators.iterator();
                while (iter.hasNext()) {
                    this.validators.add((Validator)iter.next());
                }
            } else {
                this.validators = restoredValidators;
            }
        }
        this.validatorBinding = (MethodBinding)Tree.restoreAttachedState((FacesContext)context, (Object)values[18]);
        this.valueChangeMethod = (MethodBinding)Tree.restoreAttachedState((FacesContext)context, (Object)values[19]);
    }

    public void resetValue() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

