/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class FunctionLibrary
implements TagLibrary {
    public static final String Namespace = "http://java.sun.com/jsp/jstl/functions";
    public static final String XMLNSNamespace = "http://xmlns.jcp.org/jsp/jstl/functions";
    private String _namespace;
    private Map<String, Method> functions;

    public FunctionLibrary(Class<?> functionsClass, String namespace) {
        Util.notNull("functionsClass", functionsClass);
        Util.notNull("namespace", namespace);
        this._namespace = namespace;
        try {
            Method[] methods = functionsClass.getMethods();
            this.functions = new HashMap<String, Method>(methods.length, 1.0f);
            for (Method method : methods) {
                if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
                this.functions.put(method.getName(), method);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean containsNamespace(String ns, Tag t) {
        return this._namespace.equals(ns);
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        return false;
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        return null;
    }

    @Override
    public boolean containsFunction(String ns, String name) {
        return this._namespace.equals(ns) && this.functions.containsKey(name);
    }

    @Override
    public Method createFunction(String ns, String name) {
        if (this._namespace.equals(ns)) {
            return this.functions.get(name);
        }
        return null;
    }
}

