/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class ResourceHandlers {
    public static void getResourceRealStatus(HandlerContext handlerCtx) {
        List rows = (List)handlerCtx.getInputValue("rows");
        HashMap<CallSite, String> targetsMap = new HashMap<CallSite, String>();
        for (Map oneRow : rows) {
            try {
                String name = (String)oneRow.get("name");
                String encodedName = URLEncoder.encode(name, "UTF-8");
                List targets = DeployUtil.getApplicationTarget(name, "resource-ref");
                if (targets.size() == 0) continue;
                String enabledStr = DeployUtil.getTargetEnableInfo(encodedName, false, false);
                ArrayList<CallSite> targetUrls = new ArrayList<CallSite>();
                for (String target : targets) {
                    if (TargetUtil.isCluster(target)) {
                        targetsMap.put((CallSite)((Object)(String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/clusters/cluster/" + target)), target);
                        targetUrls.add((CallSite)((Object)(String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/clusters/cluster/" + target)));
                        continue;
                    }
                    targetsMap.put((CallSite)((Object)(String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/servers/server/" + target)), target);
                    targetUrls.add((CallSite)((Object)(String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/servers/server/" + target)));
                }
                oneRow.put("targetUrls", targetUrls);
                oneRow.put("targetsMap", targetsMap);
                oneRow.put("enabled", enabledStr);
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
            }
        }
        handlerCtx.setOutputValue("result", (Object)rows);
    }

    public static void getConfigPropsInfo(HandlerContext handlerCtx) {
        Map extraProps = (Map)handlerCtx.getInputValue("extraProps");
        String key = (String)handlerCtx.getInputValue("key");
        String confidentialKey = (String)handlerCtx.getInputValue("confidentialKey");
        Boolean hasConfidential = true;
        Map allProps = (Map)extraProps.get(key);
        List confidentialPropsNames = (List)extraProps.get(confidentialKey);
        if (confidentialPropsNames == null || confidentialPropsNames.isEmpty()) {
            hasConfidential = false;
        }
        ArrayList result = new ArrayList();
        for (Map.Entry e : allProps.entrySet()) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            String name = (String)e.getKey();
            String value = e.getValue() == null ? "" : (String)e.getValue();
            oneRow.put("selected", false);
            oneRow.put("name", name);
            if (hasConfidential.booleanValue() && confidentialPropsNames.contains(name)) {
                oneRow.put("value", "");
                oneRow.put("confValue", value);
                oneRow.put("confValue2", value);
                oneRow.put("isConfidential", true);
            } else {
                oneRow.put("value", value);
                oneRow.put("confValue", "");
                oneRow.put("confValue2", "");
                oneRow.put("isConfidential", false);
            }
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("hasConfidentialProps", (Object)hasConfidential);
    }

    public static void combineProperties(HandlerContext handlerCtx) {
        List tableList = (List)handlerCtx.getInputValue("tableList");
        ArrayList combined = new ArrayList();
        for (Map oneRow : tableList) {
            HashMap<String, String> newRow = new HashMap<String, String>();
            boolean isC = (Boolean)oneRow.get("isConfidential");
            String name = (String)oneRow.get("name");
            newRow.put("name", name);
            if (GuiUtil.isEmpty(name)) continue;
            if (isC) {
                String v1 = (String)oneRow.get("confValue");
                String v2 = (String)oneRow.get("confValue2");
                if (v1 == null) {
                    if (v2 == null) continue;
                    GuiUtil.handleError(handlerCtx, "Confidential property '" + name + "' does not match.");
                    return;
                }
                if (!v1.equals(v2)) {
                    GuiUtil.handleError(handlerCtx, "Confidential property '" + name + "' does not match.");
                    return;
                }
                newRow.put("value", v1);
            } else {
                newRow.put("value", (String)oneRow.get("value"));
            }
            combined.add(newRow);
        }
        handlerCtx.setOutputValue("combined", combined);
    }

    public static void buildConfidentialPropsTable(HandlerContext handlerCtx) {
        List confidentialList = (List)handlerCtx.getInputValue("confidentialList");
        List propsMaps = (List)handlerCtx.getInputValue("propsMaps");
        Boolean hasConfidential = true;
        if (confidentialList == null || confidentialList.isEmpty()) {
            hasConfidential = false;
        }
        Boolean hasConf = false;
        ArrayList result = new ArrayList();
        for (Map oneProp : propsMaps) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            String name = (String)oneProp.get("name");
            String value = (String)oneProp.get("value");
            if (value == null) {
                value = "";
            }
            oneRow.put("selected", false);
            oneRow.put("name", name);
            if (hasConfidential.booleanValue() && confidentialList.contains(name)) {
                oneRow.put("value", "");
                oneRow.put("confValue", value);
                oneRow.put("confValue2", value);
                oneRow.put("isConfidential", true);
                hasConf = true;
            } else {
                oneRow.put("value", value);
                oneRow.put("confValue", "");
                oneRow.put("confValue2", "");
                oneRow.put("isConfidential", false);
            }
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("hasConfidentialProps", (Object)hasConf);
    }

    public static void getLogicalJndiName(HandlerContext handlerCtx) {
        List logicalMapList = (List)handlerCtx.getInputValue("logicalMapList");
        List listRow = (List)handlerCtx.getInputValue("listRow");
        if (listRow == null || listRow.isEmpty()) {
            handlerCtx.setOutputValue("result", (Object)listRow);
            return;
        }
        try {
            block2: for (Map onerow : listRow) {
                String name = (String)onerow.get("name");
                onerow.put("logicalJndiName", "");
                onerow.put("encodedLogicalJndiName", "");
                for (Map logicalMap : logicalMapList) {
                    if (!name.equals(logicalMap.get("name"))) continue;
                    String lname = (String)logicalMap.get("logical-jndi-name");
                    if (GuiUtil.isEmpty(lname)) continue block2;
                    onerow.put("logicalJndiName", lname);
                    onerow.put("encodedLogicalJndiName", URLEncoder.encode(lname, "UTF-8"));
                    continue block2;
                }
            }
            handlerCtx.setOutputValue("result", (Object)listRow);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }
}

