/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer.types;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.yasson.internal.serializer.types.AbstractDateSerializer;
import org.eclipse.yasson.internal.serializer.types.TypeSerializerBuilder;

class SqlTimestampSerializer
extends AbstractDateSerializer<Timestamp> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone(UTC);

    SqlTimestampSerializer(TypeSerializerBuilder serializerBuilder) {
        super(serializerBuilder);
    }

    @Override
    protected Instant toInstant(Timestamp value) {
        return value.toInstant();
    }

    @Override
    protected String formatDefault(Timestamp value, Locale locale) {
        return DEFAULT_FORMATTER.withLocale(locale).format(this.toInstant(value));
    }
}

