/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.security.auth.login.AppConfigurationEntry;
import org.glassfish.epicyro.config.helper.LogManager;
import org.glassfish.epicyro.config.helper.ModulesManager;
import org.glassfish.epicyro.config.jaas.ExtendedConfigFile;

public class JAASModulesManager
extends ModulesManager {
    private static final String DEFAULT_ENTRY_NAME = "other";
    private static final Class<?>[] PARAMS = new Class[0];
    private static final Object[] ARGS = new Object[0];
    private LogManager logManager;
    private ExtendedConfigFile jaasConfig;
    private final String appContext;
    private ReentrantReadWriteLock instanceReadWriteLock = new ReentrantReadWriteLock();
    private Lock instanceWriteLock = this.instanceReadWriteLock.writeLock();
    private AppConfigurationEntry[] appConfigurationEntry;
    private Constructor<?>[] loginModuleConstructors;

    public JAASModulesManager(LogManager logManager, boolean returnNullContexts, ExtendedConfigFile jaasConfig, Map<String, ?> properties, String appContext) throws AuthException {
        super(returnNullContexts);
        this.logManager = logManager;
        this.jaasConfig = jaasConfig;
        this.appContext = appContext;
        this.initialize();
    }

    @Override
    public Map<String, Object> getInitProperties(int i, Map<String, ?> properties) {
        HashMap<String, Object> initProperties = new HashMap<String, Object>();
        if (this.appConfigurationEntry[i] != null) {
            Map<String, ?> options;
            if (properties != null && !properties.isEmpty()) {
                initProperties.putAll(properties);
            }
            if ((options = this.appConfigurationEntry[i].getOptions()) != null && !options.isEmpty()) {
                initProperties.putAll(options);
            }
        }
        return initProperties;
    }

    @Override
    public final void refresh() {
        this.jaasConfig.refresh();
        this.initialize();
    }

    @Override
    public <M> boolean hasModules(M[] template, String authContextID) throws AuthException {
        this.loadConstructors(template, authContextID);
        for (Constructor<?> constructor : this.loginModuleConstructors) {
            if (constructor == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public <M> M[] getModules(M[] template, String authContextID) throws AuthException {
        this.loadConstructors(template, authContextID);
        ArrayList moduleInstances = new ArrayList(this.loginModuleConstructors.length);
        for (int moduleNumber = 0; moduleNumber < this.loginModuleConstructors.length; ++moduleNumber) {
            if (this.loginModuleConstructors[moduleNumber] == null) {
                moduleInstances.add(moduleNumber, null);
                continue;
            }
            final int j = moduleNumber;
            try {
                moduleInstances.add(j, AccessController.doPrivileged(new PrivilegedExceptionAction<M>(){

                    @Override
                    public M run() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        return JAASModulesManager.this.loginModuleConstructors[j].newInstance(ARGS);
                    }
                }));
                continue;
            }
            catch (PrivilegedActionException pae) {
                throw (AuthException)new AuthException().initCause(pae.getCause());
            }
        }
        return moduleInstances.toArray(template);
    }

    @Override
    public boolean shouldStopProcessingModules(AuthStatus[] successValue, int moduleNumber, AuthStatus moduleStatus) {
        if (this.appConfigurationEntry[moduleNumber] != null && this.loginModuleConstructors[moduleNumber] != null) {
            AppConfigurationEntry.LoginModuleControlFlag flag = this.appConfigurationEntry[moduleNumber].getControlFlag();
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(flag)) {
                for (AuthStatus authStatus : successValue) {
                    if (moduleStatus != authStatus) continue;
                    return false;
                }
                return true;
            }
            if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(flag)) {
                for (AuthStatus authStatus : successValue) {
                    if (moduleStatus != authStatus) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public AuthStatus getReturnStatus(AuthStatus[] successValue, AuthStatus defaultFailStatus, AuthStatus[] status, int position) {
        AuthStatus returnStatus = null;
        for (int moduleNumber = 0; moduleNumber <= position; ++moduleNumber) {
            if (this.appConfigurationEntry[moduleNumber] == null || this.loginModuleConstructors[moduleNumber] == null) continue;
            AppConfigurationEntry.LoginModuleControlFlag flag = this.appConfigurationEntry[moduleNumber].getControlFlag();
            if (this.logManager.isLoggable(Level.FINE)) {
                this.logManager.logIfLevel(Level.FINE, null, "getReturnStatus - flag: ", flag.toString());
            }
            if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED || flag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                boolean isSuccessValue = false;
                AuthStatus[] authStatusArray = successValue;
                int n = authStatusArray.length;
                for (int i = 0; i < n; ++i) {
                    AuthStatus authStatus = authStatusArray[i];
                    if (status[moduleNumber] != authStatus) continue;
                    isSuccessValue = true;
                }
                if (isSuccessValue) {
                    if (returnStatus != null) continue;
                    returnStatus = status[moduleNumber];
                    continue;
                }
                if (this.logManager.isLoggable(Level.FINE)) {
                    this.logManager.logIfLevel(Level.FINE, null, "ReturnStatus - REQUIRED or REQUISITE failure: ", status[moduleNumber].toString());
                }
                return status[moduleNumber];
            }
            if (flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                if (!this.shouldStopProcessingModules(successValue, moduleNumber, status[moduleNumber])) continue;
                if (this.logManager.isLoggable(Level.FINE)) {
                    this.logManager.logIfLevel(Level.FINE, null, "ReturnStatus - Sufficient success: ", status[moduleNumber].toString());
                }
                return status[moduleNumber];
            }
            if (flag != AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL || returnStatus != null) continue;
            for (AuthStatus authStatus : successValue) {
                if (status[moduleNumber] != authStatus) continue;
                returnStatus = status[moduleNumber];
            }
        }
        if (returnStatus != null) {
            if (this.logManager.isLoggable(Level.FINE)) {
                this.logManager.logIfLevel(Level.FINE, null, "ReturnStatus - result: ", returnStatus.toString());
            }
            return returnStatus;
        }
        if (this.logManager.isLoggable(Level.FINE)) {
            this.logManager.logIfLevel(Level.FINE, null, "ReturnStatus - Default faiure status: ", defaultFailStatus.toString());
        }
        return defaultFailStatus;
    }

    private void initialize() {
        boolean found = false;
        boolean foundDefault = false;
        this.instanceWriteLock.lock();
        try {
            this.appConfigurationEntry = this.jaasConfig.getAppConfigurationEntry(this.appContext);
            if (this.appConfigurationEntry == null) {
                this.appConfigurationEntry = this.jaasConfig.getAppConfigurationEntry(DEFAULT_ENTRY_NAME);
                if (this.appConfigurationEntry == null) {
                    this.appConfigurationEntry = new AppConfigurationEntry[0];
                } else {
                    foundDefault = true;
                }
            } else {
                found = true;
            }
            this.loginModuleConstructors = null;
        }
        finally {
            this.instanceWriteLock.unlock();
        }
        if (!found) {
            if (!foundDefault) {
                this.logManager.logIfLevel(Level.INFO, null, "JAASModulesManager no entries matched appContext (", this.appContext, ") or (", DEFAULT_ENTRY_NAME, ")");
            } else {
                this.logManager.logIfLevel(Level.INFO, null, "JAASModulesManager appContext (", this.appContext, ") matched (", DEFAULT_ENTRY_NAME, ")");
            }
        }
    }

    private <M> void loadConstructors(M[] template, String authContextID) throws AuthException {
        if (this.loginModuleConstructors == null) {
            try {
                final Class<?> moduleType = template.getClass().getComponentType();
                this.loginModuleConstructors = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>[]>(){

                    @Override
                    public Constructor<?>[] run() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                        Constructor[] loginModuleCtors = new Constructor[JAASModulesManager.this.appConfigurationEntry.length];
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        for (int i = 0; i < JAASModulesManager.this.appConfigurationEntry.length; ++i) {
                            String loginModuleName = JAASModulesManager.this.appConfigurationEntry[i].getLoginModuleName();
                            try {
                                Class<?> loginModuleClass = Class.forName(loginModuleName, true, loader);
                                if (!moduleType.isAssignableFrom(loginModuleClass)) continue;
                                loginModuleCtors[i] = loginModuleClass.getConstructor(PARAMS);
                                continue;
                            }
                            catch (Throwable t) {
                                JAASModulesManager.this.logManager.logIfLevel(Level.WARNING, null, "skipping unloadable class: ", loginModuleName, " of appCOntext: ", JAASModulesManager.this.appContext);
                            }
                        }
                        return loginModuleCtors;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (AuthException)new AuthException().initCause(pae.getCause());
            }
        }
    }
}

