/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sirius.common.tools.Messages;

public final class ResourceUtil {
    private static final String FILE_SEPARATOR = "/";

    private ResourceUtil() {
    }

    public static IFile createBackupFile(IFile file, IProgressMonitor monitor) throws CoreException {
        IFile backup;
        monitor.beginTask(Messages.ResourceUtil_backupFileTask, 2);
        String timestamp = new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date());
        int lastDotIndex = file.getName().lastIndexOf(46);
        String name = lastDotIndex > 0 ? String.valueOf(file.getName().substring(0, lastDotIndex)) + "-" + timestamp + "." + file.getName().substring(lastDotIndex + ".".length()) + ".old" : String.valueOf(file.getName()) + "-" + timestamp + ".old";
        if (file.getParent().findMember(name, true) == null) {
            backup = file.getParent().getFile((IPath)new Path(FILE_SEPARATOR + name));
        } else {
            int i = 2;
            while (file.getParent().findMember(String.valueOf(name) + i, true) != null) {
                ++i;
            }
            backup = file.getParent().getFile((IPath)new Path(FILE_SEPARATOR + name + i));
        }
        assert (!backup.exists()) : Messages.ResourceUtil_backupFileAlreadyExists;
        file.copy(backup.getFullPath(), 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        file.getParent().refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
        return backup;
    }
}

