/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.tutorial.thermostat.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.efm.tutorial.thermostat.system.Channel;
import org.eclipse.efm.tutorial.thermostat.system.Equipement;
import org.eclipse.efm.tutorial.thermostat.system.Thermostat;
import org.eclipse.efm.tutorial.thermostat.utils.Couple;

public class ThermostatSystem {
    static Channel<Integer> dt = new Channel();
    static Channel<Integer> amount = new Channel();
    static Channel<Integer> error = new Channel();
    static Channel<Integer> sens = new Channel();
    static Channel<Integer> screen = new Channel();
    static Vector<Couple<Integer, Boolean>> inputTrace = new Vector();
    static Thermostat therm = new Thermostat(sens, screen, dt, amount, error);
    static Equipement equip = new Equipement(dt, amount, error);
    static int delay;
    static int t;
    static int Tmin;
    static int Tmax;
    static int HeatingDisplay;
    static int CoolinggDisplay;
    static int StandbyDisplay;
    static Mode mode;
    static FileReader inputTraceFile;
    static String inputTracePath;
    static String logdirName;

    static {
        Tmin = 20;
        Tmax = 25;
        HeatingDisplay = 1;
        CoolinggDisplay = 2;
        StandbyDisplay = 3;
        mode = Mode.STANDBY;
    }

    static void readInputTrace() {
        try {
            String line;
            inputTraceFile = new FileReader(inputTracePath);
            BufferedReader br = new BufferedReader(inputTraceFile);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("TRACE NUMBER")) continue;
                String delims = "=";
                String[] parts = line.split(delims);
                if (parts.length == 2) {
                    inputTrace.add(new Couple<Integer, Boolean>(Integer.parseInt(parts[1].trim()), false));
                    continue;
                }
                String strTMP = parts[0].trim();
                String[] parts1 = strTMP.split("\\(");
                String[] parts2 = parts1[1].split("\\)");
                inputTrace.add(new Couple<Integer, Boolean>(Integer.parseInt(parts2[0]), true));
            }
            br.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Check the formatting of your input file..");
        }
    }

    public static void main(String[] args) {
        block36: {
            if (args.length == 2) {
                FileWriter logwriter;
                block35: {
                    inputTracePath = args[0];
                    logdirName = args[1];
                    ThermostatSystem.readInputTrace();
                    new File(logdirName).mkdir();
                    File logfile = new File(String.valueOf(logdirName) + "/mergeTrace.txt");
                    logwriter = null;
                    try {
                        try {
                            logwriter = new FileWriter(logfile);
                            if (inputTrace.size() == 0) break block35;
                            if (!inputTrace.firstElement().second().booleanValue()) {
                                logwriter.write("delta = " + inputTrace.firstElement().first() + "\n");
                                inputTrace.remove(0);
                            }
                            for (Couple<Integer, Boolean> elemInputTrace : inputTrace) {
                                if (elemInputTrace.second().booleanValue()) {
                                    ThermostatSystem.therm.sens.send(elemInputTrace.first());
                                    logwriter.write("INPUT sens(" + elemInputTrace.first() + ")\n");
                                    continue;
                                }
                                delay = elemInputTrace.first();
                                t = ThermostatSystem.therm.sens.receive();
                                if (t < Tmin && (mode == Mode.HEATING || mode == Mode.STANDBY)) {
                                    mode = Mode.HEATING;
                                    logwriter.write("delta = 1\n");
                                    logwriter.write("OUTPUT screen(1)\n");
                                    if (--delay >= 1) {
                                        logwriter.write("delta = 1\n");
                                        ThermostatSystem.therm.dt.send(Tmin - t);
                                        ThermostatSystem.equip.x = ThermostatSystem.equip.dt.receive();
                                        logwriter.write("OUTPUT dt(" + (Tmin - t) + ")\n");
                                        if (--delay >= 2) {
                                            logwriter.write("delta = 2\n");
                                            delay -= 2;
                                            while (ThermostatSystem.equip.x > 0) {
                                                ThermostatSystem.equip.x -= 4;
                                                amount.send(4);
                                                logwriter.write("OUTPUT equip(4)\n");
                                                if (delay >= 1) {
                                                    logwriter.write("delta = 1\n");
                                                    --delay;
                                                    continue;
                                                }
                                                break;
                                            }
                                        }
                                    }
                                } else if (t > Tmax && (mode == Mode.COOLING || mode == Mode.STANDBY)) {
                                    mode = Mode.COOLING;
                                    logwriter.write("delta = 1\n");
                                    logwriter.write("OUTPUT screen(2)\n");
                                    if (--delay >= 1) {
                                        logwriter.write("delta = 1\n");
                                        ThermostatSystem.therm.dt.send(Tmax - t);
                                        ThermostatSystem.equip.x = ThermostatSystem.equip.dt.receive();
                                        logwriter.write("OUTPUT dt(" + (Tmax - t) + ")\n");
                                        if (--delay >= 2) {
                                            logwriter.write("delta = 2\n");
                                            delay -= 2;
                                            while (ThermostatSystem.equip.x < 0) {
                                                ThermostatSystem.equip.x += 4;
                                                amount.send(-4);
                                                logwriter.write("OUTPUT equip(-4)\n");
                                                if (delay >= 1) {
                                                    logwriter.write("delta = 1\n");
                                                    --delay;
                                                    continue;
                                                }
                                                break;
                                            }
                                        }
                                    }
                                } else if (t > Tmin && mode == Mode.HEATING || t < Tmax && mode == Mode.COOLING) {
                                    logwriter.write("delta = 1\n");
                                    logwriter.write("dt!0\n");
                                    if (--delay < 2) {
                                        logwriter.write("delta = 1\n");
                                    } else {
                                        logwriter.write("delta = 2\n");
                                        delay -= 2;
                                    }
                                    logwriter.write("OUTPUT equip(0)\n");
                                    mode = Mode.STANDBY;
                                }
                                if (delay > 0) {
                                    logwriter.write("delta = " + delay + "\n");
                                }
                                if (delay > 0) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (logwriter != null) {
                                try {
                                    logwriter.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block36;
                        }
                    }
                    catch (Throwable throwable) {
                        if (logwriter != null) {
                            try {
                                logwriter.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                if (logwriter != null) {
                    try {
                        logwriter.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                System.out.println("Wrong argument number.");
            }
        }
    }

    public static enum Mode {
        COOLING,
        HEATING,
        STANDBY;

    }
}

