/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.ui.views.symbexlauncher;

import org.eclipse.efm.execution.configuration.common.ui.api.AbstractSectionPart;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FormWidgetToolkit
extends FormToolkit
implements IWidgetToolkit {
    public FormWidgetToolkit(Display display) {
        super(display);
    }

    public void setVisibleAndEnabled(Composite aComposite, boolean visible) {
        if (aComposite instanceof ExpandableComposite) {
            ((ExpandableComposite)aComposite).setExpanded(visible);
        } else {
            this.propagateVisibility(aComposite, visible);
        }
        aComposite.setEnabled(visible);
    }

    public void createSectionPart(AbstractSectionPart sectionPart, Composite parent, int style, IToolBarManager toolBarManager) {
        Section section = super.createSection(parent, style);
        GridData gd = new GridData(4, 4, true, false);
        section.setLayoutData((Object)gd);
        String text = sectionPart.getSectionTitle();
        if (text != null) {
            section.setText(text);
        }
        if ((text = sectionPart.getSectionDescription()) != null) {
            section.setDescription(text);
        }
        if (toolBarManager != null) {
            ToolBar toolbar = ((ToolBarManager)toolBarManager).createControl((Composite)section);
            section.setTextClient((Control)toolbar);
        }
        Composite sectionClient = this.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout());
        section.setClient((Control)sectionClient);
        sectionPart.setSection((Composite)section);
        sectionPart.setSectionClient(sectionClient);
    }

    public CTabFolder createTabFolder(Composite parent, int style) {
        CTabFolder tabFolder = new CTabFolder(parent, style);
        super.adapt((Control)tabFolder, true, true);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        tabFolder.setLayoutData((Object)gd);
        FormColors formColors = super.getColors();
        tabFolder.setSelectionBackground(new Color[]{formColors.getColor("org.eclipse.ui.forms.TB_BG"), formColors.getBackground()}, new int[]{100}, true);
        return tabFolder;
    }

    public Composite newComposite(Composite parent) {
        return super.createComposite(parent);
    }

    public Composite newComposite(Composite parent, int style) {
        return super.createComposite(parent, style);
    }

    public ScrolledComposite newScrolledComposite(Composite parent, int style) {
        return new ScrolledComposite(parent, style);
    }

    public Group newGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        super.adapt((Control)group, true, true);
        return group;
    }

    public Button newButton(Composite parent, String text, int style) {
        return super.createButton(parent, text, style);
    }

    public Combo newCombo(Composite parent, int style) {
        Combo combo = new Combo(parent, style);
        super.adapt((Control)combo, true, true);
        return combo;
    }

    public Label newLabel(Composite parent, String text) {
        return super.createLabel(parent, text);
    }

    public Label newLabel(Composite parent, String text, int style) {
        return super.createLabel(parent, text, style);
    }

    public Text newText(Composite parent, String value, int style) {
        return super.createText(parent, value, style);
    }
}

