/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.readers;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.parsers.ConnectedRecord;
import org.eclipse.titan.log.viewer.parsers.RecordParser;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.EventType;

public final class ValueReader {
    private static ValueReader instance = null;
    private static Map<Long, LogRecord> cache = new HashMap<Long, LogRecord>();

    private ValueReader() {
    }

    public static ValueReader getInstance() {
        if (instance == null) {
            instance = new ValueReader();
        }
        return instance;
    }

    public LogRecord readLogRecordFromLogFileCached(URI logFilePath, EventObject event) throws IOException, ParseException {
        if (cache.containsKey(event.getRecordOffset())) {
            return cache.get(event.getRecordOffset());
        }
        LogRecord temp = this.readLogRecordFromLogFile(logFilePath, event);
        cache.put(event.getRecordOffset(), temp);
        return temp;
    }

    public LogRecord readLogRecordFromLogFile(URI logFilePath, EventObject event) throws IOException, ParseException {
        long offset = event.getRecordOffset();
        int length = event.getRecordLength();
        LogRecord logrecord = this.getLogRecord(logFilePath, offset, length);
        String message = logrecord.getMessage();
        EventType type = event.getType();
        switch (type) {
            case SEND: {
                message = this.readSendEvent(message);
                break;
            }
            case RECEIVE: {
                message = this.readReceiveEvent(message);
                break;
            }
            case SILENT_EVENT: {
                message = this.getValue(logFilePath, offset, length);
                break;
            }
            case ENQUEUED: {
                message = this.readEnqueuedEvent(message);
                break;
            }
            case SETVERDICT: {
                ConnectedRecord[] connectedRecords = event.getConnectedRecords();
                if (connectedRecords != null) {
                    StringBuilder messageBuilder = new StringBuilder("{ message := " + message.trim());
                    if (connectedRecords.length > 0) {
                        messageBuilder.append(", causedBy := { ");
                    }
                    for (int i = 0; i < connectedRecords.length; ++i) {
                        int eventNumber = i + 1;
                        ConnectedRecord connectedEvent = connectedRecords[i];
                        logrecord = this.getLogRecord(logFilePath, connectedEvent.getRecordOffset(), connectedEvent.getRecordLength());
                        messageBuilder.append("event" + eventNumber + " := { timestamp := " + logrecord.getTimestamp() + ", componentRef := " + logrecord.getComponentReference() + ", eventType := " + logrecord.getEventType() + ", sourceInfo := " + logrecord.getSourceInformation() + ", message := {" + logrecord.getMessage().trim() + "} }");
                    }
                    if (connectedRecords.length > 0) {
                        messageBuilder.append(" }");
                    }
                    message = messageBuilder.toString();
                }
                message = message + "}\n";
                break;
            }
        }
        logrecord.setMessage(message);
        return logrecord;
    }

    private String readEnqueuedEvent(String message) {
        if (message.contains("system(")) {
            int stopIndex = message.indexOf(")");
            message = message.substring(stopIndex + 1);
        }
        if (message.contains(":")) {
            message = message.substring(message.indexOf(":") + 2);
        }
        return message;
    }

    private String readReceiveEvent(String message) {
        String[] strings;
        int stopIndex;
        if (message.contains("system(") && (message = message.substring((stopIndex = message.indexOf(")")) + 1)).contains(":")) {
            message = message.substring(message.indexOf(":") + 1);
        }
        if ((strings = message.split("with queue id \\d+: \\S++ : ")).length > 1) {
            message = strings[1];
        }
        if ((strings = message.split(" from \\S++ \\S++ : ")).length > 1) {
            message = strings[1];
        }
        if ((strings = message.split(" from \\S++ \\S++ ")).length > 1) {
            message = strings[1];
        }
        return message;
    }

    private String readSendEvent(String message) {
        if (message.contains("system(")) {
            int stopIndex = message.indexOf(")");
            if ((message = message.substring(stopIndex + 1)).contains(":")) {
                message = message.substring(message.indexOf(":") + 1);
            }
        } else {
            String[] strings = message.split(" to \\S++ \\S++ : ");
            if (strings.length > 1) {
                message = strings[1];
            }
            if ((strings = message.split(" to \\S++ \\S++ ")).length > 1) {
                message = strings[1];
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValue(URI logFilePath, long offset, int length) throws IOException, ParseException {
        RandomAccessFile random = null;
        String message = null;
        try {
            random = new RandomAccessFile(new File(logFilePath), "r");
            random.seek(offset);
            byte[] buffer = new byte[length];
            random.read(buffer, 0, length);
            RecordParser recordParser = new RecordParser();
            LogRecord logRecord = recordParser.parse(buffer);
            message = logRecord.getMessage();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(random);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)random);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogRecord getLogRecord(URI logFilePath, long offset, int length) throws IOException, ParseException {
        RandomAccessFile random = null;
        LogRecord logRecord = null;
        try {
            random = new RandomAccessFile(new File(logFilePath), "r");
            random.seek(offset);
            byte[] buffer = new byte[length];
            random.read(buffer, 0, length);
            RecordParser recordParser = new RecordParser();
            logRecord = recordParser.parse(buffer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(random);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)random);
        return logRecord;
    }
}

