/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.types.CTs_EE_CTs;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class ASN1_Set_Seq_Choice_BaseType
extends ASN1Type
implements ITypeWithComponents,
IReferenceableElement {
    protected Block mBlock;
    protected CTs_EE_CTs components;

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    public CompField getComponentByName(Identifier identifier) {
        if (null == this.components) {
            return null;
        }
        return this.components.getCompByName(identifier);
    }

    public int getNofComponents(CompilationTimeStamp timestamp) {
        if (null == this.components || this.lastTimeChecked == null) {
            this.check(timestamp);
        }
        return this.components.getNofComps();
    }

    public boolean hasComponentWithName(Identifier identifier) {
        if (null == this.components) {
            return false;
        }
        return this.components.hasCompWithName(identifier);
    }

    public CompField getComponentByIndex(int index) {
        return this.components.getCompByIndex(index);
    }

    public Identifier getComponentIdentifierByIndex(int index) {
        return this.components.getCompByIndex(index).getIdentifier();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.components) {
            this.components.setMyScope(scope);
        }
    }

    @Override
    public Location getLikelyLocation() {
        if (this.mBlock != null) {
            return this.mBlock.getLocation();
        }
        return this.location;
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.components == null) {
            return;
        }
        this.components.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.components != null) {
            this.components.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.components == null || this.components.accept(v);
    }

    @Override
    public Identifier getComponentIdentifierByName(Identifier identifier) {
        CompField cf = this.getComponentByName(identifier);
        return cf == null ? null : cf.getIdentifier();
    }

    @Override
    public Declaration resolveReference(Reference reference, int subRefIdx, ISubReference lastSubreference) {
        int actualIndex;
        List<ISubReference> subreferences = reference.getSubreferences();
        for (actualIndex = subRefIdx; actualIndex < subreferences.size() && subreferences.get(actualIndex) instanceof ArraySubReference; ++actualIndex) {
        }
        if (actualIndex == subreferences.size()) {
            return null;
        }
        Identifier fieldID = subreferences.get(actualIndex).getId();
        if (subreferences.get(actualIndex) == lastSubreference) {
            return Declaration.createInstance(this.getDefiningAssignment(), fieldID);
        }
        CompField compField = this.getComponentByName(fieldID);
        IType compFieldType = compField.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (compFieldType instanceof IReferenceableElement) {
            Declaration decl = ((IReferenceableElement)((Object)compFieldType)).resolveReference(reference, actualIndex + 1, lastSubreference);
            return decl != null ? decl : Declaration.createInstance(this.getDefiningAssignment(), compField.getIdentifier());
        }
        return null;
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.components.getCompByName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addDeclaration(declarationCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.components.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    declarationCollector.addDeclaration(compField.getIdentifier().getDisplayName(), compField.getIdentifier().getLocation(), this);
                }
            }
        }
    }

    @Override
    public Object[] getOutlineChildren() {
        if (this.components == null) {
            return new Object[0];
        }
        return this.components.getOutlineChildren();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i || this.components == null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.components.getCompByName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addProposal(propCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.components.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    String proposalKind = compField.getType().getProposalDescription(new StringBuilder()).toString();
                    propCollector.addProposal(compField.getIdentifier(), " - " + proposalKind, ImageCache.getImage(this.getOutlineIcon()), proposalKind);
                }
            }
        }
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                typeArray.add(this);
                return fieldType.getFieldTypesAsArray(reference, actualSubReference + 1, typeArray);
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }
}

