/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.titan.designer.AST.ASN1.Undefined_Assignment;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.For_Loop_Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.console.MessageConsoleStream;

public final class ReferenceFinder {
    public static final String NORECOGNISABLESCOPE = "No valid scope could be recognised";
    public static final String NORECOGNISABLEASSIGNMENT = "No valid definition could be recognised";
    public static final String NOASSIGNMENTTYPE = "Cannot determine the type of the definition";
    public Scope scope = null;
    public Assignment assignment = null;
    public IType type = null;
    public Identifier fieldId = null;

    public ReferenceFinder() {
    }

    public ReferenceFinder(Assignment assignment) {
        this.assignment = assignment;
        this.scope = this.detectSmallestScope(assignment);
        if (assignment instanceof Undefined_Assignment) {
            this.assignment = ((Undefined_Assignment)assignment).getRealAssignment(CompilationTimeStamp.getBaseTimestamp());
            if (this.assignment == null) {
                throw new IllegalArgumentException();
            }
        }
        if (assignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE) {
            this.type = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
            if (this.type == null) {
                throw new IllegalArgumentException();
            }
            this.scope = this.scope.getModuleScope();
            this.type = this.type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        }
    }

    public boolean detectAssignmentDataByOffset(Module module, int offset, IEditorPart targetEditor, boolean reportErrors, boolean reportDebugInformation) {
        this.scope = module.getSmallestEnclosingScope(offset);
        if (this.scope == null) {
            if (reportErrors) {
                targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NORECOGNISABLESCOPE);
            }
            return false;
        }
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(offset);
        module.accept(visitor);
        Declaration declaration = visitor.getReferencedDeclaration();
        if (declaration == null) {
            return false;
        }
        this.assignment = declaration.getAssignment();
        if (this.assignment == null) {
            if (reportErrors) {
                targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NORECOGNISABLEASSIGNMENT);
            }
            return false;
        }
        this.scope = this.detectSmallestScope(this.assignment);
        if (this.assignment instanceof Undefined_Assignment) {
            this.assignment = ((Undefined_Assignment)this.assignment).getRealAssignment(CompilationTimeStamp.getBaseTimestamp());
            if (this.assignment == null) {
                if (reportErrors) {
                    targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NORECOGNISABLEASSIGNMENT);
                }
                return false;
            }
        }
        if (this.assignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE) {
            this.type = this.assignment.getType(CompilationTimeStamp.getBaseTimestamp());
            if (this.type == null) {
                if (reportErrors) {
                    targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NOASSIGNMENTTYPE);
                }
                return false;
            }
            this.type.getEnclosingField(offset, this);
            this.type = this.type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        }
        if (reportDebugInformation) {
            MessageConsoleStream stream = TITANDebugConsole.getConsole().newMessageStream();
            TITANDebugConsole.println("found scope: name=" + this.scope.getScopeName() + "  type=" + this.scope.getClass().getName(), stream);
            TITANDebugConsole.println("found assignment: name=" + this.assignment.getIdentifier().getDisplayName() + "  type=" + this.assignment.getClass().getName(), stream);
            if (this.type != null) {
                TITANDebugConsole.println("found type: name=" + this.type.getTypename() + "  type=" + this.type.getClass().getName(), stream);
            }
            if (this.fieldId != null) {
                TITANDebugConsole.println("found field: name=" + this.fieldId.getDisplayName(), stream);
            }
        }
        return true;
    }

    private Scope detectSmallestScope(Assignment assignment) {
        Scope localScope = assignment.getMyScope();
        Module module = localScope.getModuleScope();
        if (localScope instanceof StatementBlock) {
            StatementBlock statementBlock = (StatementBlock)localScope;
            if (statementBlock.getMyDefinition() instanceof Def_Altstep) {
                localScope = localScope.getParentScope();
            }
            if (statementBlock.hasEnclosingLoopOrAltguard()) {
                localScope = localScope.getParentScope();
            }
        }
        if (localScope instanceof NamedBridgeScope) {
            localScope = localScope.getParentScope();
        }
        if (localScope instanceof Assignments && localScope.getParentScope() == module) {
            localScope = module;
        } else if (localScope instanceof ComponentTypeBody) {
            localScope = module;
        } else if (localScope instanceof FormalParameterList || localScope instanceof RunsOnScope) {
            localScope = module;
        } else if (localScope instanceof For_Loop_Definitions) {
            localScope = localScope.getParentScope();
        }
        return localScope;
    }

    public Map<Module, List<Hit>> findAllReferences(Module module, IProject project, IProgressMonitor pMonitor, boolean reportDebugInformation) {
        IProgressMonitor monitor = pMonitor == null ? new NullProgressMonitor() : pMonitor;
        List<IProject> relatedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getAllReferencingProjects();
        relatedProjects.addAll(ProjectBasedBuilder.getProjectBasedBuilder(project).getAllReachableProjects());
        relatedProjects.add(project);
        int size = 0;
        for (IProject tempProject : relatedProjects) {
            size += GlobalParser.getProjectSourceParser(tempProject).getModules().size();
        }
        monitor.beginTask("Searching references.", size);
        HashMap<Module, List<Hit>> foundIdsMap = new HashMap<Module, List<Hit>>();
        ArrayList<Hit> foundIds = new ArrayList<Hit>();
        this.scope.findReferences(this, foundIds);
        if (!foundIds.isEmpty()) {
            foundIdsMap.put(this.scope.getModuleScope(), foundIds);
        }
        if (this.scope instanceof Module) {
            for (IProject project2 : relatedProjects) {
                ProjectSourceParser projectSourceParser2 = GlobalParser.getProjectSourceParser(project2);
                for (Module module2 : projectSourceParser2.getModules()) {
                    if (monitor.isCanceled()) {
                        return foundIdsMap;
                    }
                    for (Module m : module2.getImportedModules()) {
                        if (m != this.scope) continue;
                        if (reportDebugInformation) {
                            TITANDebugConsole.println("found importing module: " + module2.getName());
                        }
                        foundIds = new ArrayList();
                        module2.findReferences(this, foundIds);
                        if (foundIds.isEmpty()) break;
                        foundIdsMap.put(module2, foundIds);
                        break;
                    }
                    monitor.worked(1);
                }
            }
        }
        monitor.done();
        return foundIdsMap;
    }

    public String getSearchName() {
        if (this.fieldId == null) {
            return this.assignment.getDescription();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Field `").append(this.fieldId.getDisplayName()).append("' of ").append(this.type.getTypename());
        return sb.toString();
    }

    public Identifier getReferredIdentifier() {
        if (this.fieldId != null) {
            return this.fieldId;
        }
        if (this.assignment != null) {
            return this.assignment.getIdentifier();
        }
        return null;
    }

    public List<Hit> findReferencesInModule(Module module) {
        ArrayList<Hit> foundIds = new ArrayList<Hit>();
        module.findReferences(this, foundIds);
        return foundIds;
    }

    public static class Hit {
        public Identifier identifier;
        public Reference reference;

        public Hit(Identifier identifier) {
            this.identifier = identifier;
            this.reference = null;
        }

        public Hit(Identifier identifier, Reference reference) {
            this.identifier = identifier;
            this.reference = reference;
        }
    }
}

