/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Qualifier
implements ILocateableNode,
IIncrementallyUpdateable,
IIdentifierContainer,
IVisitableNode {
    public static final String INVALID_INDEX_QUALIFIER = "Invalid field qualifier [-]";
    public static final String INVALID_FIELD_QUALIFIER = "Invalid field qualifier {0}";
    private Location location = NULL_Location.INSTANCE;
    private final List<ISubReference> subReferences = new ArrayList<ISubReference>(1);
    private Definition definition = null;

    private Qualifier() {
    }

    public Qualifier(ISubReference subReference) {
        if (subReference != null) {
            this.subReferences.add(subReference);
        }
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        for (ISubReference subref : this.subReferences) {
            subref.appendDisplayName(sb);
        }
        return sb.toString();
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void addSubReference(ISubReference subReference) {
        if (subReference != null) {
            this.subReferences.add(subReference);
        }
    }

    public void addSubReferenceFront(ISubReference subReference) {
        if (subReference != null) {
            this.subReferences.add(0, subReference);
        }
    }

    public int getNofSubReferences() {
        return this.subReferences.size();
    }

    public ISubReference getSubReferenceByIndex(int index) {
        return this.subReferences.get(index);
    }

    public Qualifier getQualifierWithoutFirstSubRef() {
        Qualifier temp = new Qualifier();
        temp.setLocation(new Location(this.getLocation()));
        for (int i = 1; i < this.subReferences.size(); ++i) {
            temp.addSubReference(this.subReferences.get(i));
        }
        return temp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.subReferences != null) {
            int size = this.subReferences.size();
            for (int i = 0; i < size; ++i) {
                reparser.updateLocation(this.subReferences.get(i).getLocation());
            }
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.definition != null && this.subReferences != null) {
            for (ISubReference sr : this.subReferences) {
                sr.findReferences(referenceFinder, foundIdentifiers);
            }
            if (referenceFinder.fieldId != null) {
                IType t = this.definition.getType(CompilationTimeStamp.getBaseTimestamp());
                if (t == null) {
                    return;
                }
                ArrayList<IType> typeArray = new ArrayList<IType>();
                Reference reference = new Reference(null);
                reference.addSubReference(new FieldSubReference(this.definition.getIdentifier()));
                for (ISubReference sr : this.subReferences) {
                    reference.addSubReference(sr);
                }
                reference.setLocation(this.location);
                reference.setMyScope(this.definition.getMyScope());
                boolean success = t.getFieldTypesAsArray(reference, 1, typeArray);
                if (!success) {
                    return;
                }
                if (this.subReferences.size() != typeArray.size()) {
                    ErrorReporter.INTERNAL_ERROR();
                    return;
                }
                for (int i = 0; i < this.subReferences.size(); ++i) {
                    if (typeArray.get(i) != referenceFinder.type || this.subReferences.get(i) instanceof ArraySubReference || !this.subReferences.get(i).getId().equals(referenceFinder.fieldId)) continue;
                    foundIdentifiers.add(new ReferenceFinder.Hit(this.subReferences.get(i).getId()));
                }
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.subReferences != null) {
            for (ISubReference sr : this.subReferences) {
                if (sr.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }
}

