/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class FriendModule
extends ASTNode
implements ILocateableNode,
IAppendableSyntax,
IIncrementallyUpdateable {
    public static final String MISSINGMODULE = "There is no module with name `{0}''";
    private Identifier identifier;
    protected WithAttributesPath withAttributesPath = null;
    private Group parentGroup = null;
    private IProject project;
    private Location location;
    private CompilationTimeStamp lastCheckTimeStamp;

    public FriendModule(Identifier identifier) {
        this.identifier = identifier;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public void setParentGroup(Group parentGroup) {
        this.parentGroup = parentGroup;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        if (attributes != null) {
            this.withAttributesPath.setWithAttributes(attributes);
        }
    }

    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    public void setAttributeParentPath(WithAttributesPath parent) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setAttributeParent(parent);
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCheckTimeStamp != null && !this.lastCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser(this.project);
        if (parser == null || this.identifier == null) {
            this.lastCheckTimeStamp = timestamp;
            return;
        }
        Module referredModule = parser.getModuleByName(this.identifier.getName());
        if (referredModule == null) {
            this.identifier.getLocation().reportConfigurableSemanticProblem(Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportMissingFriendModule", "warning", null), MessageFormat.format(MISSINGMODULE, this.identifier.getDisplayName()));
        } else if (!Module.module_type.TTCN3_MODULE.equals((Object)referredModule.getModuletype())) {
            this.identifier.getLocation().reportSemanticError(MessageFormat.format("The friend module `{0}'' must be a TTCN-3 module", this.identifier.getDisplayName()));
        }
        this.lastCheckTimeStamp = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            result.add(155);
            return result;
        }
        return null;
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        return new ArrayList<Integer>(0);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            boolean enveloped = false;
            int result = 1;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                result = r.parse();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    reparser.extendDamagedRegion(this.withAttributesPath.getLocation());
                    result = this.reparse(reparser);
                }
            }
            if (result != 0) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private int reparse(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                MultipleWithAttributes attributes = parser.pr_reparser_optionalWithStatement().attributes;
                parser.pr_EndOfFile();
                if (parser.isErrorListEmpty()) {
                    FriendModule.this.withAttributesPath.setWithAttributes(attributes);
                    if (attributes != null) {
                        FriendModule.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                    }
                }
            }
        });
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        return this.withAttributesPath == null || this.withAttributesPath.accept(v);
    }

    public IProject getProject() {
        return this.project;
    }
}

