/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FriendModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class Group
extends ASTNode
implements IOutlineElement,
ILocateableNode,
IAppendableSyntax {
    private final List<Definition> definitions;
    private Map<String, Definition> definitionMap;
    private final List<Group> groups;
    private final List<ImportModule> importedModules;
    private final List<FriendModule> friendModules;
    private CompilationTimeStamp lastCompilationTimeStamp;
    private CompilationTimeStamp lastUniquenessCheckTimeStamp;
    protected Identifier identifier;
    protected WithAttributesPath withAttributesPath = null;
    private Location location;
    private Location innerLocation;
    private Location commentLocation = null;
    private Group parentGroup;
    public static final String DUPLICATEGROUPFIRST = "Duplicate group definition with name `{0}'' was first defined here";
    public static final String DUPLICATEGROUPREPEATED = "Duplicate group definition with name `{0}'' was defined here again";
    public static final String GROUPCLASHGROUP = "Group name `{0}'' clashes with a definition";
    public static final String GROUPCLASHDEFINITION = "Definition of `{0}'' is here";

    public Group(Identifier identifier) {
        this.identifier = identifier;
        this.definitions = new CopyOnWriteArrayList<Definition>();
        this.groups = new ArrayList<Group>();
        this.importedModules = new CopyOnWriteArrayList<ImportModule>();
        this.friendModules = new CopyOnWriteArrayList<FriendModule>();
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setInnerLocation(Location location) {
        this.innerLocation = location;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    public void setParentGroup(Group parentGroup) {
        this.parentGroup = parentGroup;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    protected TTCN3Module getModule() {
        Group temp = this;
        while (temp.parentGroup != null) {
            temp = temp.parentGroup;
        }
        return (TTCN3Module)((Definitions)temp.getNameParent()).getParentScope();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (Group group : this.groups) {
            if (group != child) continue;
            Identifier tempIdentifier = group.getIdentifier();
            return builder.append(".").append(tempIdentifier.getDisplayName());
        }
        return builder;
    }

    public void addDefinition(Definition definition) {
        if (definition != null && definition.getIdentifier() != null && definition.getIdentifier().getLocation() != null) {
            definition.setParentGroup(this);
            this.definitions.add(definition);
        }
    }

    public void addImportedModule(ImportModule impmod) {
        if (impmod != null && impmod.getIdentifier() != null && impmod.getIdentifier().getLocation() != null) {
            impmod.setParentGroup(this);
            this.importedModules.add(impmod);
        }
    }

    public void addFriendModule(FriendModule friendModule) {
        if (friendModule != null) {
            friendModule.setParentGroup(this);
            this.friendModules.add(friendModule);
        }
    }

    public void addDefinitions(List<Definition> definitionList) {
        if (definitionList != null) {
            for (Definition def : definitionList) {
                this.addDefinition(def);
            }
        }
    }

    public void addGroup(Group group) {
        if (group != null && group.getIdentifier() != null && group.getIdentifier().getLocation() != null) {
            this.groups.add(group);
            group.setFullNameParent(this);
            group.setParentGroup(this);
        }
    }

    public void addDeclaration(DeclarationCollector declarationCollector) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() == 1 && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
            declarationCollector.addDeclaration(this);
        }
    }

    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        if (attributes != null) {
            this.withAttributesPath.setWithAttributes(attributes);
        }
    }

    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    public void setAttributeParentPath(WithAttributesPath parent) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setAttributeParent(parent);
    }

    @Override
    public Object[] getOutlineChildren() {
        ArrayList<Object> outlineElements = new ArrayList<Object>();
        if (!this.importedModules.isEmpty()) {
            outlineElements.add(this.importedModules);
        }
        if (!this.friendModules.isEmpty()) {
            outlineElements.add(this.friendModules);
        }
        int from = 0;
        for (Definition def : this.definitions) {
            for (int j = from; j < this.groups.size(); ++j) {
                Group grp = this.groups.get(j);
                if (def.getLocation().getLine() < grp.getLocation().getLine()) continue;
                outlineElements.add(grp);
                ++from;
            }
            outlineElements.add(def);
        }
        if (from < this.groups.size()) {
            for (int i = from; i < this.groups.size(); ++i) {
                outlineElements.add(this.groups.get(i));
            }
        }
        return outlineElements.toArray();
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    @Override
    public String getOutlineIcon() {
        return "outline_group.gif";
    }

    @Override
    public int category() {
        return 0;
    }

    private void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheckTimeStamp != null && !this.lastUniquenessCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.definitionMap = new HashMap<String, Definition>(this.definitions.size());
        }
        HashMap<String, Group> groupMap = new HashMap<String, Group>(this.groups.size());
        for (Definition def : this.definitions) {
            String defName = def.getIdentifier().getName();
            if (this.definitionMap.containsKey(defName)) continue;
            this.definitionMap.put(defName, def);
        }
        for (Group group : this.groups) {
            String groupName = group.getIdentifier().getName();
            if (groupMap.containsKey(groupName)) {
                ((Group)groupMap.get(groupName)).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEGROUPFIRST, groupName));
                group.getIdentifier().getLocation().reportSemanticError(MessageFormat.format(DUPLICATEGROUPREPEATED, groupName));
            } else {
                groupMap.put(groupName, group);
            }
            if (!this.definitionMap.containsKey(groupName)) continue;
            group.getIdentifier().getLocation().reportSemanticError(MessageFormat.format(GROUPCLASHGROUP, groupName));
            this.definitionMap.get(groupName).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format(GROUPCLASHDEFINITION, groupName));
        }
        this.lastUniquenessCheckTimeStamp = timestamp;
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        T3Doc.check(this.getCommentLocation(), "group");
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionGroup", this.identifier, "group");
        NamingConventionHelper.checkNameContents(this.identifier, this.getModule().getIdentifier(), "group");
        this.checkUniqueness(timestamp);
        this.lastCompilationTimeStamp = timestamp;
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        int size = this.groups.size();
        for (int i = 0; i < size; ++i) {
            this.groups.get(i).check(timestamp);
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            result.add(155);
            return result;
        }
        return null;
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            ArrayList<Integer> result = new ArrayList<Integer>(2);
            result.add(110);
            result.add(112);
            return result;
        }
        return new ArrayList<Integer>(0);
    }

    private int reparseIdentifier(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Group.this.identifier = parser.pr_reparse_Identifier().identifier;
            }
        });
    }

    private int reparseOptionalWithStatement(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                MultipleWithAttributes attributes = parser.pr_reparser_optionalWithStatement().attributes;
                parser.pr_EndOfFile();
                if (parser.isErrorListEmpty()) {
                    Group.this.withAttributesPath.setWithAttributes(attributes);
                    if (attributes != null) {
                        Group.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                    }
                }
            }
        });
    }

    private int reparseModuleDefinitionsList(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                ArrayList<Definition> allDefinitions = new ArrayList<Definition>();
                ArrayList<Definition> localDefinitions = new ArrayList<Definition>();
                ArrayList<Group> localGroups = new ArrayList<Group>();
                ArrayList<ImportModule> allImports = new ArrayList<ImportModule>();
                ArrayList<ImportModule> localImports = new ArrayList<ImportModule>();
                ArrayList<FriendModule> allFriends = new ArrayList<FriendModule>();
                ArrayList<FriendModule> localFriends = new ArrayList<FriendModule>();
                TTCN3Module temp = Group.this.getModule();
                parser.setModule(temp);
                parser.pr_reparse_ModuleDefinitionsList(null, allDefinitions, localDefinitions, localGroups, allImports, localImports, allFriends, localFriends, null);
                if (parser.isErrorListEmpty()) {
                    temp.addDefinitions(allDefinitions);
                    for (ImportModule impmod : allImports) {
                        temp.addImportedModule(impmod);
                    }
                    for (FriendModule friend : allFriends) {
                        temp.addFriendModule(friend);
                    }
                    Group.this.addDefinitions(localDefinitions);
                    for (ImportModule impmod : localImports) {
                        Group.this.addImportedModule(impmod);
                    }
                    for (Group group : localGroups) {
                        Group.this.addGroup(group);
                    }
                    for (FriendModule friend : localFriends) {
                        Group.this.addFriendModule(friend);
                    }
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSyntax(TTCN3ReparseUpdater reparser, List<ImportModule> allImportedModules, List<Definition> allDefinitions, List<FriendModule> allFriends) throws ReParseException {
        int i;
        int i2;
        List<Integer> temp;
        boolean isBeingExtended;
        IVisitableNode temp2;
        int i3;
        int result = 0;
        Location tempLocation = this.identifier.getLocation();
        if (reparser.isDamaged(tempLocation)) {
            if (!reparser.envelopsDamage(tempLocation) && !reparser.isExtending(tempLocation)) throw new ReParseException();
            reparser.extendDamagedRegion(tempLocation);
            result = this.reparseIdentifier(reparser);
            if (result != 0) {
                throw new ReParseException(result);
            }
        } else {
            reparser.updateLocation(tempLocation);
        }
        if (reparser.isDamaged(this.innerLocation) && !reparser.envelopsDamage(this.innerLocation)) {
            throw new ReParseException();
        }
        boolean enveloped = false;
        int nofDamaged = 0;
        int leftBoundary = this.innerLocation.getOffset() + 1;
        int rightBoundary = this.innerLocation.getEndOffset() - 1;
        int damageOffset = reparser.getDamageStart();
        Object lastAppendableBeforeChange = null;
        Object lastPrependableBeforeChange = null;
        int size = this.groups.size();
        for (i3 = 0; i3 < size && !enveloped; ++i3) {
            temp2 = this.groups.get(i3);
            tempLocation = ((Group)temp2).getLocation();
            if (reparser.envelopsDamage(tempLocation)) {
                enveloped = true;
                leftBoundary = tempLocation.getEndOffset();
                rightBoundary = tempLocation.getOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation.getEndOffset() + 1;
                lastAppendableBeforeChange = temp2;
            }
            if (tempLocation.getOffset() < damageOffset || tempLocation.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation.getOffset();
            lastPrependableBeforeChange = temp2;
        }
        size = this.importedModules.size();
        for (i3 = 0; i3 < size && !enveloped; ++i3) {
            temp2 = this.importedModules.get(i3);
            tempLocation = ((ImportModule)temp2).getLocation();
            if (reparser.envelopsDamage(tempLocation)) {
                enveloped = true;
                leftBoundary = tempLocation.getEndOffset();
                rightBoundary = tempLocation.getOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation.getEndOffset() + 1;
                lastAppendableBeforeChange = temp2;
            }
            if (tempLocation.getOffset() < damageOffset || tempLocation.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation.getOffset();
            lastPrependableBeforeChange = temp2;
        }
        size = this.friendModules.size();
        for (i3 = 0; i3 < size && !enveloped; ++i3) {
            temp2 = this.friendModules.get(i3);
            tempLocation = ((FriendModule)temp2).getLocation();
            if (reparser.envelopsDamage(tempLocation)) {
                enveloped = true;
                leftBoundary = tempLocation.getEndOffset();
                rightBoundary = tempLocation.getOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation.getEndOffset() + 1;
                lastAppendableBeforeChange = temp2;
            }
            if (tempLocation.getOffset() < damageOffset || tempLocation.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation.getOffset();
            lastPrependableBeforeChange = temp2;
        }
        Iterator<Definition> iterator = this.definitions.iterator();
        while (iterator.hasNext() && !enveloped) {
            Location tempCommentLocation;
            Definition temp3 = iterator.next();
            tempLocation = temp3.getLocation();
            if (reparser.envelopsDamage(tempLocation)) {
                enveloped = true;
                leftBoundary = tempLocation.getEndOffset();
                rightBoundary = tempLocation.getOffset();
            } else if (reparser.isDamaged(tempLocation)) {
                ++nofDamaged;
                if (reparser.getDamageStart() == tempLocation.getEndOffset()) {
                    lastAppendableBeforeChange = temp3;
                } else if (reparser.getDamageEnd() == tempLocation.getOffset()) {
                    lastPrependableBeforeChange = temp3;
                }
            } else {
                if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                    leftBoundary = tempLocation.getEndOffset() + 1;
                    lastAppendableBeforeChange = temp3;
                }
                if (tempLocation.getOffset() >= damageOffset && tempLocation.getOffset() < rightBoundary) {
                    rightBoundary = tempLocation.getOffset();
                    lastPrependableBeforeChange = temp3;
                }
            }
            if ((tempCommentLocation = temp3.getCommentLocation()) == null || !reparser.isDamaged(tempCommentLocation)) continue;
            rightBoundary = tempCommentLocation.getOffset();
            lastPrependableBeforeChange = temp3;
        }
        if (!enveloped && reparser.envelopsDamage(this.location)) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (lastAppendableBeforeChange != null && (isBeingExtended = reparser.startsWithFollow(lastAppendableBeforeChange.getPossibleExtensionStarterTokens()))) {
            leftBoundary = lastAppendableBeforeChange.getLocation().getOffset();
            ++nofDamaged;
            enveloped = false;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (lastPrependableBeforeChange != null && (temp = lastPrependableBeforeChange.getPossiblePrefixTokens()) != null && reparser.endsWithToken(temp)) {
            rightBoundary = lastPrependableBeforeChange.getLocation().getEndOffset();
            ++nofDamaged;
            enveloped = false;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (nofDamaged != 0) {
            this.removeStuffInRange(reparser, allImportedModules, allDefinitions, this.friendModules);
        }
        for (i2 = 0; i2 < this.groups.size(); ++i2) {
            Group temp4 = this.groups.get(i2);
            tempLocation = temp4.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                temp4.updateSyntax(reparser, allImportedModules, allDefinitions, this.friendModules);
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.groups.remove(i2);
                    --i2;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        for (i2 = 0; i2 < this.importedModules.size(); ++i2) {
            ImportModule temp5 = this.importedModules.get(i2);
            tempLocation = temp5.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                temp5.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.importedModules.remove(i2);
                    --i2;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        for (i2 = 0; i2 < this.friendModules.size(); ++i2) {
            FriendModule temp6 = this.friendModules.get(i2);
            tempLocation = temp6.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                temp6.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.friendModules.remove(i2);
                    --i2;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        for (Definition temp7 : this.definitions) {
            tempLocation = temp7.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                boolean isDamaged = enveloped && reparser.envelopsDamage(tempLocation);
                temp7.updateSyntax(reparser, isDamaged);
                if (reparser.getNameChanged()) {
                    this.lastUniquenessCheckTimeStamp = null;
                    reparser.setNameChanged(false);
                }
                if (!isDamaged) continue;
                temp7.checkRoot();
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.definitions.remove(temp7);
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        if (result == 1) {
            this.removeStuffInRange(reparser, allImportedModules, allDefinitions, this.friendModules);
        }
        size = this.groups.size();
        for (i = 0; i < size; ++i) {
            Group temp8 = this.groups.get(i);
            tempLocation = temp8.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        size = this.importedModules.size();
        for (i = 0; i < size; ++i) {
            ImportModule temp9 = this.importedModules.get(i);
            tempLocation = temp9.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        size = this.friendModules.size();
        for (i = 0; i < size; ++i) {
            FriendModule temp10 = this.friendModules.get(i);
            tempLocation = temp10.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        for (Definition temp11 : this.definitions) {
            tempLocation = temp11.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        if (this.withAttributesPath != null && reparser.isAffected(this.withAttributesPath.getLocation())) {
            if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                reparser.extendDamagedRegion(this.withAttributesPath.getLocation());
                result = this.reparseOptionalWithStatement(reparser);
                if (result == 0) return;
                throw new ReParseException(result);
            }
            this.withAttributesPath.updateSyntax(reparser, reparser.envelopsDamage(this.withAttributesPath.getLocation()));
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
        if (!enveloped && reparser.envelopsDamage(this.innerLocation)) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            result = this.reparseModuleDefinitionsList(reparser);
        }
        reparser.updateLocation(this.innerLocation);
        if (result <= 1) return;
        throw new ReParseException(result - 1);
    }

    private void removeStuffInRange(TTCN3ReparseUpdater reparser, List<ImportModule> allImportedModules, List<Definition> allDefinitions, List<FriendModule> allFriends) {
        int i;
        for (i = this.groups.size() - 1; i >= 0; --i) {
            Group group = this.groups.get(i);
            if (!reparser.isDamaged(group.getLocation())) continue;
            reparser.extendDamagedRegion(group.getLocation());
            this.groups.remove(i);
        }
        for (i = this.importedModules.size() - 1; i >= 0; --i) {
            ImportModule importModule = this.importedModules.get(i);
            if (!reparser.isDamaged(importModule.getLocation())) continue;
            reparser.extendDamagedRegion(importModule.getLocation());
            this.importedModules.remove(i);
        }
        for (i = allImportedModules.size() - 1; i >= 0; --i) {
            ImportModule importModule = allImportedModules.get(i);
            if (!reparser.isDamaged(importModule.getLocation())) continue;
            reparser.extendDamagedRegion(importModule.getLocation());
            allImportedModules.remove(i);
        }
        for (i = this.friendModules.size() - 1; i >= 0; --i) {
            FriendModule friendModule = this.friendModules.get(i);
            if (!reparser.isDamaged(friendModule.getLocation())) continue;
            reparser.extendDamagedRegion(friendModule.getLocation());
            this.friendModules.remove(i);
        }
        for (i = allFriends.size() - 1; i >= 0; --i) {
            FriendModule friendModule = allFriends.get(i);
            if (!reparser.isDamaged(friendModule.getLocation())) continue;
            reparser.extendDamagedRegion(friendModule.getLocation());
            allFriends.remove(i);
        }
        for (i = this.definitions.size() - 1; i >= 0; --i) {
            Definition definition = this.definitions.get(i);
            if (!reparser.isDamaged(definition.getLocation())) continue;
            reparser.extendDamagedRegion(definition.getLocation());
            this.definitions.remove(i);
        }
        for (Definition definition : allDefinitions) {
            if (!reparser.isDamaged(definition.getLocation())) continue;
            reparser.extendDamagedRegion(definition.getLocation());
            allDefinitions.remove(definition);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.identifier == null || this.identifier.accept(v);
    }
}

