/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.PortReference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Map_Statement
extends Statement {
    public static final String BOTHENDSARETESTCOMPONENTPORTS = "Both endpoints of the mapping are test component ports";
    public static final String BOTHENDSARESYSTEMPORTS = "Both endpoints of the mapping are system ports";
    public static final String INCONSISTENTMAPPING1 = "The mapping between test component port type `{0}'' and system port type `{1}'' is not consistent";
    public static final String INCONSISTENTMAPPING2 = "The mapping between system port type `{0}'' and test component port type `{1}'' is not consistent";
    public static final String INCONSISTENTMAPPING3 = "The mapping between port types `{0}'' and `{1}'' is not consistent";
    private static final String FULLNAMEPART1 = ".componentreference1";
    private static final String FULLNAMEPART2 = ".portreference1";
    private static final String FULLNAMEPART3 = ".componentreference2";
    private static final String FULLNAMEPART4 = ".portreference2";
    private static final String STATEMENT_NAME = "map";
    private final Value componentReference1;
    private final PortReference portReference1;
    private final Value componentReference2;
    private final PortReference portReference2;

    public Map_Statement(Value componentReference1, PortReference portReference1, Value componentReference2, PortReference portReference2) {
        this.componentReference1 = componentReference1;
        this.portReference1 = portReference1;
        this.componentReference2 = componentReference2;
        this.portReference2 = portReference2;
        if (componentReference1 != null) {
            componentReference1.setFullNameParent(this);
        }
        if (portReference1 != null) {
            portReference1.setFullNameParent(this);
        }
        if (componentReference2 != null) {
            componentReference2.setFullNameParent(this);
        }
        if (portReference2 != null) {
            portReference2.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_MAP;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference1 == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.portReference1 == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.componentReference2 == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.portReference2 == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentReference1 != null) {
            this.componentReference1.setMyScope(scope);
        }
        if (this.componentReference2 != null) {
            this.componentReference2.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        IValue configReference2;
        IType portType2;
        IValue configReference1;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        PortTypeBody body1 = null;
        PortTypeBody body2 = null;
        boolean cref1IsTestcomponents = false;
        boolean cref1IsSystem = false;
        boolean cref2IsTestcomponent = false;
        boolean cref2IsSystem = false;
        IType portType1 = Port_Utility.checkConnectionEndpoint(timestamp, this, this.componentReference1, this.portReference1, true);
        if (portType1 != null) {
            body1 = ((Port_Type)portType1).getPortBody();
            if (body1.isInternal()) {
                this.componentReference1.getLocation().reportSemanticError(MessageFormat.format("Port type `{0}'' was marked as `internal''", portType1.getTypename()));
            }
            this.portReference1.getRefdAssignment(timestamp, false);
        }
        if (this.componentReference1 != null && IValue.Value_type.EXPRESSION_VALUE.equals((Object)(configReference1 = this.componentReference1.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null)).getValuetype())) {
            switch (((Expression_Value)configReference1).getOperationType()) {
                case MTC_COMPONENT_OPERATION: {
                    cref1IsTestcomponents = true;
                    break;
                }
                case SELF_COMPONENT_OPERATION: {
                    cref1IsTestcomponents = true;
                    break;
                }
                case COMPONENT_CREATE_OPERATION: {
                    cref1IsTestcomponents = true;
                    break;
                }
                case SYSTEM_COMPONENT_OPERATION: {
                    cref1IsSystem = true;
                    break;
                }
            }
        }
        if ((portType2 = Port_Utility.checkConnectionEndpoint(timestamp, this, this.componentReference2, this.portReference2, true)) != null) {
            body2 = ((Port_Type)portType2).getPortBody();
            if (body2.isInternal()) {
                this.componentReference2.getLocation().reportSemanticError(MessageFormat.format("Port type `{0}'' was marked as `internal''", portType2.getTypename()));
            }
            this.portReference2.getRefdAssignment(timestamp, false);
        }
        if (this.componentReference2 != null && IValue.Value_type.EXPRESSION_VALUE.equals((Object)(configReference2 = this.componentReference2.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null)).getValuetype())) {
            switch (((Expression_Value)configReference2).getOperationType()) {
                case MTC_COMPONENT_OPERATION: {
                    cref2IsTestcomponent = true;
                    break;
                }
                case SELF_COMPONENT_OPERATION: {
                    cref2IsTestcomponent = true;
                    break;
                }
                case COMPONENT_CREATE_OPERATION: {
                    cref2IsTestcomponent = true;
                    break;
                }
                case SYSTEM_COMPONENT_OPERATION: {
                    cref2IsSystem = true;
                    break;
                }
            }
        }
        this.lastTimeChecked = timestamp;
        if (cref1IsTestcomponents && cref2IsTestcomponent) {
            this.location.reportSemanticError(BOTHENDSARETESTCOMPONENTPORTS);
            return;
        }
        if (cref1IsSystem && cref2IsSystem) {
            this.location.reportSemanticError(BOTHENDSARESYSTEMPORTS);
            return;
        }
        if (body1 == null || body2 == null || portType1 == null || portType2 == null) {
            return;
        }
        if (cref1IsTestcomponents || cref2IsSystem) {
            if (!body1.isMappable(timestamp, body2)) {
                this.location.reportSemanticError(MessageFormat.format(INCONSISTENTMAPPING1, portType1.getTypename(), portType2.getTypename()));
                body1.reportMappingErrors(timestamp, body2);
            }
        } else if (cref2IsTestcomponent || cref1IsSystem) {
            if (!body2.isMappable(timestamp, body1)) {
                this.location.reportSemanticError(MessageFormat.format(INCONSISTENTMAPPING2, portType1.getTypename(), portType2.getTypename()));
                body2.reportMappingErrors(timestamp, body1);
            }
        } else if (!body1.isMappable(timestamp, body2) && !body2.isMappable(timestamp, body1)) {
            this.location.reportSemanticError(MessageFormat.format(INCONSISTENTMAPPING3, portType1.getTypename(), portType2.getTypename()));
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentReference1 != null) {
            this.componentReference1.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference1.getLocation());
        }
        if (this.portReference1 != null) {
            this.portReference1.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference1.getLocation());
        }
        if (this.componentReference2 != null) {
            this.componentReference2.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference2.getLocation());
        }
        if (this.portReference2 != null) {
            this.portReference2.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference1 != null) {
            this.componentReference1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.portReference1 != null) {
            this.portReference1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.componentReference2 != null) {
            this.componentReference2.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.portReference2 != null) {
            this.portReference2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReference1 != null && !this.componentReference1.accept(v)) {
            return false;
        }
        if (this.portReference1 != null && !this.portReference1.accept(v)) {
            return false;
        }
        if (this.componentReference2 != null && !this.componentReference2.accept(v)) {
            return false;
        }
        return this.portReference2 == null || this.portReference2.accept(v);
    }
}

