/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.values.Anytype_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Anytype_Type
extends Type {
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for anytype type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for anytype type `{0}''";
    private static final String ONEFIELDEXPECTED = "A template for anytype type must contain exactly one selected field";
    private static final String ANYTYPEEXPECTED = "Anytype value was expected for type `{0}''";
    private static final String NONEXISTENTUNION = "Reference to a non-existent field `{0}'' in anytype value for type `{1}''";
    private static final String NOCOMPATIBLEFIELD = "Type anytype `{0}'' doesn''t have any field compatible with `{1}''";
    private static final String NOTCOMPATIBLEANYTYPE = "Type anytype is compatible only with other anytype types";
    private CompFieldMap compFieldMap;

    public Anytype_Type() {
        this.clear();
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ANYTYPE;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.compFieldMap.setMyScope(scope);
    }

    public int getNofComponents() {
        if (this.compFieldMap == null) {
            return 0;
        }
        return this.compFieldMap.fields.size();
    }

    public CompField getComponentByIndex(int index) {
        return this.compFieldMap.fields.get(index);
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ANYTYPE: {
                Anytype_Type tempType = (Anytype_Type)temp;
                if (this == tempType) {
                    return true;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < this.getNofComponents(); ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    for (int j = 0; j < tempType.getNofComponents(); ++j) {
                        CompField tempComponentField = tempType.getComponentByIndex(j);
                        IType tempTypeCompFieldType = tempComponentField.getType().getTypeRefdLast(timestamp);
                        if (!cf.getIdentifier().getDisplayName().equals(tempComponentField.getIdentifier().getDisplayName()) || !cfType.getMyScope().getModuleScope().equals(tempTypeCompFieldType.getMyScope().getModuleScope())) continue;
                        lChain.markState();
                        rChain.markState();
                        lChain.add(cfType);
                        rChain.add(tempTypeCompFieldType);
                        if (cfType == tempTypeCompFieldType || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCompFieldType, info, lChain, rChain)) {
                            info.setNeedsConversion(true);
                            lChain.previousState();
                            rChain.previousState();
                            return true;
                        }
                        lChain.previousState();
                        rChain.previousState();
                    }
                }
                info.setErrorStr(MessageFormat.format(NOCOMPATIBLEFIELD, temp.getTypename(), this.getTypename()));
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: 
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: 
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: {
                info.setErrorStr(NOTCOMPATIBLEANYTYPE);
                return false;
            }
        }
        return false;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "anytype.gif";
    }

    public void clear() {
        this.compFieldMap = new CompFieldMap();
        this.compFieldMap.setMyType(this);
        this.compFieldMap.setFullNameParent(this);
    }

    public void addComp(CompField field) {
        this.compFieldMap.addComp(field);
    }

    public boolean hasComponentWithName(String name) {
        if (this.compFieldMap.componentFieldMap == null) {
            return false;
        }
        return this.compFieldMap.componentFieldMap.containsKey(name);
    }

    public CompField getComponentByName(String name) {
        if (this.compFieldMap.componentFieldMap == null) {
            return null;
        }
        return this.compFieldMap.componentFieldMap.get(name);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        this.parseAttributes(timestamp);
        this.compFieldMap.check(timestamp);
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.ANYTYPE_VALUE);
                if (last.getIsErroneous(timestamp)) break;
                this.checkThisValueAnytype(timestamp, (Anytype_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.str_elem);
                break;
            }
            case ANYTYPE_VALUE: {
                this.checkThisValueAnytype(timestamp, (Anytype_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(ANYTYPEEXPECTED, this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueAnytype(CompilationTimeStamp timestamp, Anytype_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean strElem) {
        Identifier name = value.getName();
        if (!this.hasComponentWithName(name.getName())) {
            value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTUNION, name.getDisplayName(), this.getFullName()));
            this.setIsErroneous(true);
            return;
        }
        Type alternativeType = this.getComponentByName(name.getName()).getType();
        IValue alternativeValue = value.getValue();
        alternativeValue.setMyGovernor(alternativeType);
        alternativeValue = alternativeType.checkThisValueRef(timestamp, alternativeValue);
        alternativeType.checkThisValue(timestamp, alternativeValue, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, false, strElem));
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        if (ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST.equals((Object)template.getTemplatetype())) {
            Named_Template_List namedTemplateList = (Named_Template_List)template;
            int nofTemplates = namedTemplateList.getNofTemplates();
            if (nofTemplates != 1) {
                template.getLocation().reportSemanticError(ONEFIELDEXPECTED);
            }
            for (int i = 0; i < nofTemplates; ++i) {
                NamedTemplate namedTemplate = namedTemplateList.getTemplateByIndex(i);
                Identifier name = namedTemplate.getName();
                CompField field = this.compFieldMap.getCompWithName(name);
                if (field == null) continue;
                Type fieldType = field.getType();
                ITTCN3Template namedTemplateTemplate = namedTemplate.getTemplate();
                namedTemplateTemplate.setMyGovernor(fieldType);
                namedTemplateTemplate = fieldType.checkThisTemplateRef(timestamp, namedTemplateTemplate);
                ITTCN3Template.Completeness_type completeness = namedTemplateList.getCompletenessConditionChoice(timestamp, isModified, name);
                namedTemplateTemplate.checkThisTemplateGeneric(timestamp, fieldType, ITTCN3Template.Completeness_type.MAY_INCOMPLETE.equals((Object)completeness), false, false, true, implicitOmit);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return fieldType.getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, false);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return false;
                }
                int fieldIndex = this.compFieldMap.fields.indexOf(compField);
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                subrefsArray.add(fieldIndex);
                typeArray.add(this);
                return fieldType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return false;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return false;
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                if (this.compFieldMap == null) {
                    return false;
                }
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                typeArray.add(this);
                return fieldType.getFieldTypesAsArray(reference, actualSubReference + 1, typeArray);
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("anytype");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addProposal(propCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefixCaseInsensitive(subreference.getId().getName());
                for (CompField compField : compFields) {
                    String proposalKind = compField.getType().getProposalDescription(new StringBuilder()).toString();
                    propCollector.addProposal(compField.getIdentifier(), " - " + proposalKind, ImageCache.getImage(this.getOutlineIcon()), proposalKind);
                }
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addDeclaration(declarationCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefixCaseInsensitive(subreference.getId().getName());
                for (CompField compField : compFields) {
                    declarationCollector.addDeclaration(compField.getIdentifier().getDisplayName(), compField.getIdentifier().getLocation(), this);
                }
            }
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        this.compFieldMap.getEnclosingField(offset, rf);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.compFieldMap == null || this.compFieldMap.accept(v);
    }
}

