/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class OutOfMemoryCheck {
    private static final long DecimalMegaByte = 1000000L;
    private static boolean isOutOfMemory = false;
    public static final String OUTOFMEMORYERROR = "Free memory is running low. Syntactic and semantic check has been disabled. (Can be re-enabled in Window -> Preferences -> Titan preferences -> On-TheFly checker Preferences page)";

    public static boolean isOutOfMemoryAlreadyReported() {
        return isOutOfMemory;
    }

    public static void outOfMemoryEvent() {
        isOutOfMemory = true;
        ErrorReporter.logError((String)OUTOFMEMORYERROR);
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (OutOfMemoryErrorDialog.isDialogOpen) {
                        return;
                    }
                    Activator.getDefault().getPreferenceStore().setValue("org.eclipse.titan.designer.useOnTheFlyParsing", false);
                    OutOfMemoryErrorDialog.isDialogOpen = true;
                    OutOfMemoryErrorDialog dialog = new OutOfMemoryErrorDialog(null, "Low memory", OutOfMemoryCheck.OUTOFMEMORYERROR);
                    dialog.open();
                    OutOfMemoryErrorDialog.isDialogOpen = false;
                }
            });
        }
        GlobalParser.clearAllInformation();
        System.gc();
    }

    public static void resetOutOfMemoryflag() {
        isOutOfMemory = false;
    }

    public static boolean isOutOfMemory() {
        long total;
        long limit;
        Runtime Rt;
        long free;
        if (Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.checkForLowMemory") && (free = (Rt = Runtime.getRuntime()).freeMemory()) < (limit = Math.min(200000000L, Math.round((double)(total = Rt.totalMemory()) * 0.1)))) {
            ErrorReporter.logError((String)("limit: " + String.valueOf(limit) + ", free: " + String.valueOf(free)));
            return true;
        }
        return false;
    }

    private static class OutOfMemoryErrorDialog
    extends MessageDialog {
        private static volatile boolean isDialogOpen = false;

        public OutOfMemoryErrorDialog(Shell parent, String title, String message) {
            super(parent, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 1) {
                PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.titan.designer.preferences.pages.TITANPreferencePage", null, null).open();
            }
        }
    }
}

